/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.basic.Utils;
import fig.servlet.FieldListMap;
import fig.servlet.FileItem;
import fig.servlet.FileKeyMap;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.MyExceptions;
import fig.servlet.OperationRP;
import fig.servlet.Permissions;
import fig.servlet.ResponseObject;
import fig.servlet.ResponseParams;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.Value;
import fig.servlet.ValueProcessor;
import fig.servlet.WorkerItem;
import java.io.File;

public class ExecItem
extends Item {
    private static final int runningTimeoutMs = 300000;
    private static final int hardRunningTimeoutMs = 1800000;
    private boolean isDead;
    public boolean hasUpdated;
    public boolean immutable;
    private FileKeyMap fileKeyMap;

    public boolean isDead() {
        return this.isDead;
    }

    public ExecItem(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
        this.fileKeyMap = new FileKeyMap(sourcePath);
    }

    @Override
    protected Value getIntrinsicFieldValue(String fieldName) throws MyException {
        if (fieldName.equals("sinceLastModified")) {
            return this.getSinceLastModifiedTimeValue();
        }
        String value = this.fileKeyMap.get(fieldName);
        if (value != null) {
            if (fieldName.equals("output.map:exec.status")) {
                if (this.isThunk() && this.getThunkHasBeenQueued()) {
                    value = value + ".";
                }
                if (this.isThunk() && this.assignedToWorker()) {
                    value = value + "!";
                }
            }
            return new Value(value);
        }
        return super.getIntrinsicFieldValue(fieldName);
    }

    @Override
    protected void changeIntrinsicFieldValue(String fieldName, String value) throws MyException {
        if (this.fileKeyMap.put(fieldName, value)) {
            return;
        }
        super.changeIntrinsicFieldValue(fieldName, value);
    }

    public Value getSinceLastModifiedTimeValue() throws MyException {
        long lastModified = new File(this.sourcePath, "output.map").lastModified();
        Value value = FileItem.getSinceLastModifiedTimeValue(lastModified);
        if (this.isRunning() && FileItem.getSinceLastModifiedTime(lastModified) >= 300000L) {
            return new Value(value.value + "*", value.cmpKey);
        }
        return value;
    }

    private long getSinceLastModifiedTime() {
        long lastModified = new File(this.sourcePath, "output.map").lastModified();
        return FileItem.getSinceLastModifiedTime(lastModified);
    }

    public boolean isRunning() {
        String status = this.getStatus();
        return status == null || "running".equals(status) && this.getSinceLastModifiedTime() < 1800000L;
    }

    public boolean isThunk() {
        return "thunk".equals(this.getStatus());
    }

    public String getStatus() {
        return this.fileKeyMap.get("output.map:exec.status");
    }

    public boolean getThunkHasBeenQueued() throws MyException {
        return Boolean.parseBoolean(this.getIntrinsicFieldValue((String)"thunkHasBeenQueued").value);
    }

    public void setThunkHasBeenQueued(boolean thunkHasBeenQueued) throws MyException {
        this.changeIntrinsicFieldValue("thunkHasBeenQueued", "" + thunkHasBeenQueued);
    }

    public boolean assignedToWorker() throws MyException {
        return this.getIntrinsicFieldValue((String)"thunkWorker").value != null;
    }

    public void assignToWorker(WorkerItem worker) throws MyException {
        this.changeIntrinsicFieldValue("thunkWorker", worker.name);
    }

    @Override
    protected FieldListMap getMetadataFields() {
        return ExecItem.createDefaultFields();
    }

    public static FieldListMap createDefaultFields() {
        FieldListMap fields = new FieldListMap();
        fields.add((String)"info.map:Host", (String)"host", (String)"Host on which this execution happened").processor = new ValueProcessor("s/\\..*/");
        fields.add((String)"info.map:Date", (String)"date", (String)"When the execution began").processor = new ValueProcessor("DATE");
        fields.add((String)"sinceLastModified", (String)"last", (String)"Time since last modification").numeric = true;
        fields.add((String)"output.map:exec.memory", (String)"mem", (String)"Memory usage").numeric = true;
        fields.add((String)"output.map:exec.time", (String)"time", (String)"Execution time").numeric = true;
        Object[] objectArray = new Object[]{"$output.map:exec.errors", ",", "$output.map:exec.warnings"};
        fields.add((String)"numErrorsAndWarnings", (String)"err", (String)"Number of LogInfo warnings/errors", (Object[])objectArray).setNumeric((boolean)true).processor = new ValueProcessor("s/^,$//");
        fields.add("output.map:exec.status", "status", "Program status");
        fields.add((String)"options.map:exec.miscOptions", (String)"opts", (String)"Miscellaneous options").setMutable((boolean)true).rank = 2;
        fields.add((String)"options.map:log.note", (String)"note", (String)"Notes/comments about the execution").setMutable((boolean)true).rank = 10;
        return fields;
    }

    public static FieldListMap createThunkFields() {
        FieldListMap fields = new FieldListMap();
        fields.add("job.map:priority", "priority", "Priority (lower the better)").setMutable(true).setNumeric(true);
        fields.add("job.map:nice", "nice", "Nice value to run the command").setMutable(true).setNumeric(true);
        fields.add((String)"job.map:workingDir", (String)"workingDir", (String)"The current directory that the command is run").mutable = true;
        fields.add("job.map:reqMemory", "reqMemory", "Amount of memory required (MB)").setNumeric(true).setMutable(true);
        fields.add("job.map:command", "command", "Notes/comments about the execution").setMutable(true);
        return fields;
    }

    protected int getPriority() {
        return Utils.parseIntEasy(this.fileKeyMap.get("job.map:priority"), 0);
    }

    protected int getReqMemory() {
        return Utils.parseIntEasy(this.fileKeyMap.get("job.map:reqMemory"), 0);
    }

    protected int getNice() {
        return Utils.parseIntEasy(this.fileKeyMap.get("job.map:nice"), 0);
    }

    protected String getWorkingDir() {
        return this.fileKeyMap.get("job.map:workingDir");
    }

    protected String getCommand() {
        return this.fileKeyMap.get("job.map:command");
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        if (this.isDead) {
            return;
        }
        if (this.immutable && this.hasUpdated) {
            return;
        }
        this.fileKeyMap.clear();
        this.immutable = !this.isRunning() && !this.isThunk();
        this.hasUpdated = true;
        super.update(spec, priority);
    }

    public void kill() throws MyException {
        if (!IOUtils.createNewFileEasy(new File(this.sourcePath, "kill").toString())) {
            throw new MyException("Unable to kill " + this.name + " by creating a kill file");
        }
    }

    @Override
    public ResponseObject handleOperation(OperationRP req, Permissions perm) throws MyException {
        String op = req.op;
        if (op.equals("kill")) {
            this.kill();
            return new ResponseParams("Killed " + this.name);
        }
        if (op.equals("reload")) {
            this.immutable = false;
            return new ResponseParams("Reloading " + this.name);
        }
        return super.handleOperation(req, perm);
    }

    @Override
    protected boolean isView() {
        return false;
    }

    @Override
    public Item newItem(String name) throws MyException {
        throw MyExceptions.unsupported;
    }
}

