/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.Fmt;
import fig.basic.StrUtils;
import fig.basic.Utils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ValueProcessor {
    private List<Processor> processors = new ArrayList<Processor>();

    public ValueProcessor(String description) {
        if (description == null) {
            return;
        }
        for (String subStr : StrUtils.split(description, "\t")) {
            if (subStr.equals("DOUBLE")) {
                this.processors.add(new DoubleFormatProcessor());
                continue;
            }
            if (subStr.equals("DATE")) {
                this.processors.add(new DateFormatProcessor());
                continue;
            }
            if (subStr.equals("BYTES")) {
                this.processors.add(new BytesFormatProcessor());
                continue;
            }
            String[] tokens = StrUtils.split(subStr, "/");
            if (tokens.length == 0 || !tokens[0].equals("s")) continue;
            if (tokens.length == 2) {
                tokens = new String[]{tokens[0], tokens[1], "", ""};
            }
            if (tokens.length == 3) {
                tokens = new String[]{tokens[0], tokens[1], tokens[2], ""};
            }
            if (tokens.length != 4) continue;
            this.processors.add(new ReplaceProcessor(tokens[1], tokens[2], tokens[3].equals("g")));
        }
    }

    public String process(String s) {
        if (s == null) {
            return null;
        }
        for (Processor processor : this.processors) {
            s = processor.process(s);
        }
        return s;
    }

    public boolean isIdentity() {
        return this.processors.size() == 0;
    }

    public String toString() {
        return StrUtils.join(this.processors, "\t");
    }

    static class BytesFormatProcessor
    implements Processor {
        BytesFormatProcessor() {
        }

        @Override
        public String process(String s) {
            try {
                return Fmt.bytesToString(Long.parseLong(s));
            }
            catch (NumberFormatException e) {
                return s;
            }
        }
    }

    static class DateFormatProcessor
    implements Processor {
        private static final DateFormat standardDateFormat = new SimpleDateFormat("EEE MMM dd kk:mm:ss zzz yyyy");

        DateFormatProcessor() {
        }

        @Override
        public String process(String s) {
            try {
                Date d = standardDateFormat.parse(s);
                return Fmt.formatEasyDateTime(d.getTime());
            }
            catch (ParseException e) {
                return s;
            }
        }

        public String toString() {
            return "DATE";
        }
    }

    static class DoubleFormatProcessor
    implements Processor {
        DoubleFormatProcessor() {
        }

        @Override
        public String process(String s) {
            double x = Utils.parseDoubleEasy(s);
            if (Double.isNaN(x)) {
                return s;
            }
            return Fmt.D(x);
        }

        public String toString() {
            return "DOUBLE";
        }
    }

    static class ReplaceProcessor
    implements Processor {
        private final String a;
        private final String b;
        private final boolean global;

        public ReplaceProcessor(String a, String b, boolean global) {
            this.a = a;
            this.b = b;
            this.global = global;
        }

        @Override
        public String process(String s) {
            if (s == null) {
                return null;
            }
            if (this.global) {
                return s.replaceAll(this.a, this.b);
            }
            return s.replaceFirst(this.a, this.b);
        }

        public String toString() {
            return String.format("s/%s/%s/%s", this.a, this.b, this.global ? "g" : "");
        }
    }

    static interface Processor {
        public String process(String var1);
    }
}

