/*
 * Decompiled with CFR 0.152.
 */
package gep.model;

import gep.model.BaseMeasure;
import gep.model.Predictives;
import gep.model.SplitContext;
import gep.model.SufficientStatistics;
import java.util.Random;
import nuts.util.Counter;

public class SplitBaseMeasure
implements BaseMeasure<SplitContext, SplitContext> {
    private final double alpha0;
    private final int nSymbols;

    public SplitBaseMeasure(double alpha0, int nSymbols) {
        this.alpha0 = alpha0;
        this.nSymbols = nSymbols;
    }

    @Override
    public SplitContext sampleState(Random rand, SufficientStatistics<SplitContext, SplitContext> readWriteSuffStat, SufficientStatistics<SplitContext, SplitContext> readOnlySuffStats) {
        double unif = rand.nextDouble();
        Counter ssRW = readWriteSuffStat.getBaseMeasureStats();
        Counter ssR = readOnlySuffStats.getBaseMeasureStats();
        double nObs = ssRW.totalCount() + ssR.totalCount();
        Integer result = null;
        result = rand.nextDouble() < nObs / (nObs + this.alpha0) ? (Integer)Predictives.sampleCache(rand, ssRW, ssR) : Integer.valueOf(rand.nextInt(this.nSymbols));
        ssRW.incrementCount(result, 1.0);
        return new SplitContext(unif, result);
    }
}

