/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.ObservationsTracker;
import goblin.Taxon;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ma.MultiAlignment;
import nuts.io.IO;
import nuts.tui.Table;
import nuts.util.Arbre;
import nuts.util.Counter;
import nuts.util.CounterMap;
import nuts.util.EasyFormat;
import pepper.Edit;
import pepper.editmodel.Utils;

public class DerivationTree
implements Serializable {
    private static final long serialVersionUID = 7622225151173819466L;

    public static Arbre<DerivationNode> cutLineage(Arbre<LineagedNode> a) {
        return a.preOrderMap(new Cutter());
    }

    public static Arbre<DerivationNode> derivation(Arbre<LineagedNode> lineageTree) {
        return lineageTree.root().preOrderMap(new Lineage2DerivationMap()).root();
    }

    public static Arbre<LineagedNode> fullLineage(Arbre<DerivationNode> a) {
        return DerivationTree.lineage(a.root().copy(), new Window(0, a.getContents().getWord().length())).root();
    }

    public static Arbre<LineagedNode> maxLineage(Arbre<DerivationNode> anchor, int windowSize, ObservationsTracker obs) {
        int result = Integer.MIN_VALUE;
        Arbre<LineagedNode> argmax = null;
        for (Window cWin : DerivationTree.getWindows(anchor.getContents().word, windowSize)) {
            Arbre<LineagedNode> lineage = DerivationTree.lineage(anchor, cWin);
            int current = DerivationTree.width(lineage, obs);
            if (current <= result) continue;
            result = current;
            argmax = lineage;
        }
        return argmax;
    }

    public static List<Window> getWindows(String word, int maxWindowSize, Random rand) {
        List<Window> result = DerivationTree.getWindows(word, maxWindowSize);
        Collections.shuffle(result, rand);
        return result;
    }

    public static List<Window> getWindows(String word, int maxWindowSize) {
        ArrayList<Window> result = new ArrayList<Window>();
        int wordLength = word.length();
        int left = 0;
        while (left + maxWindowSize <= wordLength) {
            result.add(new Window(left, left + maxWindowSize));
            ++left;
        }
        if (result.size() == 0) {
            result.add(new Window(0, wordLength));
        }
        return result;
    }

    public static boolean hasObservedSupport(Arbre<DerivationNode> arbre, ObservationsTracker obs) {
        ObservedSupportDataStructure ds = new ObservedSupportDataStructure(arbre.root(), obs);
        for (Taxon lang : obs.observedLanguages()) {
            Arbre<DerivationNode> currentAnchor = DerivationTree.findNodeByLangName(arbre.root(), lang);
            for (Window cWin : DerivationTree.getWindows(currentAnchor.getContents().getWord(), 1)) {
                Arbre<LineagedNode> lineaged = DerivationTree.lineage(currentAnchor, cWin, false);
                for (Arbre<LineagedNode> lineagedSubtree : lineaged.nodes()) {
                    if (obs.isObserved(lineagedSubtree.getContents().derivationNode.language)) continue;
                    ds.update(lineagedSubtree.getContents());
                }
            }
        }
        return ds.isCovered();
    }

    public static String lineagesToString(Arbre<LineagedNode> lin) {
        StringBuilder builder = new StringBuilder();
        for (Arbre<LineagedNode> node : lin.nodes()) {
            if (node.isRoot()) continue;
            Window parentWindow = node.getParent().getContents().window;
            Window currentWindow = node.getContents().window;
            builder.append(node.getParent().getContents().derivationNode.language + " -> " + node.getContents().derivationNode.language + "\n");
            builder.append(node.getContents().derivationNode.derivationFromParent.toStringWithAnnotatedLineagedLetters(parentWindow, currentWindow) + "\n");
        }
        return builder.toString();
    }

    public static String derivationsToString(Arbre<DerivationNode> lin) {
        StringBuilder builder = new StringBuilder();
        for (Arbre<DerivationNode> node : lin.nodes()) {
            if (node.isRoot()) continue;
            builder.append(node.getParent().getContents().language + " -> " + node.getContents().language + "\n");
            builder.append(node.getContents().derivationFromParent.toString() + "\n");
        }
        return builder.toString();
    }

    public static Arbre<LineagedNode> lineage(Arbre<DerivationNode> modernWord, Window window, boolean isGenerous) {
        LineageMap map = new LineageMap(window, isGenerous);
        return modernWord.undirectedPreOrderMap(map).root();
    }

    public static Arbre<LineagedNode> lineage(Arbre<DerivationNode> modernWord, Window window) {
        return DerivationTree.lineage(modernWord, window, true);
    }

    public static int width(Arbre<LineagedNode> root, ObservationsTracker observedNodes) {
        return root.postOrderMap(new WidthMap(observedNodes)).getContents();
    }

    public static int width(Arbre<LineagedNode> root) {
        return DerivationTree.width(root, new ObservationsTracker());
    }

    public static Arbre<DerivationNode> findNodeByLangName(Arbre<DerivationNode> root, Taxon lang) {
        for (Arbre<DerivationNode> node : root.nodes()) {
            if (!node.getContents().getLanguage().equals(lang)) continue;
            return node;
        }
        throw new RuntimeException("Node not found:" + lang);
    }

    public static Arbre<LineagedNode> findLineagedNodeByLangName(Arbre<LineagedNode> root, Taxon lang) {
        for (Arbre<LineagedNode> node : root.nodes()) {
            if (!node.getContents().getDerivationNode().getLanguage().equals(lang)) continue;
            return node;
        }
        throw new RuntimeException("Node not found:" + lang);
    }

    public static boolean hasNodeWithLangName(Arbre<DerivationNode> root, Taxon lang) {
        for (Arbre<DerivationNode> node : root.nodes()) {
            if (!node.getContents().getLanguage().equals(lang)) continue;
            return true;
        }
        return false;
    }

    public static void checkConsistent(Arbre<DerivationNode> a) {
        DerivationTree._checkConsistent(a.root());
    }

    private static void _checkConsistent(Arbre<DerivationNode> a) {
        if (a.isRoot() && a.getContents().getDerivation() != null) {
            System.err.println("BAD0");
        }
        if (!a.isRoot() && a.getContents().getDerivation() == null) {
            System.err.println("BAD1");
        }
        if (!a.isRoot()) {
            Derivation d = a.getContents().getDerivation();
            if (d == null) {
                System.err.println("BAD-null");
            } else {
                if (!d.getCurrentWord().equals(a.getContents().getWord())) {
                    System.err.println("BAD2");
                }
                if (!d.getAncestorWord().equals(a.getParent().getContents().getWord())) {
                    System.err.println("BAD3");
                }
            }
        }
        for (Arbre<DerivationNode> c : a.getChildren()) {
            DerivationTree._checkConsistent(c);
        }
    }

    public static void saveDerivation(List<Arbre<DerivationNode>> derivations, String filePath) throws IOException {
        ObjectOutputStream oos = IOUtils.openBinOut(filePath);
        oos.writeObject(derivations);
        oos.close();
    }

    public static List<Arbre<DerivationNode>> restoreDerivations(String filePath) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = IOUtils.openBinIn(filePath);
        return (List)ois.readObject();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Execution.run(args, new DerivationTreeMain());
    }

    public static class DerivationTreeMain
    implements Runnable {
        @Option
        public String observationString = "!modern";
        @Option(required=true)
        public String serializedDerivationsPath;
        @Option
        public boolean showDerivation = false;
        @Option
        public int anchorWindowSize = 1;
        @Option
        public boolean showObservationSupported = false;

        public void go() throws Exception {
            Counter<Integer> counter = new Counter<Integer>();
            CounterMap<Taxon, Integer> counterByLang = new CounterMap<Taxon, Integer>();
            ObjectInputStream ois = IOUtils.openBinIn(this.serializedDerivationsPath);
            List trees = (List)ois.readObject();
            for (int i = 0; i < trees.size(); ++i) {
                Arbre current = (Arbre)trees.get(i);
                ObservationsTracker obs = ObservationsTracker.parseObservationsTracker(this.observationString, current);
                IO.so("Derivation " + i + ":");
                IO.so(current.deepToString());
                if (this.showObservationSupported) {
                    IO.so("Has observation support? : " + DerivationTree.hasObservedSupport(current, obs));
                }
                for (Arbre<DerivationNode> arbre : current.nodes()) {
                    if (!obs.isObserved(((DerivationNode)arbre.getContents()).language)) continue;
                    Arbre<LineagedNode> maxLineage = DerivationTree.maxLineage(arbre, this.anchorWindowSize, obs);
                    IO.so("Current anchor: " + arbre.getContents().language);
                    IO.so("Max window size: " + DerivationTree.width(maxLineage, obs));
                    IO.so("Attained by lineage:\n" + maxLineage.deepToString());
                    if (this.showDerivation) {
                        IO.so("Corresponding alignment:\n" + DerivationTree.lineagesToString(maxLineage));
                    }
                    counter.incrementCount(DerivationTree.width(maxLineage, obs), 1.0);
                    counterByLang.incrementCount(arbre.getContents().language, DerivationTree.width(maxLineage, obs), 1.0);
                    IO.so("---");
                }
                IO.so("===");
            }
            IO.so("Max window size\tNumber of words");
            counter.normalize();
            ArrayList keys = new ArrayList();
            keys.addAll(counter.keySet());
            Collections.sort(keys);
            for (Integer key : keys) {
                IO.so("" + key + "\t" + EasyFormat.fmt(counter.getCount(key)));
            }
            IO.so("\nBy anchor language:\n");
            for (Taxon lang : counterByLang.keySet()) {
                IO.so("For " + lang + ":\n");
                Counter current = counterByLang.getCounter(lang);
                current.normalize();
                for (Integer key : keys) {
                    IO.so("" + key + "\t" + EasyFormat.fmt(current.getCount(key)));
                }
            }
        }

        @Override
        public void run() {
            try {
                this.go();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class WindowSwap {
        private Window originalWindow;
        private String originalWord;
        private String substituteString;

        public WindowSwap(Window originalWindow, String originalWord, String substituteString) {
            if (!originalWindow.boundsCompatible(originalWord.length())) {
                throw new RuntimeException("Incompatible bounds in window swap creation");
            }
            this.originalWindow = originalWindow;
            this.originalWord = originalWord;
            this.substituteString = substituteString;
        }

        public Window swappedWindow() {
            int delta = this.deltaLength();
            return new Window(this.originalWindow.left(), this.originalWindow.right() + delta);
        }

        public String swappedWord() {
            StringBuilder result = new StringBuilder();
            result.append(this.originalWord.substring(0, this.originalWindow.left()));
            result.append(this.substituteString);
            result.append(this.originalWord.substring(this.originalWindow.right(), this.originalWord.length()));
            return result.toString();
        }

        public int deltaLength() {
            int originalWindowLength = this.originalWindow.right() - this.originalWindow.left();
            int newWindowLength = this.substituteString.length();
            return newWindowLength - originalWindowLength;
        }

        public boolean isSwapped(int originalIndex) {
            return this.originalWindow.contains(originalIndex);
        }

        public int newIndex(int originalIndex) {
            if (this.isSwapped(originalIndex)) {
                throw new RuntimeException("Error in newIndex");
            }
            if (originalIndex < this.originalWindow.left) {
                return originalIndex;
            }
            return originalIndex + this.deltaLength();
        }

        public String toString() {
            return this.originalWindow.toString(this.originalWord) + " -> " + this.swappedWindow().toString(this.swappedWord());
        }
    }

    public static final class Window
    implements Serializable {
        private static final long serialVersionUID = -493789047326279372L;
        private int left;
        private int right;

        public Window() {
            this(0, 0);
        }

        public Window(int left, int right) {
            if (left > right || left < 0) {
                throw new RuntimeException("left=" + left + ",right=" + right);
            }
            this.left = left;
            this.right = right;
        }

        public int left() {
            return this.left;
        }

        public int right() {
            return this.right;
        }

        public int length() {
            return this.right - this.left;
        }

        public boolean contains(int point) {
            return point >= this.left && point < this.right;
        }

        public String toString() {
            return "[" + this.left + "," + this.right + ")";
        }

        public boolean boundsCompatible(int wordLength) {
            return this.right <= wordLength;
        }

        public String toString(String word) {
            return word.substring(0, this.left) + "(" + word.substring(this.left, this.right) + ")" + word.substring(this.right, word.length());
        }

        public boolean equals(Object o) {
            if (!(o instanceof Window)) {
                return false;
            }
            Window o_cast = (Window)o;
            return o_cast.left == this.left && o_cast.right == this.right;
        }

        public String slice(String word) {
            return word.substring(this.left, this.right);
        }

        public Window enlarge(int wordLength, double delta) {
            int left = (int)Math.max(0.0, (double)this.left() - delta);
            int right = (int)Math.min((double)wordLength, (double)this.right() + delta);
            return new Window(left, right);
        }
    }

    public static final class Derivation
    implements Serializable {
        private static final long serialVersionUID = -8207543758229656446L;
        private int[] ancestors;
        private String ancestorWord;
        private String currentWord;
        public static final int INSERTED = -1;

        protected Derivation() {
        }

        public Derivation(Derivation old, String newBotWord) {
            if (newBotWord.length() != old.currentWord.length()) {
                throw new RuntimeException();
            }
            this.ancestors = old.ancestors;
            this.ancestorWord = old.ancestorWord;
            this.currentWord = newBotWord;
        }

        public Derivation(int[] ancestors, String ancestorWord, String currentWord) {
            this.ancestors = ancestors;
            this.ancestorWord = ancestorWord;
            this.currentWord = currentWord;
            if (!this.isConsitent()) {
                throw new RuntimeException("Inconsistent derivation");
            }
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.ancestorWord.hashCode();
            result = 31 * result + Arrays.hashCode(this.ancestors);
            result = 31 * result + this.currentWord.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Derivation)) {
                return false;
            }
            Derivation od = (Derivation)o;
            return od.ancestorWord.equals(this.ancestorWord) && od.currentWord.equals(this.currentWord) && Arrays.equals(od.ancestors, this.ancestors);
        }

        public String alignmentToString() {
            return Arrays.toString(this.ancestors).replaceAll("-1", "X");
        }

        public boolean isConsitent() {
            return this.ancestorWord != null && this.currentWord != null && this.ancestors.length == this.currentWord.length();
        }

        public String getAncestorWord() {
            return this.ancestorWord;
        }

        public String getCurrentWord() {
            return this.currentWord;
        }

        public Derivation windowSwap(WindowSwap topSwap, WindowSwap bottomSwap) {
            int a;
            if (!topSwap.originalWord.equals(this.ancestorWord) || !bottomSwap.originalWord.equals(this.currentWord)) {
                throw new RuntimeException("Inconsistent windowswap");
            }
            String swappedAncestorWord = topSwap.swappedWord();
            String swappedCurrentWord = bottomSwap.swappedWord();
            int[] swappedAncestors = new int[swappedCurrentWord.length()];
            for (a = 0; a < swappedAncestors.length; ++a) {
                swappedAncestors[a] = -1;
            }
            for (a = 0; a < this.ancestors.length; ++a) {
                if (bottomSwap.isSwapped(a)) continue;
                assert (!topSwap.originalWindow.contains(this.ancestors[a]));
                swappedAncestors[bottomSwap.newIndex((int)a)] = topSwap.newIndex(this.ancestors[a]);
            }
            Derivation result = new Derivation(swappedAncestors, swappedAncestorWord, swappedCurrentWord);
            assert (result.isMonotonic());
            return result;
        }

        public static Derivation editList2Derivation(List<Edit> edits) {
            String parent = Utils.topWord(edits);
            String current = Utils.bottomWord(edits);
            int[] ancestors = new int[current.length()];
            int cursor = 0;
            for (int i = 0; i < parent.length(); ++i) {
                Edit cEdit = edits.get(i);
                if (cEdit.isDeletion()) continue;
                if (cEdit.isSubstitution()) {
                    ancestors[cursor++] = i;
                    continue;
                }
                if (cEdit.isLeftInsertion()) {
                    ancestors[cursor++] = -1;
                    ancestors[cursor++] = i;
                    continue;
                }
                if (cEdit.isRightInsertion()) {
                    ancestors[cursor++] = i;
                    ancestors[cursor++] = -1;
                    continue;
                }
                throw new RuntimeException("Undefined edit type");
            }
            return new Derivation(ancestors, parent, current);
        }

        public int ancestor(int phonemeIndex) {
            int result = this.ancestors[phonemeIndex];
            if (result == -1) {
                throw new RuntimeException("Called ancestor(int) with inserted index");
            }
            return result;
        }

        public boolean hasAncestor(int phonemeIndex) {
            if (phonemeIndex >= this.ancestors.length) {
                throw new RuntimeException("Out of bound phoneme index in hasAncestor()");
            }
            return this.ancestors[phonemeIndex] != -1;
        }

        public Derivation invert() {
            int i;
            int[] reversed = new int[this.ancestorWord.length()];
            for (i = 0; i < reversed.length; ++i) {
                reversed[i] = -1;
            }
            for (i = 0; i < this.ancestors.length; ++i) {
                if (!this.hasAncestor(i)) continue;
                reversed[this.ancestor((int)i)] = i;
            }
            Derivation result = new Derivation(reversed, this.currentWord, this.ancestorWord);
            return result;
        }

        public boolean isMonotonic() {
            int last = 0;
            for (int i = 0; i < this.currentWord.length(); ++i) {
                if (this.hasAncestor(i) && this.ancestor(i) < last) {
                    return false;
                }
                if (!this.hasAncestor(i)) continue;
                last = this.ancestor(i);
            }
            return true;
        }

        public Window project(Window window, boolean useGenerousProjection) {
            if (!window.boundsCompatible(this.currentWord.length())) {
                throw new RuntimeException("Incompatible window projection: window=" + window + ",wordLength=" + this.currentWord.length());
            }
            if (!useGenerousProjection) {
                if (window.length() > 1) {
                    throw new UnsupportedOperationException();
                }
                if (window.length() == 0) {
                    return new Window();
                }
                int pos = window.left();
                if (this.hasAncestor(pos)) {
                    return new Window(this.ancestor(pos), this.ancestor(pos) + 1);
                }
                return new Window();
            }
            if (!this.isMonotonic()) {
                throw new RuntimeException("Non monotonic derivations not supported: " + Arrays.toString(this.ancestors));
            }
            int left = 0;
            for (int i = window.left() - 1; i >= 0 && left == 0; --i) {
                if (!this.hasAncestor(i)) continue;
                left = this.ancestor(i) + 1;
            }
            int right = this.ancestorWord.length();
            for (int i = window.right(); i < this.currentWord.length() && right == this.ancestorWord.length(); ++i) {
                if (!this.hasAncestor(i)) continue;
                right = this.ancestor(i);
            }
            Window result = new Window(left, right);
            assert (result.boundsCompatible(this.ancestorWord.length()));
            return result;
        }

        public Window project(Window window) {
            return this.project(window, true);
        }

        public String toString() {
            return MultiAlignment.inducedMultiAlignment(new Taxon("top"), new Taxon("bottom"), this).toString();
        }

        public String toStringWithAnnotatedLineagedLetters(final Window ancestorWindow, final Window currentWindow) {
            return new Table(new Table.Populator(){

                @Override
                public void populate() {
                    int i;
                    for (i = 0; i < ancestorWord.length(); ++i) {
                        this.set(0, 1 + i, "" + ancestorWord.charAt(i) + (ancestorWindow.contains(i) ? "!" : ""));
                    }
                    for (i = 0; i < currentWord.length(); ++i) {
                        this.set(1 + i, 0, "" + currentWord.charAt(i) + (currentWindow.contains(i) ? "!" : ""));
                        if (!this.hasAncestor(i)) continue;
                        this.set(1 + i, 1 + this.ancestor(i), "X");
                    }
                }
            }).toString();
        }
    }

    private static class WidthMap
    extends Arbre.ArbreMap<LineagedNode, Integer> {
        private final ObservationsTracker observations;

        private WidthMap(ObservationsTracker observations) {
            this.observations = observations;
        }

        @Override
        public Integer map(Arbre<LineagedNode> currentDomainNode) {
            int current = currentDomainNode.getContents().window.length();
            if (this.observations.isObserved(currentDomainNode.getContents().getDerivationNode().getLanguage())) {
                current = 0;
            }
            if (this.getChildImage().size() == 0) {
                return current;
            }
            return Math.max(current, (Integer)Collections.max(this.getChildImage()));
        }
    }

    private static class LineageMap
    extends Arbre.ArbreMap<DerivationNode, LineagedNode> {
        private final boolean isGenerous;
        private final Window seed;

        private LineageMap(Window seed, boolean isGenerous) {
            this.seed = seed;
            this.isGenerous = isGenerous;
        }

        @Override
        public LineagedNode map(Arbre<DerivationNode> currentDomainNode) {
            if (this.getCallerImage() == null) {
                return new LineagedNode(currentDomainNode.getContents(), this.seed);
            }
            if (!this.isCallerParent()) {
                return new LineagedNode(currentDomainNode.getContents(), ((LineagedNode)this.getCallerImage()).derivationNode.derivationFromParent.project(((LineagedNode)this.getCallerImage()).window, this.isGenerous));
            }
            LineagedNode callerImage = (LineagedNode)this.getCallerImage();
            Derivation currentDerivation = currentDomainNode.getContents().derivationFromParent;
            Derivation inverseDerivation = currentDerivation.invert();
            Window prjWindow = inverseDerivation.project(callerImage.window, this.isGenerous);
            return new LineagedNode(currentDomainNode.getContents(), prjWindow);
        }
    }

    private static class ObservedSupportDataStructure {
        private final Map<Taxon, boolean[]> currentCover = new HashMap<Taxon, boolean[]>();
        private int nCovered = 0;
        private final int nToCover;

        private ObservedSupportDataStructure(Arbre<DerivationNode> arbre, ObservationsTracker obs) {
            int nToCover = 0;
            for (Arbre<DerivationNode> subtree : arbre.nodes()) {
                DerivationNode current = subtree.getContents();
                if (obs.isObserved(current.language)) continue;
                int wordL = current.getWord().length();
                nToCover += wordL;
                this.currentCover.put(current.language, new boolean[wordL]);
            }
            this.nToCover = nToCover;
        }

        private void update(LineagedNode node) {
            boolean[] covered = this.currentCover.get(node.derivationNode.language);
            if (covered == null) {
                covered = new boolean[node.derivationNode.word.length()];
                this.currentCover.put(node.derivationNode.language, covered);
            }
            for (int i = node.window.left(); i < node.window.right(); ++i) {
                if (covered[i]) continue;
                covered[i] = true;
                ++this.nCovered;
                assert (this.nCovered <= this.nToCover);
            }
        }

        private boolean isCovered() {
            assert (this.nCovered <= this.nToCover);
            return this.nCovered == this.nToCover;
        }
    }

    private static class Lineage2DerivationMap
    extends Arbre.ArbreMap<LineagedNode, DerivationNode> {
        private Lineage2DerivationMap() {
        }

        @Override
        public DerivationNode map(Arbre<LineagedNode> lin) {
            return lin.getContents().derivationNode;
        }
    }

    public static class LineagedNode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DerivationNode derivationNode;
        private Window window;

        public LineagedNode(DerivationNode derivationNode, Window window) {
            if (!window.boundsCompatible(derivationNode.getWord().length())) {
                throw new RuntimeException("Bound incompatible in LineageNode creation. L=" + derivationNode.getWord().length() + ", " + window.right);
            }
            this.derivationNode = derivationNode;
            this.window = window;
        }

        public DerivationNode getDerivationNode() {
            return this.derivationNode;
        }

        public Window getWindow() {
            return this.window;
        }

        public String toString() {
            return this.derivationNode.language + ":" + this.window.toString(this.derivationNode.word);
        }
    }

    private static class Cutter
    extends Arbre.ArbreMap<LineagedNode, DerivationNode> {
        private Cutter() {
        }

        @Override
        public DerivationNode map(Arbre<LineagedNode> currentDomainNode) {
            Window oldW = currentDomainNode.getContents().getWindow();
            String word = oldW.slice(currentDomainNode.getContents().getDerivationNode().getWord());
            Taxon lang = currentDomainNode.getContents().getDerivationNode().getLanguage();
            Derivation d = null;
            if (!currentDomainNode.isRoot()) {
                Derivation oldD = currentDomainNode.getContents().getDerivationNode().getDerivation();
                Window pW = currentDomainNode.getParent().getContents().getWindow();
                int[] ancestors = new int[word.length()];
                for (int op = oldW.left(); op < oldW.right(); ++op) {
                    ancestors[op - oldW.left()] = oldD.hasAncestor(op) ? oldD.ancestor(op) - pW.left() : -1;
                }
                d = new Derivation(ancestors, currentDomainNode.getParent().getContents().getDerivationNode().getWord(), word);
            }
            return new DerivationNode(lang, word, d);
        }
    }

    public static class DerivationNode
    implements Serializable {
        private static final long serialVersionUID = 7686949734681169426L;
        private Taxon language;
        private Derivation derivationFromParent = null;
        private String word;
        public static final int TRIM_LONG_WORDS_THRESHOLD = 20;

        public String getWord() {
            return this.word;
        }

        public Taxon getLanguage() {
            return this.language;
        }

        public Derivation getDerivation() {
            return this.derivationFromParent;
        }

        public DerivationNode(Taxon language, String word, Derivation derivationFromParent) {
            this.language = language;
            this.derivationFromParent = derivationFromParent;
            this.word = word;
        }

        public DerivationNode(Taxon language, String word) {
            this.language = language;
            this.word = word;
        }

        protected DerivationNode() {
        }

        public String toString() {
            return this.language + ":" + DerivationNode.trimLongWords(this.word, 20);
        }

        public static String trimLongWords(String string, int length) {
            if (string == null) {
                return "null";
            }
            if (string.length() < length + 4) {
                return string;
            }
            return string.substring(0, length) + "...";
        }
    }
}

