/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.NumUtils;
import fig.prob.SampleUtils;
import goblin.DerivationTree;
import goblin.HLParams;
import goblin.Taxon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import ma.LongGapAlignmentSampler;
import ma.RateMatrixLoader;
import nuts.math.MeasureZeroException;
import nuts.math.RateMtxUtils;
import nuts.math.Sampling;
import nuts.maxent.SloppyMath;
import nuts.util.Arbre;
import nuts.util.MathUtils;
import nuts.util.Tree;
import pepper.Encodings;

public final class AffineGapAlignmentSampler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int M;
    private final int N;
    public static final char DUMMY = '#';
    private final String topWord;
    private final String bottomWord;
    private final double[][][] survTable;
    private final double[][][] deathTable;
    private final double[][] table;
    private final AffineGapAlignmentSamplerParamsAdaptor params;
    private boolean logMode = false;
    private boolean tableInsured = false;
    private double exponent = 1.0;
    public static boolean useSloppyMath = false;
    public static final double MAX_ANNEAL_EXP = 100.0;

    public void activateLogMode() {
        if (this.tableInsured) {
            throw new RuntimeException("Cannot activate log mode after insuring tables");
        }
        this.logMode = true;
    }

    public void setExponent(double annealingCoef) {
        if (annealingCoef < 0.0) {
            throw new RuntimeException("Negative annealingCoef");
        }
        if (this.tableInsured) {
            throw new RuntimeException("Cannot set anneal exp after insuring tables");
        }
        this.exponent = annealingCoef;
    }

    public static final double slog(double a) {
        return useSloppyMath ? SloppyMath.approxLog(a) : Math.log(a);
    }

    private double logAnneal(double a) {
        return this.exponent * AffineGapAlignmentSampler.slog(a);
    }

    private double logAdd(double a, double b) {
        double result = SloppyMath.logAdd(a, b);
        return result;
    }

    private double logAdd(double[] prs) {
        double result = SloppyMath.logAdd(prs);
        return result;
    }

    private double anneal(double x) {
        if (this.exponent == 1.0) {
            return x;
        }
        return Math.pow(x, this.exponent);
    }

    public static AffineGapAlignmentSampler createContextSensitiveAlignmentSampler(String top, String bot, double[][] subPrs) {
        top = AffineGapAlignmentSampler.pad(top);
        bot = AffineGapAlignmentSampler.pad(bot);
        return new AffineGapAlignmentSampler(top, bot, new ContextSensitiveAlignmentParam(subPrs), null, null, null);
    }

    private static AffineGapAlignmentSampler createHLAlignmentSampler(String top, DerivationTree.Window topWin, String bot, DerivationTree.Window botWin, DerivationTree.Derivation d, HLParams.HLBranchParams params, double[][][] defaultSurv, double[][][] defaultDeath, double[][] defaultTable) {
        String processedTop = AffineGapAlignmentSampler.specialPad(top, topWin, params.getEncodings(), d, true);
        String processedBot = AffineGapAlignmentSampler.specialPad(bot, botWin, params.getEncodings(), d, false);
        return new AffineGapAlignmentSampler(processedTop, processedBot, new HLParamsAdaptor(processedTop, processedBot, AffineGapAlignmentSampler.insertedSuffix(d, botWin, bot), params), defaultSurv, defaultDeath, defaultTable);
    }

    public static AffineGapAlignmentSampler createHLAlignmentSampler(DerivationTree.Window topWin, DerivationTree.Window botWin, DerivationTree.Derivation d, HLParams.HLBranchParams params, double[][][] defaultSurv, double[][][] defaultDeath, double[][] defaultTable) {
        return AffineGapAlignmentSampler.createHLAlignmentSampler(d.getAncestorWord(), topWin, d.getCurrentWord(), botWin, d, params, defaultSurv, defaultDeath, defaultTable);
    }

    public static AffineGapAlignmentSampler createHLAlignmentSampler(DerivationTree.Window topWin, DerivationTree.Window botWin, DerivationTree.Derivation d, HLParams.HLBranchParams params) {
        return AffineGapAlignmentSampler.createHLAlignmentSampler(topWin, botWin, d, params, null, null, null);
    }

    private static String insertedSuffix(DerivationTree.Derivation d, DerivationTree.Window botWin, String botWord) {
        String result = "";
        for (int pos = botWin.right(); pos < botWord.length() && !d.hasAncestor(pos); ++pos) {
            result = result + d.getCurrentWord().charAt(pos);
        }
        return result;
    }

    public static AffineGapAlignmentSampler createHLAlignmentSampler(String top, String bot, HLParams.HLBranchParams params) {
        return AffineGapAlignmentSampler.createHLAlignmentSampler(top, new DerivationTree.Window(0, top.length()), bot, new DerivationTree.Window(0, bot.length()), null, params, null, null, null);
    }

    private static String specialPad(String str, DerivationTree.Window win, Encodings enc, DerivationTree.Derivation d, boolean isTop) {
        String sliced = win.slice(str);
        String BOUNDARY = "" + enc.phoneId2Char(enc.getBoundaryPhoneId());
        if (win.left() == 0 || str.length() == 0) {
            return BOUNDARY + sliced;
        }
        if (isTop) {
            int t;
            DerivationTree.Derivation inv = d.invert();
            for (t = win.left() - 1; t >= 0 && !inv.hasAncestor(t); --t) {
            }
            if (t >= 0 && inv.hasAncestor(t)) {
                return "" + str.charAt(t) + sliced;
            }
            return BOUNDARY + sliced;
        }
        return "" + str.charAt(win.left() - 1) + sliced;
    }

    public static AffineGapAlignmentSampler createAffineGapAlignmentSampler(String top, String bottom, GapAlignmentParams params) {
        String processedTop = AffineGapAlignmentSampler.pad(top);
        String processedBottom = AffineGapAlignmentSampler.pad(bottom);
        AffineGapAlignmentSamplerParamsAdaptor adaptor = null;
        if (params instanceof DiscreteAffineGapParameters) {
            adaptor = new DiscreteAffineGapParamsAdaptor((DiscreteAffineGapParameters)params, processedTop, processedBottom);
        } else if (params instanceof LongGapAlignmentSampler.LongGapAlignmentSamplerParams) {
            adaptor = new LongGapParamAdaptor((LongGapAlignmentSampler.LongGapAlignmentSamplerParams)params, processedTop, processedBottom);
        } else if (params instanceof CompiledTKFParams) {
            adaptor = new TKF91Adaptor((CompiledTKFParams)params, processedTop, processedBottom);
        } else {
            if (params instanceof HLParams.HLBranchParams) {
                return AffineGapAlignmentSampler.createHLAlignmentSampler(top, bottom, (HLParams.HLBranchParams)params);
            }
            throw new RuntimeException(params.toString());
        }
        return new AffineGapAlignmentSampler(processedTop, processedBottom, adaptor, null, null, null);
    }

    private static String pad(String str) {
        return '#' + str;
    }

    private AffineGapAlignmentSampler(String processedTopWord, String processedBottomWord, AffineGapAlignmentSamplerParamsAdaptor params, double[][][] defaultSurv, double[][][] defaultDeath, double[][] defaultTable) {
        this.topWord = processedTopWord;
        this.bottomWord = processedBottomWord;
        this.M = this.topWord.length();
        this.N = this.bottomWord.length();
        if (this.defaultArrayOk(defaultSurv) && this.defaultArrayOk(defaultDeath) && this.defaultArrayOk(defaultTable)) {
            if (defaultSurv == defaultDeath) {
                throw new RuntimeException();
            }
            this.survTable = defaultSurv;
            this.deathTable = defaultDeath;
            this.table = defaultTable;
        } else {
            this.survTable = new double[3][this.M][this.N];
            this.deathTable = new double[3][this.M][this.N];
            this.table = new double[this.M][this.N];
        }
        this.params = params;
    }

    private boolean defaultArrayOk(double[][] arr) {
        if (arr == null) {
            return false;
        }
        return arr.length >= this.M && arr[0].length >= this.N;
    }

    private boolean defaultArrayOk(double[][][] arr) {
        if (arr == null) {
            return false;
        }
        return arr.length == 3 && arr[0].length >= this.M && arr[0][0].length >= this.N;
    }

    public double getSumLogPr() {
        if (this.exponent != 1.0) {
            throw new RuntimeException("weird question you're asking");
        }
        this.insureTables();
        double result = this.logMode ? this.table[this.M - 1][this.N - 1] : AffineGapAlignmentSampler.slog(this.table[this.M - 1][this.N - 1]);
        return result;
    }

    public double getSumPr() {
        if (this.exponent != 1.0) {
            throw new RuntimeException("weird question you're asking");
        }
        this.insureTables();
        double result = this.logMode ? Math.exp(this.table[this.M - 1][this.N - 1]) : this.table[this.M - 1][this.N - 1];
        return result;
    }

    private void insureDPTables() {
        for (int m = 0; m < this.M; ++m) {
            for (int n = 0; n < this.N; ++n) {
                this.deathTable[0][m][n] = this.anneal(this.params.pr(true, 0, m, n)) * (m == 0 ? 0.0 : this.table[m - 1][n]);
                this.deathTable[1][m][n] = this.anneal(this.params.pr(true, 1, m, n)) * (m == 0 || n == 0 ? 0.0 : this.table[m - 1][n - 1]);
                this.survTable[0][m][n] = this.anneal(this.params.pr(false, 0, m, n)) * (m == 0 || n == 0 ? 1.0 : this.table[m - 1][n - 1]);
                this.deathTable[2][m][n] = this.anneal(this.params.condSecondInsertPr(m, n)) * (n < 2 ? 0.0 : this.deathTable[2][m][n - 1] + this.deathTable[1][m][n - 1]);
                this.survTable[1][m][n] = this.anneal(this.params.condFirstInsertPr(m, n)) * (n == 0 ? 0.0 : this.survTable[0][m][n - 1]);
                this.survTable[2][m][n] = this.anneal(this.params.condSecondInsertPr(m, n)) * (n < 2 ? 0.0 : this.survTable[2][m][n - 1] + this.survTable[1][m][n - 1]);
                this.table[m][n] = this.deathTable[0][m][n] + this.deathTable[1][m][n] + this.survTable[0][m][n] + this.deathTable[2][m][n] + this.survTable[1][m][n] + this.survTable[2][m][n];
            }
        }
    }

    private void insureLogDPTables() {
        int n;
        int m;
        double[] dummyArray = new double[6];
        for (m = 0; m < this.M; ++m) {
            for (n = 0; n < this.N; ++n) {
                this.table[m][n] = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < 3; ++i) {
                    this.deathTable[i][m][n] = Double.NEGATIVE_INFINITY;
                    this.survTable[i][m][n] = Double.NEGATIVE_INFINITY;
                }
            }
        }
        for (m = 0; m < this.M; ++m) {
            for (n = 0; n < this.N; ++n) {
                this.deathTable[0][m][n] = this.logAnneal(this.params.pr(true, 0, m, n)) + (m == 0 ? Double.NEGATIVE_INFINITY : this.table[m - 1][n]);
                this.deathTable[1][m][n] = this.logAnneal(this.params.pr(true, 1, m, n)) + (m == 0 || n == 0 ? Double.NEGATIVE_INFINITY : this.table[m - 1][n - 1]);
                this.survTable[0][m][n] = this.logAnneal(this.params.pr(false, 0, m, n)) + (m == 0 || n == 0 ? 0.0 : this.table[m - 1][n - 1]);
                this.deathTable[2][m][n] = this.logAnneal(this.params.condSecondInsertPr(m, n)) + (n < 2 ? Double.NEGATIVE_INFINITY : this.logAdd(this.deathTable[2][m][n - 1], this.deathTable[1][m][n - 1]));
                this.survTable[1][m][n] = this.logAnneal(this.params.condFirstInsertPr(m, n)) + (n == 0 ? Double.NEGATIVE_INFINITY : this.survTable[0][m][n - 1]);
                this.survTable[2][m][n] = this.logAnneal(this.params.condSecondInsertPr(m, n)) + (n < 2 ? Double.NEGATIVE_INFINITY : this.logAdd(this.survTable[2][m][n - 1], this.survTable[1][m][n - 1]));
                dummyArray[0] = this.deathTable[0][m][n];
                dummyArray[1] = this.deathTable[1][m][n];
                dummyArray[2] = this.survTable[0][m][n];
                dummyArray[3] = this.deathTable[2][m][n];
                dummyArray[4] = this.survTable[1][m][n];
                dummyArray[5] = this.survTable[2][m][n];
                this.table[m][n] = this.logAdd(dummyArray);
            }
        }
    }

    private void insureTables() {
        if (this.tableInsured) {
            return;
        }
        if (this.logMode) {
            this.insureLogDPTables();
        } else {
            this.insureDPTables();
        }
        this.tableInsured = true;
    }

    public DerivationTree.Derivation sample(Random rand) throws MeasureZeroException {
        this.insureTables();
        if (this.logMode && this.table[this.M - 1][this.N - 1] == Double.NEGATIVE_INFINITY) {
            throw new MeasureZeroException();
        }
        if (!this.logMode && this.table[this.M - 1][this.N - 1] == 0.0) {
            this.tableInsured = false;
            this.activateLogMode();
            return this.sample(rand);
        }
        int[] ancestors = new int[this.N];
        for (int i = 0; i < ancestors.length; ++i) {
            ancestors[i] = -1;
        }
        int n = this.N;
        for (int m = this.M - 1; m >= 0; --m) {
            n = this.sample(rand, ancestors, m, n);
        }
        return new DerivationTree.Derivation(this.removeDummies(ancestors), this.removeDummies(this.topWord), this.removeDummies(this.bottomWord));
    }

    public DerivationTree.Derivation mode() throws MeasureZeroException {
        if (!this.logMode || this.exponent != 100.0) {
            this.activateLogMode();
            this.setExponent(100.0);
        }
        Random rand = new Random(1L);
        return this.sample(rand);
    }

    private int[] removeDummies(int[] ancestors) {
        int[] result = new int[ancestors.length - 1];
        for (int i = 0; i < result.length; ++i) {
            if (ancestors[i + 1] == -1) {
                result[i] = -1;
                continue;
            }
            int initial = ancestors[i + 1];
            if (initial == 0) {
                throw new RuntimeException("Internal error in removeDummy");
            }
            result[i] = initial - 1;
        }
        return result;
    }

    private String removeDummies(String str) {
        return str.substring(1, str.length());
    }

    private double[] compiledConditionals(int n, int m) {
        double[] compiledConditionals = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            compiledConditionals[i] = this.logMode ? this.logAnneal(this.params.condSecondInsertPr(m, i)) + (i == n - 1 ? 0.0 : compiledConditionals[i + 1]) : this.anneal(this.params.condSecondInsertPr(m, i)) * (i == n - 1 ? 1.0 : compiledConditionals[i + 1]);
        }
        return compiledConditionals;
    }

    private int sample(Random rand, int[] ancestors, final int m, final int n) {
        final class Decision {
            private final boolean dies;
            private final int leftmost;

            Decision(boolean dies, int leftmost) {
                this.dies = dies;
                this.leftmost = leftmost;
            }

            private double score() {
                if (this.dies) {
                    if (this.leftmost == n) {
                        return AffineGapAlignmentSampler.this.deathTable[0][m][n - 1];
                    }
                    if (this.leftmost == n - 1) {
                        return AffineGapAlignmentSampler.this.deathTable[1][m][n - 1];
                    }
                    if (this.leftmost < n - 1) {
                        return AffineGapAlignmentSampler.this.logMode ? AffineGapAlignmentSampler.this.deathTable[1][m][this.leftmost] + compiledConditionals[this.leftmost + 1] : AffineGapAlignmentSampler.this.deathTable[1][m][this.leftmost] * compiledConditionals[this.leftmost + 1];
                    }
                    throw new RuntimeException("Internal error 1 in Decision");
                }
                if (this.leftmost == n - 1) {
                    return AffineGapAlignmentSampler.this.survTable[0][m][n - 1];
                }
                if (this.leftmost == n - 2) {
                    return AffineGapAlignmentSampler.this.survTable[1][m][n - 1];
                }
                if (this.leftmost < n - 2) {
                    return AffineGapAlignmentSampler.this.logMode ? AffineGapAlignmentSampler.this.survTable[1][m][this.leftmost + 1] + compiledConditionals[this.leftmost + 2] : AffineGapAlignmentSampler.this.survTable[1][m][this.leftmost + 1] * compiledConditionals[this.leftmost + 2];
                }
                throw new RuntimeException("Internal error 2 in Decision");
            }
        }
        Decision decision;
        final double[] compiledConditionals = this.compiledConditionals(n, m);
        ArrayList<Decision> decisions = new ArrayList<Decision>();
        ArrayList<Double> prs = new ArrayList<Double>();
        for (int leftmost = 0; leftmost <= n; ++leftmost) {
            if (leftmost < n) {
                Decision currentSurv = new Decision(false, leftmost);
                decisions.add(currentSurv);
                prs.add(currentSurv.score());
            }
            Decision currentDeath = new Decision(true, leftmost);
            decisions.add(currentDeath);
            prs.add(currentDeath.score());
        }
        if (this.logMode) {
            Sampling.scaleExp(prs);
        }
        if (!(decision = (Decision)decisions.get(Sampling.sample(rand, prs))).dies) {
            ancestors[((Decision)decision).leftmost] = m;
        }
        return decision.leftmost;
    }

    private static double[][] compileSubstitutionCosts(Encodings enc, double[][] matrix, String topWord, String bottomWord) {
        double[][] result = new double[topWord.length()][bottomWord.length()];
        for (int m = 0; m < topWord.length(); ++m) {
            for (int n = 0; n < bottomWord.length(); ++n) {
                if (m == 0 || n == 0) {
                    result[m][n] = 0.0;
                    continue;
                }
                int i = enc.char2PhoneId(topWord.charAt(m));
                int j = enc.char2PhoneId(bottomWord.charAt(n));
                if (i == -1) {
                    throw new RuntimeException("Bad char: " + topWord.charAt(m) + ", seqn is " + topWord);
                }
                if (j == -1) {
                    throw new RuntimeException("Bad char: " + bottomWord.charAt(n) + ", seqn is " + bottomWord);
                }
                result[m][n] = matrix[i][j];
            }
        }
        return result;
    }

    private static double[] compileInsertionsCosts(Encodings enc, double[] matrix, String bottomWord) {
        double[] result = new double[bottomWord.length()];
        for (int n = 0; n < bottomWord.length(); ++n) {
            if (n == 0) {
                result[n] = 0.0;
                continue;
            }
            int j = enc.char2PhoneId(bottomWord.charAt(n));
            result[n] = matrix[j];
        }
        return result;
    }

    public static double alpha(double mu, double t) {
        return Math.exp(-mu * t);
    }

    public static double beta(double lambda, double mu, double t) {
        double elmt = AffineGapAlignmentSampler.elmt(lambda, mu, t);
        double num = lambda * (1.0 - elmt);
        double denom = mu - lambda * elmt;
        return num / denom;
    }

    public static double gamma(double lambda, double mu, double t) {
        double elmt = AffineGapAlignmentSampler.elmt(lambda, mu, t);
        double num = mu * (1.0 - elmt);
        double denom = (1.0 - Math.exp(-mu * t)) * (mu - lambda * elmt);
        return 1.0 - num / denom;
    }

    private static double elmt(double lambda, double mu, double t) {
        return Math.exp((lambda - mu) * t);
    }

    public static void main(String[] args) throws MeasureZeroException {
        useSloppyMath = false;
        AffineGapAlignmentSampler.testTKF91Marginals();
        AffineGapAlignmentSampler.windowHLTest();
        AffineGapAlignmentSampler.testHLNormalization();
        for (int i = 0; i < 2; ++i) {
            AffineGapAlignmentSampler.testTKFNormalization();
            AffineGapAlignmentSampler.testTKF91Normalization2(0.5, 0.7, 1.0);
            AffineGapAlignmentSampler.toyAffineGapTest(true);
            AffineGapAlignmentSampler.longGapTester(true);
            AffineGapAlignmentSampler.toyAffineGapTest(false);
            AffineGapAlignmentSampler.longGapTester(false);
            AffineGapAlignmentSampler.testMax();
            AffineGapAlignmentSampler.testTKF91Generation();
            useSloppyMath = true;
        }
        System.out.println("Tests completed successfully");
    }

    private static void windowHLTest() {
        Random rand = new Random(1L);
        Encodings enc = Encodings.toyCtxFreeEncodings(2);
        HLParams.HLBranchParams p = HLParams.randomHLBranchParams(rand, enc, false);
        String bot = "ab";
        String top = "ba";
        int insCode = -1;
        int[] ancestors = new int[]{0, -1};
        DerivationTree.Derivation d = new DerivationTree.Derivation(ancestors, "ba", "ab");
        DerivationTree.Window botWin = new DerivationTree.Window(0, 1);
        DerivationTree.Window topWin = new DerivationTree.Window(0, 1);
        AffineGapAlignmentSampler agas = AffineGapAlignmentSampler.createHLAlignmentSampler("ba", topWin, "ab", botWin, d, p, null, null, null);
        System.out.println(agas.getSumPr());
    }

    private static void testHLNormalization() {
        Encodings enc = Encodings.toyCtxFreeEncodings(2);
        HLParams.HLBranchParams params = new HLParams.HLParamsBranchPopulator(enc){

            @Override
            public void populateIns(int top, int prev, float[] result) {
                for (int i = 0; i < result.length - 2; ++i) {
                    if (i == this.B()) continue;
                    result[i] = 1.0f;
                }
                result[result.length - 1] = 3.0f;
            }

            @Override
            public void populateSub(int top, int prev, float[] result) {
                for (int i = 0; i < result.length - 1; ++i) {
                    if (i == this.B()) continue;
                    result[i] = 1.0f;
                }
            }
        }.createParams(true);
        double sum = AffineGapAlignmentSampler.sumNorm("a", params, 20, "");
        System.out.println("Sum: " + sum);
    }

    public static void testTKF91Normalization2(double lambda, double mu, double t) {
        double gamma;
        double beta;
        Encodings enc = Encodings.toyCtxFreeEncodings(2);
        double[][] trans = new double[][]{{0.2, 0.8}, {0.1, 0.9}};
        double[] stat = new double[]{0.7, 0.3};
        String topStr = "ababb";
        double alpha = AffineGapAlignmentSampler.alpha(mu, t);
        CompiledTKFParams params = new CompiledTKFParams(enc, alpha, beta = AffineGapAlignmentSampler.beta(lambda, mu, t), gamma = AffineGapAlignmentSampler.gamma(lambda, mu, t), stat, trans, mu, lambda);
        double sum = AffineGapAlignmentSampler.sumNorm(topStr, params, 12, "");
        if (!MathUtils.close(1.0, sum, 0.01)) {
            throw new RuntimeException("bad: " + sum);
        }
    }

    private static double sumNorm(String topStr, GapAlignmentParams params, int max, String cBottom) {
        double sum = 0.0;
        AffineGapAlignmentSampler sampler = AffineGapAlignmentSampler.createAffineGapAlignmentSampler(topStr, cBottom, params);
        sum += sampler.getSumPr();
        if (cBottom.length() + 1 < max) {
            sum += AffineGapAlignmentSampler.sumNorm(topStr, params, max, cBottom + "a");
            sum += AffineGapAlignmentSampler.sumNorm(topStr, params, max, cBottom + "b");
        }
        return sum;
    }

    public static void toyAffineGapTest(boolean useLogs) {
        Encodings enc = Encodings.toyCtxFreeEncodings(2);
        double[][] scores = new double[][]{{1.0, 1.0}, {1.0, 1.0}};
        double[] inserts = new double[]{1.0, 1.0};
        String top = "aa";
        String bottom = "aa";
        double deathPr = 0.5;
        double condIns = 0.3333333333333333;
        double geoParam = 0.25;
        DiscreteAffineGapParameters params = new DiscreteAffineGapParameters(deathPr, condIns, geoParam, enc, scores, inserts);
        AffineGapAlignmentSampler sampler = AffineGapAlignmentSampler.createAffineGapAlignmentSampler(top, bottom, params);
        if (useLogs) {
            sampler.activateLogMode();
        }
        if (!MathUtils.close(sampler.getSumPr(), 0.14525462962962962, useSloppyMath ? 0.001 : MathUtils.threshold)) {
            throw new RuntimeException("should be 1/18+2/27+1/16/4 = 0.1453, is: " + sampler.getSumPr());
        }
    }

    public static void longGapTester(boolean useLogs) {
        Random rand = new Random(1L);
        Encodings enc = Encodings.toyCtxFreeEncodings(2);
        double[][] scores = new double[][]{{4.0, 3.0}, {3.0, 5.0}};
        int aCode = enc.char2PhoneId('a');
        int bCode = enc.char2PhoneId('b');
        String top = "abab";
        String bottom = "ababb";
        double topGap = 3.0;
        double bottomGap = 2.0;
        LongGapAlignmentSampler.LongGapAlignmentSamplerParams params = new LongGapAlignmentSampler.LongGapAlignmentSamplerParams(scores, topGap, bottomGap, enc);
        LongGapAlignmentSampler lgas = new LongGapAlignmentSampler(top, bottom, params);
        AffineGapAlignmentSampler newSampler = AffineGapAlignmentSampler.createAffineGapAlignmentSampler(top, bottom, params);
        if (useLogs) {
            newSampler.activateLogMode();
        }
        if (!MathUtils.close(lgas.getSumPr(), newSampler.getSumPr(), useSloppyMath ? 20000.0 : MathUtils.threshold)) {
            throw new RuntimeException("should be: " + lgas.getSumPr() + " is " + newSampler.getSumPr());
        }
    }

    private static void testTKF91Marginals() {
        Random rand = new Random(1L);
        TKFParams defaultTKF = new TKFParams(Encodings.EncodingType.PROTEIN);
        double t1 = 1.0;
        double t2 = 2.0;
        CompiledTKFParams p12 = defaultTKF.compile(1.0);
        CompiledTKFParams p23 = defaultTKF.compile(2.0);
        CompiledTKFParams p13 = defaultTKF.compile(3.0);
        double l1 = 0.0;
        double l2 = 0.0;
        double n = 0.0;
        String top = "AAAA";
        for (int i = 0; i < 10000000; ++i) {
            String desc12 = p12.generateStr(rand, "AAAA");
            String desc23 = p23.generateStr(rand, desc12);
            String desc13 = p13.generateStr(rand, "AAAA");
            n += 1.0;
            l1 += (double)desc23.length();
            l2 += (double)desc13.length();
        }
        System.out.println("l1/n=" + l1 / n);
        System.out.println("l2/n=" + l2 / n);
    }

    private static void testTKFNormalization() {
        TKFParams defaultTKF = new TKFParams(Encodings.EncodingType.PROTEIN);
        CompiledTKFParams params = AffineGapAlignmentSampler.getTestParams(defaultTKF.lambda, defaultTKF.mu, 1.0);
        DiscreteAffineGapParameters params2 = DiscreteAffineGapParameters.createFromTKF(params);
        String topStr = "aaa";
        double sum = 0.0;
        double sum2 = 0.0;
        String currentBottom = "";
        for (int i = 0; i < 200; ++i) {
            AffineGapAlignmentSampler sampler = AffineGapAlignmentSampler.createAffineGapAlignmentSampler("aaa", currentBottom, params);
            AffineGapAlignmentSampler sampler2 = AffineGapAlignmentSampler.createAffineGapAlignmentSampler("aaa", currentBottom, params2);
            System.out.println((sum += sampler.getSumPr()) + "," + (sum2 += sampler2.getSumPr()) + "," + currentBottom);
            currentBottom = currentBottom + "a";
        }
        if (!MathUtils.close(1.0, sum, 0.01)) {
            throw new RuntimeException("" + sum + " should be 1.0");
        }
    }

    private static CompiledTKFParams getTestParams(double lambda, double mu, double t) {
        Encodings enc = Encodings.toyCtxFreeEncodings(1);
        double[][] trans = new double[][]{{1.0}};
        double[] stat = new double[]{1.0};
        double alpha = AffineGapAlignmentSampler.alpha(mu, t);
        double beta = AffineGapAlignmentSampler.beta(lambda, mu, t);
        double gamma = AffineGapAlignmentSampler.gamma(lambda, mu, t);
        return new CompiledTKFParams(enc, alpha, beta, gamma, stat, trans, mu, lambda);
    }

    private static void testTKF91Generation() {
        Random rand = new Random();
        double lambda = 0.5;
        double mu = 0.7;
        double t = 50.0;
        double alpha = AffineGapAlignmentSampler.alpha(mu, t);
        double beta = AffineGapAlignmentSampler.beta(lambda, mu, t);
        double gamma = AffineGapAlignmentSampler.gamma(lambda, mu, t);
        CompiledTKFParams cparam1 = AffineGapAlignmentSampler.getTestParams(lambda, mu, t);
        double sum = 0.0;
        double sqrs = 0.0;
        double iters = 100000.0;
        int i = 0;
        while ((double)i < 100000.0) {
            String current = cparam1.generateStr(rand, "#aa");
            sum += (double)current.length();
            sqrs += (double)(current.length() * current.length());
            ++i;
        }
        double mean = sum / 100000.0;
        double var = sqrs / 100000.0 - mean * mean;
        double p = 1.0 - lambda / mu;
        if (!MathUtils.close(mean, 1.0 / p, 0.2)) {
            throw new RuntimeException();
        }
        if (!MathUtils.close(var, (1.0 - p) / p / p, 0.2)) {
            throw new RuntimeException("" + var);
        }
        t = 3.0;
        alpha = AffineGapAlignmentSampler.alpha(mu, t);
        beta = AffineGapAlignmentSampler.beta(lambda, mu, t);
        gamma = AffineGapAlignmentSampler.gamma(lambda, mu, t);
        cparam1 = AffineGapAlignmentSampler.getTestParams(lambda, mu, t);
        t = 6.0;
        alpha = AffineGapAlignmentSampler.alpha(mu, t);
        beta = AffineGapAlignmentSampler.beta(lambda, mu, t);
        gamma = AffineGapAlignmentSampler.gamma(lambda, mu, t);
        CompiledTKFParams cparam2 = AffineGapAlignmentSampler.getTestParams(lambda, mu, t);
        sum = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        String initStr = "#aaaa";
        int i2 = 0;
        while ((double)i2 < 100000.0) {
            String s1 = cparam1.generateStr(rand, "#aaaa");
            sum3 += (double)s1.length();
            s1 = cparam1.generateStr(rand, s1);
            sum += (double)s1.length();
            sum2 += (double)cparam2.generateStr(rand, "#aaaa").length();
            ++i2;
        }
        if (!MathUtils.close(sum / 100000.0, sum2 / 100000.0, 0.05)) {
            throw new RuntimeException();
        }
    }

    private static void testMax() throws MeasureZeroException {
        Encodings enc = Encodings.toyCtxFreeEncodings(2);
        double[][] scores = new double[][]{{4.0, 3.0}, {3.0, 5.0}};
        String top = "abab";
        String bottom = "ababb";
        double topGap = 3.0;
        double bottomGap = 2.0;
        LongGapAlignmentSampler.LongGapAlignmentSamplerParams params = new LongGapAlignmentSampler.LongGapAlignmentSamplerParams(scores, topGap, bottomGap, enc);
        LongGapAlignmentSampler lgas = new LongGapAlignmentSampler(top, bottom, params);
        DerivationTree.Derivation d = lgas.sample(new Random());
        double dpScore = Math.exp(lgas.getLogMaxScore());
        double realScore = Math.exp(LongGapAlignmentSampler.logScore(lgas.mode(), scores, topGap, bottomGap, enc));
        AffineGapAlignmentSampler newSampler = AffineGapAlignmentSampler.createAffineGapAlignmentSampler(top, bottom, params);
        newSampler.activateLogMode();
        newSampler.setExponent(100.0);
        DerivationTree.Derivation newD = newSampler.sample(new Random());
        double ours = Math.exp(LongGapAlignmentSampler.logScore(newD, scores, topGap, bottomGap, enc));
        if (!MathUtils.close(realScore, ours)) {
            throw new RuntimeException();
        }
    }

    public static interface AffineGapAlignmentSamplerParamsAdaptor
    extends Serializable {
        public double pr(boolean var1, int var2, int var3, int var4);

        public double condFirstInsertPr(int var1, int var2);

        public double condSecondInsertPr(int var1, int var2);
    }

    public static class ContextSensitiveAlignmentParam
    implements AffineGapAlignmentSamplerParamsAdaptor {
        private final double[][] subCosts;

        public ContextSensitiveAlignmentParam(double[][] sub) {
            this.subCosts = sub;
        }

        @Override
        public double condFirstInsertPr(int m, int n) {
            return 1.0;
        }

        @Override
        public double condSecondInsertPr(int m, int n) {
            return 1.0;
        }

        @Override
        public double pr(boolean dies, int extraChildren, int m, int n) {
            if (!dies && (m == 0 && n > 0 || n == 0 && m > 0)) {
                return 0.0;
            }
            if (dies || m == 0 || n == 0) {
                return 1.0;
            }
            return this.subCosts[m - 1][n - 1];
        }
    }

    public static class AlignmentSufficientStatistics {
        private double n = 0.0;
        private double numberOfDeaths = 0.0;
        private double numberOfInserts = 0.0;
        private double lengthOfInserts = 0.0;

        public void scale(double s) {
            this.n *= s;
            this.numberOfDeaths *= s;
            this.numberOfInserts *= s;
            this.lengthOfInserts *= s;
        }

        public void add(AlignmentSufficientStatistics ass) {
            this.n += ass.n;
            this.numberOfDeaths += ass.numberOfDeaths;
            this.numberOfInserts += ass.numberOfInserts;
            this.lengthOfInserts += ass.lengthOfInserts;
        }

        public void add(Arbre<DerivationTree.DerivationNode> sample) {
            if (!sample.isRoot()) {
                this.add(sample.getContents().getDerivation());
            }
            for (Arbre<DerivationTree.DerivationNode> child : sample.getChildren()) {
                this.add(child);
            }
        }

        public void add(DerivationTree.Derivation d) {
            d = d.invert();
            int l = d.getCurrentWord().length();
            this.n += (double)l;
            int lastPos = 0;
            for (int i = 0; i < l; ++i) {
                if (!d.hasAncestor(i)) {
                    this.numberOfDeaths += 1.0;
                    continue;
                }
                this.updateInserted(d.ancestor(i) - lastPos);
                lastPos = d.ancestor(i);
            }
            this.updateInserted(l - 1 - lastPos);
        }

        private void updateInserted(int nOffspring) {
            int nInserted = nOffspring - 1;
            if (nInserted > 0) {
                this.numberOfInserts += 1.0;
                this.lengthOfInserts += (double)nInserted;
            }
        }
    }

    public static final class DiscreteAffineGapParameters
    implements GapAlignmentParams {
        private final double deathPr;
        private final double insertionGivenSurvCondPr;
        private final double insertionLengthGeoParam;
        private final Encodings enc;
        private final double[][] matrix;
        private final double[] stat;

        public DiscreteAffineGapParameters(double deathPr, double insertionGivenSurvCondPr, double insertionLengthGeoParam, Encodings enc, double[][] matrix, double[] stat) {
            this.deathPr = deathPr;
            this.insertionGivenSurvCondPr = insertionGivenSurvCondPr;
            this.insertionLengthGeoParam = insertionLengthGeoParam;
            this.enc = enc;
            this.matrix = matrix;
            this.stat = stat;
        }

        public String toString() {
            return "deathPr=" + this.deathPr + ",insertGivenSurv=" + this.insertionGivenSurvCondPr + ",insertLengthGeo=" + this.insertionLengthGeoParam;
        }

        public static DiscreteAffineGapParameters createFromTKF(CompiledTKFParams params) {
            return new DiscreteAffineGapParameters((1.0 - params.alpha) * (1.0 - params.gamma), params.beta, 1.0 - params.beta, params.enc, params.transitions, params.stationaryDist);
        }

        public DiscreteAffineGapParameters reestimate(AlignmentSufficientStatistics ass) {
            double deathPr = ass.numberOfDeaths / ass.n;
            double insertPr = ass.numberOfInserts / ass.n;
            double meanLength = ass.lengthOfInserts / ass.numberOfInserts;
            double insertGeoParam = 1.0 / meanLength;
            return new DiscreteAffineGapParameters(deathPr, insertPr, insertGeoParam, this.enc, this.matrix, this.stat);
        }

        @Override
        public Encodings getEncodings() {
            return this.enc;
        }
    }

    public static class TKFGenerator {
        private final Map<Taxon, Double> branchLengths;
        private final Tree<String> tree;
        private final TKFParams params;
        private final Random rand;
        private int topWordLength;

        public TKFGenerator(TKFParams params, Random rand, Tree<String> tree, Map<Taxon, Double> bl) {
            this.branchLengths = bl;
            this.params = params;
            this.rand = rand;
            this.tree = tree;
        }

        public Arbre<DerivationTree.DerivationNode> generate(int topL) {
            this.topWordLength = topL;
            return this.generate(null, this.tree);
        }

        private Arbre<DerivationTree.DerivationNode> generate(String parentStr, Tree<String> subtree) {
            Taxon newNodeName = new Taxon(subtree.getLabel());
            DerivationTree.DerivationNode node = null;
            String word = "";
            if (parentStr != null) {
                CompiledTKFParams ctkf = this.params.compile(this.branchLengths.get(newNodeName));
                DerivationTree.Derivation randomDerivation = ctkf.generate(this.rand, parentStr);
                word = randomDerivation.getCurrentWord();
                node = new DerivationTree.DerivationNode(newNodeName, word, randomDerivation);
            } else {
                for (int i = 0; i < this.topWordLength; ++i) {
                    word = word + this.params.compile(1.0).generateFromStatDist(this.rand);
                }
                node = new DerivationTree.DerivationNode(newNodeName, word);
            }
            ArrayList children = new ArrayList();
            for (int i = 0; i < subtree.getChildren().size(); ++i) {
                children.add(this.generate(word, subtree.getChildren().get(i)));
            }
            return Arbre.arbre(node, children);
        }
    }

    public static final class CompiledTKFParams
    implements GapAlignmentParams {
        private final Encodings enc;
        public final double alpha;
        public final double beta;
        public final double gamma;
        public final double mu;
        public final double lambda;
        private final double[] stationaryDist;
        private final double[][] transitions;

        public double transition(int x, int y) {
            return this.transitions[x][y];
        }

        public double stationary(int x) {
            return this.stationaryDist[x];
        }

        public CompiledTKFParams(Encodings enc, double alpha, double beta, double gamma, double[] stationaryDist, double[][] transitions, double mu, double lambda) {
            this.mu = mu;
            this.lambda = lambda;
            this.enc = enc;
            this.alpha = alpha;
            this.beta = beta;
            this.gamma = gamma;
            this.stationaryDist = stationaryDist;
            this.transitions = transitions;
        }

        public final DerivationTree.Derivation generate(Random rand, String topWord) {
            Generator gen = new Generator();
            gen.rand = rand;
            return gen.generate(topWord);
        }

        public final String generateStr(Random rand, String topWord) {
            return this.generate(rand, topWord).getCurrentWord();
        }

        public char generateFromStatDist(Random rand) {
            int inserted = SampleUtils.sampleMultinomial(rand, this.stationaryDist);
            return this.enc.phoneId2Char(inserted);
        }

        @Override
        public Encodings getEncodings() {
            return this.enc;
        }

        private class Generator {
            private Boolean currentLinkDied = null;
            private Random rand;

            private Generator() {
            }

            private DerivationTree.Derivation generate(String topWord) {
                ArrayList<Integer> ancestors = new ArrayList<Integer>();
                StringBuilder bottomWord = new StringBuilder("");
                for (int currentTopPos = 0; currentTopPos < topWord.length(); ++currentTopPos) {
                    char c = topWord.charAt(currentTopPos);
                    StringBuilder newGeneratedStr = this.generate(c);
                    bottomWord.append((CharSequence)newGeneratedStr);
                    for (int i = 0; i < newGeneratedStr.length(); ++i) {
                        if (i == 0 && !this.currentLinkDied.booleanValue()) {
                            ancestors.add(currentTopPos);
                            continue;
                        }
                        ancestors.add(-1);
                    }
                }
                int[] ancestorsAr = new int[ancestors.size()];
                for (int i = 0; i < ancestors.size(); ++i) {
                    ancestorsAr[i] = (Integer)ancestors.get(i);
                }
                return new DerivationTree.Derivation(ancestorsAr, topWord, bottomWord.toString());
            }

            private final StringBuilder generate(char symbol) {
                StringBuilder result = new StringBuilder("");
                this.currentLinkDied = false;
                if (symbol == '#') {
                    result.append('#');
                } else {
                    double draw = this.rand.nextDouble();
                    if (draw < CompiledTKFParams.this.alpha) {
                        double[] current = CompiledTKFParams.this.transitions[CompiledTKFParams.this.enc.char2PhoneId(symbol)];
                        int mutated = SampleUtils.sampleMultinomial(this.rand, current);
                        result.append(CompiledTKFParams.this.enc.phoneId2Char(mutated));
                    } else {
                        this.currentLinkDied = true;
                        draw = this.rand.nextDouble();
                        if (draw < 1.0 - CompiledTKFParams.this.gamma) {
                            return result;
                        }
                        result.append(CompiledTKFParams.this.generateFromStatDist(this.rand));
                    }
                }
                int nInsert = Sampling.sampleGeometric(this.rand, 1.0 - CompiledTKFParams.this.beta);
                for (int i = 0; i < nInsert; ++i) {
                    result.append(CompiledTKFParams.this.generateFromStatDist(this.rand));
                }
                return result;
            }
        }
    }

    public static final class TKFParams {
        private final double mu;
        private final double lambda;
        private final double[][] rate;
        private final Encodings enc;

        public TKFParams(double mu, double lambda, double[][] rate, Encodings enc) {
            this.mu = mu;
            this.lambda = lambda;
            this.enc = enc;
            this.rate = rate;
        }

        public TKFParams(Encodings.EncodingType encType) {
            this.mu = 0.00196078431372549;
            this.lambda = 0.1 - this.mu;
            if (encType == Encodings.EncodingType.DNA) {
                this.rate = RateMatrixLoader.hky85();
                this.enc = Encodings.dnaEncodings();
            } else if (encType == Encodings.EncodingType.RNA) {
                this.rate = RateMatrixLoader.hky85();
                this.enc = Encodings.rnaEncodings();
            } else if (encType == Encodings.EncodingType.PROTEIN) {
                this.rate = RateMatrixLoader.dayhoff();
                this.enc = Encodings.proteinEncodings(true);
            } else {
                throw new RuntimeException();
            }
        }

        public CompiledTKFParams compile(double t) {
            double[][] trans = RateMtxUtils.marginalTransitionMtx(this.rate, t);
            double[] stat = RateMtxUtils.getStationaryDistribution(this.rate);
            NumUtils.normalize(stat);
            double alpha = AffineGapAlignmentSampler.alpha(this.mu, t);
            double beta = AffineGapAlignmentSampler.beta(this.lambda, this.mu, t);
            double gamma = AffineGapAlignmentSampler.gamma(this.lambda, this.mu, t);
            return new CompiledTKFParams(this.enc, alpha, beta, gamma, stat, trans, this.mu, this.lambda);
        }
    }

    public static final class TKF91Adaptor
    implements AffineGapAlignmentSamplerParamsAdaptor {
        private static final long serialVersionUID = 1L;
        private final CompiledTKFParams p;
        private final double[][] subCosts;
        private final double[] statCosts;

        private TKF91Adaptor(CompiledTKFParams p, String topWord, String bottomWord) {
            this.subCosts = AffineGapAlignmentSampler.compileSubstitutionCosts(p.enc, p.transitions, topWord, bottomWord);
            this.statCosts = AffineGapAlignmentSampler.compileInsertionsCosts(p.enc, p.stationaryDist, bottomWord);
            this.p = p;
        }

        @Override
        public double condFirstInsertPr(int m, int n) {
            return this.p.beta * this.statCosts[n];
        }

        @Override
        public double condSecondInsertPr(int m, int n) {
            return this.p.beta * this.statCosts[n];
        }

        @Override
        public double pr(boolean dies, int extraChildren, int m, int n) {
            if (dies && extraChildren == 0) {
                return (1.0 - this.p.alpha) * (1.0 - this.p.gamma);
            }
            if (dies && extraChildren == 1) {
                return (1.0 - this.p.alpha) * this.p.gamma * (1.0 - this.p.beta) * this.statCosts[n];
            }
            if (!dies && extraChildren == 0) {
                if (m == 0 && n >= 1) {
                    return 0.0;
                }
                if (m >= 1 && n == 0) {
                    return 0.0;
                }
                if (m == 0 && n == 0) {
                    return 1.0 - this.p.beta;
                }
                return this.p.alpha * (1.0 - this.p.beta) * this.subCosts[m][n];
            }
            throw new RuntimeException("Internal error in TKF91Adaptor");
        }
    }

    private static final class DiscreteAffineGapParamsAdaptor
    implements AffineGapAlignmentSamplerParamsAdaptor {
        private static final long serialVersionUID = 1L;
        private final DiscreteAffineGapParameters params;
        private final double[][] subcosts;
        private final double[] insertcosts;

        private DiscreteAffineGapParamsAdaptor(DiscreteAffineGapParameters params, String topWord, String bottomWord) {
            this.subcosts = AffineGapAlignmentSampler.compileSubstitutionCosts(params.enc, params.matrix, topWord, bottomWord);
            this.insertcosts = AffineGapAlignmentSampler.compileInsertionsCosts(params.enc, params.stat, bottomWord);
            this.params = params;
        }

        @Override
        public final double condSecondInsertPr(int m, int n) {
            return (1.0 - this.params.insertionLengthGeoParam) * this.insertcosts[n];
        }

        @Override
        public final double condFirstInsertPr(int m, int n) {
            return this.insertcosts[n] * this.params.insertionGivenSurvCondPr / (1.0 - this.params.insertionGivenSurvCondPr) * this.params.insertionLengthGeoParam;
        }

        @Override
        public final double pr(boolean dies, int extraChildren, int m, int n) {
            if (dies && extraChildren > 0) {
                return 0.0;
            }
            if (dies && extraChildren == 0) {
                return this.params.deathPr;
            }
            if (!dies && extraChildren == 0) {
                if (m == 0 && n >= 1) {
                    return 0.0;
                }
                if (m >= 1 && n == 0) {
                    return 0.0;
                }
                if (m == 0 && n == 0) {
                    return 1.0 - this.params.insertionGivenSurvCondPr;
                }
                return (1.0 - this.params.deathPr) * (1.0 - this.params.insertionGivenSurvCondPr) * this.subcosts[m][n];
            }
            throw new RuntimeException("Internal error in DiscreteAffineGapParamsAdaptor");
        }
    }

    private static final class HLParamsAdaptor
    implements AffineGapAlignmentSamplerParamsAdaptor {
        private static final long serialVersionUID = 1L;
        private final HLParams.HLBranchParams params;
        private final int[] topWord;
        private final int[] bottomWord;
        private final double[] insertBotSuffix;
        private final int lastBotId;

        public HLParamsAdaptor(String top, String bottom, String insertedBotSuffix, HLParams.HLBranchParams params) {
            int i;
            this.params = params;
            this.topWord = new int[top.length()];
            this.bottomWord = new int[bottom.length()];
            for (i = 0; i < top.length(); ++i) {
                this.topWord[i] = params.getEncodings().char2PhoneId(top.charAt(i));
            }
            for (i = 0; i < bottom.length(); ++i) {
                this.bottomWord[i] = params.getEncodings().char2PhoneId(bottom.charAt(i));
            }
            this.insertBotSuffix = this.computeInsertBotSuffix(insertedBotSuffix, bottom.charAt(bottom.length() - 1));
            this.lastBotId = insertedBotSuffix.length() == 0 ? params.getEncodings().idAt(bottom, bottom.length() - 1) : params.getEncodings().idAt(insertedBotSuffix, insertedBotSuffix.length() - 1);
        }

        private double[] computeInsertBotSuffix(String insertedBotSuffix, char lastBot) {
            Encodings enc = this.params.getEncodings();
            String concat = "" + lastBot + insertedBotSuffix;
            double[] result = new double[enc.getNumberOfPhonemes()];
            for (int tc = 0; tc < result.length; ++tc) {
                if (insertedBotSuffix.length() == 0) {
                    result[tc] = 1.0;
                    continue;
                }
                double cur = 1.0 / this.params.stopIns(tc, enc.char2PhoneId(lastBot));
                for (int i = 1; i < concat.length(); ++i) {
                    cur *= this.params.ins(tc, enc.idAt(concat, i - 1), enc.idAt(concat, i));
                }
                result[tc] = cur *= this.params.stopIns(tc, enc.idAt(concat, concat.length() - 1));
            }
            return result;
        }

        @Override
        public double condFirstInsertPr(int m, int n) {
            if (n == 0) {
                return 0.0;
            }
            if (m > 0 && n == 1) {
                return 0.0;
            }
            int t = this.topWord[m];
            int p = this.bottomWord[n - 1];
            int c = this.bottomWord[n];
            double result = this.params.ins(t, p, c) * this.params.stopIns(t, c) / this.params.stopIns(t, p);
            if (n == this.bottomWord.length - 1) {
                result *= this.insertBotSuffix[t];
            }
            return result;
        }

        @Override
        public double condSecondInsertPr(int m, int n) {
            return this.condFirstInsertPr(m, n);
        }

        @Override
        public final double pr(boolean dies, int extraChildren, int m, int n) {
            int t = this.topWord[m];
            int c = this.bottomWord[n];
            if (dies && extraChildren > 0) {
                return 0.0;
            }
            if (dies && m == 0) {
                return 0.0;
            }
            if (dies && extraChildren == 0) {
                if (n == this.bottomWord.length - 1) {
                    return this.params.death(t, this.lastBotId);
                }
                return this.params.death(t, this.bottomWord[n]);
            }
            if (!dies && extraChildren == 0) {
                double boundCorrection;
                double d = boundCorrection = n == this.bottomWord.length - 1 ? this.insertBotSuffix[t] : 1.0;
                if (m == 0 && n >= 1) {
                    return 0.0;
                }
                if (m >= 1 && n == 0) {
                    return 0.0;
                }
                if (m == 0 && n == 0) {
                    return this.params.stopIns(t, c) * boundCorrection;
                }
                return this.params.stopIns(t, c) * this.params.sub(t, this.bottomWord[n - 1], c) * boundCorrection;
            }
            throw new RuntimeException("Internal error in HLParamsAdaptor");
        }
    }

    private static final class LongGapParamAdaptor
    implements AffineGapAlignmentSamplerParamsAdaptor {
        private static final long serialVersionUID = 1L;
        private final double bottomGap;
        private final double topGap;
        private final double[][] subcosts;

        private LongGapParamAdaptor(LongGapAlignmentSampler.LongGapAlignmentSamplerParams params, String topWord, String bottomWord) {
            this.subcosts = AffineGapAlignmentSampler.compileSubstitutionCosts(params.enc, params.substitutionMatrix, topWord, bottomWord);
            this.topGap = params.topGap;
            this.bottomGap = params.bottomGap;
        }

        @Override
        public final double condFirstInsertPr(int m, int n) {
            return this.bottomGap;
        }

        @Override
        public final double condSecondInsertPr(int m, int n) {
            return this.bottomGap;
        }

        @Override
        public final double pr(boolean dies, int extraChildren, int m, int n) {
            if (dies && extraChildren == 1) {
                return 0.0;
            }
            if (dies && extraChildren == 0) {
                return this.topGap;
            }
            if (!dies && extraChildren == 0) {
                if (m >= 1 && n >= 1) {
                    return this.subcosts[m][n];
                }
                if (m == 0 && n == 0) {
                    return 1.0;
                }
                return 0.0;
            }
            throw new RuntimeException("Internal error in LongGapParamsAdaptor");
        }
    }

    public static interface GapAlignmentParams {
        public Encodings getEncodings();
    }
}

