/*
 * Decompiled with CFR 0.152.
 */
package nuts.remote;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.StrUtils;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import nuts.io.IO;
import nuts.math.Plot2D;
import nuts.math.PlotHistogram;
import nuts.math.StatisticsMap;
import nuts.tui.Table;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.LexicographicComparator;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class AnalyzeCSVs
implements Runnable {
    @Option
    public ArrayList<String> execFilter = new ArrayList<String>(Arrays.asList("gp474.*"));
    @Option
    public ArrayList<String> indepVariables = new ArrayList<String>(Arrays.asList("gen.nTaxa", "Metric", "Method", "IterScale"));
    @Option
    public String depVariable = "Value";
    @Option
    public boolean useLegend = true;
    @Option
    public boolean createPlot = true;
    @Option
    public boolean createHist = false;
    @Option
    public boolean correctItersHack = false;
    @Option
    public ArrayList<String> csvsToUse = new ArrayList();
    @Option
    public ArrayList<String> filteredFields = new ArrayList();
    @Option
    public ArrayList<String> filteredRegex = new ArrayList();
    @Option
    public ArrayList<String> filteredReplace = new ArrayList();
    @Option(gloss="An intersection of fields to select (empty selects everything)")
    public ArrayList<String> selectFields = new ArrayList();
    @Option
    public ArrayList<String> selectRegex = new ArrayList();
    private Counter<Integer> matches = new Counter();
    private Set<String> allNonCollapsedVariables = CollUtils.set();
    private Set<String> filteredFieldsSet = CollUtils.set();
    private Plot2D.Plot2DFactories plotFactories = null;
    private List<Pattern> selectCompiledRegex = null;
    private Map<String, PlotHistogram> histograms = new HashMap<String, PlotHistogram>();
    public static final NotFound notFound = new NotFound();
    Set<String> indepVarSet = null;

    public static void main(String[] args) {
        IO.run(args, new AnalyzeCSVs(), "plot", Plot2D.defaultPlot2DOptions, "r", Plot2D.class);
    }

    @Override
    public void run() {
        if (this.filteredFields.size() != this.filteredRegex.size() || this.filteredFields.size() != this.filteredReplace.size()) {
            throw new RuntimeException();
        }
        this.prepareRegex();
        this.filteredFieldsSet.addAll(this.filteredFields);
        this.allNonCollapsedVariables.addAll(this.indepVariables);
        this.allNonCollapsedVariables.add(this.depVariable);
        StatisticsMap.DescriptiveStatisticsMap<List<String>> stats = new StatisticsMap.DescriptiveStatisticsMap<List<String>>();
        this.plotFactories = new Plot2D.Plot2DFactories();
        HashMap<String, Set<String>> collapsedValues = CollUtils.map();
        ArrayList<File> directories = CollUtils.list();
        ArrayList<File> filteredDirectories = CollUtils.list();
        directories.addAll(IO.ls(new File("state", "remote")));
        directories.addAll(IO.ls(new File("state", "execs")));
        block2: for (File f : directories) {
            if (!f.isDirectory()) continue;
            for (String string : this.execFilter) {
                if (!f.getName().matches(string)) continue;
                filteredDirectories.add(f);
                LogInfo.logs("Using: " + f.getAbsolutePath());
                continue block2;
            }
        }
        File errorFile = new File(Execution.getFile("parse-errors"));
        PrintWriter excOut = IOUtils.openOutHard(errorFile);
        int nErrors = 0;
        LogInfo.track("Reading data");
        for (File serverDir : filteredDirectories) {
            Map<String, String> options;
            LogInfo.logs("Reading " + serverDir);
            File execDir = serverDir;
            File optionsFile = new File(execDir, "options.map");
            if (!optionsFile.exists() || !this.selected(options = this.parseOptions(optionsFile))) continue;
            this.applyRegex(options);
            List<Object> toProcess = CollUtils.list();
            if (this.csvsToUse.size() == 0) {
                toProcess = IO.locate(execDir, "csv");
            } else {
                for (String string : this.csvsToUse) {
                    toProcess.add(new File(serverDir, string));
                }
            }
            for (File file : toProcess) {
                try {
                    for (Map<String, String> datum : IO.iCSVMap(file)) {
                        if (this.correctItersHack) {
                            IO.warnOnce("Using correct iters hack");
                            double cIterScale = Double.parseDouble(datum.get("IterScale"));
                            double nTaxa = Double.parseDouble(options.get("gen.nTaxa"));
                            if (!options.containsKey("InferenceExperiments.usePriorPost") || options.get("InferenceExperiments.usePriorPost").equals("false") || options.get("InferenceExperiments.usePriorPost").equals("PriorPrior")) {
                                datum.put("IterScale", "" + cIterScale * nTaxa);
                            } else {
                                double sum = 0.0;
                                int t = 1;
                                while ((double)t <= nTaxa) {
                                    sum += (double)(t * (t - 1)) / 2.0;
                                    ++t;
                                }
                                datum.put("IterScale", "" + cIterScale * sum);
                            }
                        }
                        if (!this.selected(datum)) continue;
                        this.applyRegex(datum);
                        this.addToCollapsedValues(collapsedValues, datum);
                        this.addToCollapsedValues(collapsedValues, options);
                        this.addToStats(stats, datum, options, this.plotFactories);
                        this.addToHistStats(datum, options);
                    }
                }
                catch (Exception e) {
                    ++nErrors;
                    excOut.println("Error in file:" + file.getAbsolutePath());
                    excOut.println("Exception: " + e);
                    excOut.println("");
                    e.printStackTrace(excOut);
                }
            }
        }
        LogInfo.end_track();
        excOut.close();
        LogInfo.logsForce("Number of errors: " + nErrors + "\nSee " + errorFile.getAbsolutePath());
        ArrayList<Object> arrayList = CollUtils.list(stats.keySet());
        Collections.sort(arrayList, new LexicographicComparator());
        Table t = new Table();
        for (int c = 0; c < this.indepVariables.size(); ++c) {
            t.set(0, c, this.indepVariables.get(c));
        }
        t.set(0, this.indepVariables.size(), this.depVariable + " (mean)");
        t.set(0, this.indepVariables.size() + 1, this.depVariable + " (sd)");
        t.set(0, this.indepVariables.size() + 2, this.depVariable + " (med)");
        t.set(0, this.indepVariables.size() + 3, this.depVariable + " (q1)");
        t.set(0, this.indepVariables.size() + 4, this.depVariable + " (q3)");
        t.set(0, this.indepVariables.size() + 5, this.depVariable + " (n)");
        int row = 1;
        for (Object key : arrayList) {
            for (int c = 0; c < this.indepVariables.size(); ++c) {
                t.set(row, c, (String)key.get(c));
            }
            SummaryStatistics current = stats.getSummaryStat((List<String>)key);
            t.set(row, this.indepVariables.size(), current.getMean());
            t.set(row, this.indepVariables.size() + 1, current.getStandardDeviation());
            t.set(row, this.indepVariables.size() + 2, stats.median((List<String>)key));
            t.set(row, this.indepVariables.size() + 3, stats.percentile((List<String>)key, 0.25));
            t.set(row, this.indepVariables.size() + 4, stats.percentile((List<String>)key, 0.75));
            t.set(row, this.indepVariables.size() + 5, current.getN());
            ++row;
        }
        IO.writeToDisk(Execution.getFile("summary.csv"), t.toCSV(true));
        for (Object key : collapsedValues.keySet()) {
            if (((Set)collapsedValues.get(key)).size() <= 1) continue;
            List<Object> toPrint = CollUtils.list((Collection)collapsedValues.get(key));
            if (toPrint.size() > 10) {
                int size = toPrint.size();
                toPrint = toPrint.subList(0, 9);
                toPrint.add("... (" + size + "items total)");
            }
            LogInfo.logsForce("Collapsed: " + (String)key + " " + toPrint);
        }
        LogInfo.logsForce("Filters:" + this.printRegexes());
        File plotDir = new File(Execution.getFile("plots"));
        LogInfo.logsForce("Saving plots in " + plotDir.getAbsolutePath());
        this.plotFactories.saveAllPlots(plotDir);
        for (String key : this.histograms.keySet()) {
            this.histograms.get(key).savePlot(new File(plotDir, key.replaceAll("[/]", "_") + ".pdf"));
        }
    }

    private void prepareRegex() {
        if (this.selectFields.size() != this.selectRegex.size()) {
            throw new RuntimeException();
        }
        this.selectCompiledRegex = CollUtils.list();
        for (String regex : this.selectRegex) {
            this.selectCompiledRegex.add(Pattern.compile(regex));
        }
    }

    private boolean selected(Map<String, String> datum) {
        for (int i = 0; i < this.selectFields.size(); ++i) {
            boolean match;
            String field = this.selectFields.get(i);
            Pattern regex = this.selectCompiledRegex.get(i);
            String value = datum.get(field);
            if (value == null || (match = regex.matcher(value).matches())) continue;
            return false;
        }
        return true;
    }

    private String printRegexes() {
        String result = "";
        for (int i = 0; i < this.filteredFields.size(); ++i) {
            result = result + this.filteredFields.get(i) + ":s/" + this.filteredRegex.get(i) + "/" + this.filteredReplace.get(i) + "\t(applied " + this.matches.getCount(i) + " time(s))\n";
        }
        return result;
    }

    private void applyRegex(Map<String, String> keyValues) {
        for (String key : keyValues.keySet()) {
            if (!this.filteredFieldsSet.contains(key)) continue;
            for (int index = 0; index < this.filteredFields.size(); ++index) {
                if (!this.filteredFields.get(index).equals(key) || !keyValues.get(key).matches(this.filteredRegex.get(index))) continue;
                this.matches.incrementCount(index, 1.0);
                keyValues.put(key, keyValues.get(key).replaceFirst(this.filteredRegex.get(index), this.filteredReplace.get(index)).intern());
            }
        }
    }

    private void addToCollapsedValues(Map<String, Set<String>> collapsedValues, Map<String, String> datum) {
        for (String key : datum.keySet()) {
            if (this.allNonCollapsedVariables.contains(key)) continue;
            CollUtils.getNoNullSet(collapsedValues, key).add(datum.get(key));
        }
    }

    private void addToStats(StatisticsMap<List<String>> stats, Map<String, String> datum, Map<String, String> options, Plot2D.Plot2DFactories plotFactories) {
        ArrayList key = CollUtils.list();
        for (String indepVar : this.indepVariables) {
            key.add(AnalyzeCSVs.get(indepVar, datum, options).toString());
        }
        double value = Double.parseDouble(datum.get(this.depVariable));
        stats.addValue(key, value);
        if (!this.createPlot) {
            return;
        }
        String legendValue = this.useLegend ? (String)key.get(this.indepVariables.size() - 2) : "";
        ArrayList fileKey = CollUtils.list();
        for (int i = 0; i < this.indepVariables.size() - (this.useLegend ? 2 : 1); ++i) {
            fileKey.add(AnalyzeCSVs.get(this.indepVariables.get(i), datum, options).toString());
        }
        String xStr = (String)key.get(this.indepVariables.size() - 1);
        double x = Double.parseDouble(xStr);
        plotFactories.getFactory("plot" + StrUtils.join(fileKey, "_")).add(legendValue, x, value);
    }

    private void addToHistStats(Map<String, String> datum, Map<String, String> options) {
        if (!this.createHist) {
            return;
        }
        ArrayList key = CollUtils.list();
        for (String indepVar : this.indepVariables) {
            key.add(AnalyzeCSVs.get(indepVar, datum, options).toString());
        }
        double value = Double.parseDouble(datum.get(this.depVariable));
        ArrayList fileKey = CollUtils.list();
        for (int i = 0; i < this.indepVariables.size(); ++i) {
            fileKey.add(AnalyzeCSVs.get(this.indepVariables.get(i), datum, options).toString());
        }
        CollUtils.getNoNull(this.histograms, new StringBuilder().append((String)"hist").append((String)StrUtils.join(fileKey, (String)"_")).toString(), new PlotHistogram()).points.add(value);
    }

    public static <K, V> Object get(V key, Map<K, V> m1, Map<K, V> m2) {
        if (m1.containsKey(key) && m2.containsKey(key) && !m1.get(key).equals(m2.get(key))) {
            throw new RuntimeException();
        }
        NotFound result = null;
        if (m1.containsKey(key)) {
            result = (NotFound)m1.get(key);
        }
        if (m2.containsKey(key)) {
            result = (NotFound)m2.get(key);
        }
        if (result == null) {
            result = notFound;
        }
        return result;
    }

    public Map<String, String> parseOptions(File optionsFile) {
        if (this.indepVarSet == null) {
            this.indepVarSet = new HashSet<String>(this.indepVariables);
        }
        HashMap<String, String> result = CollUtils.map();
        for (String line : IO.i(optionsFile)) {
            String[] fields = line.split("\\s+");
            String key = fields[0].intern();
            if (!this.depVariable.equals(key) && !this.indepVarSet.contains(key)) continue;
            result.put(key, fields.length > 1 ? fields[1] : null);
        }
        return result;
    }

    public static class NotFound {
        public String toString() {
            return "NotFound";
        }
    }
}

