/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import fig.basic.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import nuts.util.CollUtils;
import nuts.util.Counter;

public class CounterUtils {
    public static <T> void scaleEquals(Counter<T> counter, double scaling) {
        for (T key : counter.keySet()) {
            counter.setCount(key, counter.getCount(key) * scaling);
        }
    }

    public static <T> void addEquals(Counter<T> destination, Counter<T> other, double scaling) {
        for (Object key : CollUtils.union(destination.keySet(), other.keySet())) {
            destination.setCount(key, destination.getCount(key) + scaling * other.getCount(key));
        }
    }

    public static <T> void absEquals(Counter<T> counter) {
        for (T key : counter.keySet()) {
            counter.setCount(key, Math.abs(counter.getCount(key)));
        }
    }

    public static <T> double l1(Counter<T> c1, Counter<T> c2) {
        c1 = new Counter<T>(c1);
        CounterUtils.addEquals(c1, c2, -1.0);
        CounterUtils.absEquals(c1);
        return c1.totalCount();
    }

    public static <T> double lInfinity(Counter<T> c1, Counter<T> c2) {
        c1 = new Counter<T>(c1);
        CounterUtils.addEquals(c1, c2, -1.0);
        CounterUtils.absEquals(c1);
        return c1.max();
    }

    public static void main(String[] args) {
        Counter<String> c1 = new Counter<String>();
        Counter<String> c2 = new Counter<String>();
        c1.incrementCount("a", 1.0);
        c2.incrementCount("b", 1.0);
        System.out.println(CounterUtils.lInfinity(c1, c2));
    }

    public static void saveStringCounter(Counter weights, File file) {
        PrintWriter out = IOUtils.openOutHard(file);
        for (Object key : weights) {
            if (!(key instanceof String)) {
                throw new RuntimeException("A key is not a string: could cause problems at restoration phase");
            }
            out.append(key.toString() + "\t" + weights.getCount(key) + "\n");
        }
        out.close();
    }

    public static Counter<String> restoreStringCounter(File file) {
        Counter<String> result = new Counter<String>();
        BufferedReader br = IOUtils.openInHard(file);
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                String[] fields = line.split("\\t+");
                String f = fields[0];
                double w = Double.parseDouble(fields[1]);
                if (result.containsKey(f)) {
                    throw new RuntimeException("Duplicate entries for " + f + " in " + file);
                }
                result.setCount(f, w);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

