/*
 * Decompiled with CFR 0.152.
 */
package pedi.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import pedi.Genotypes;
import pedi.Individual;
import pedi.Pedigree;
import pedi.SimplePedigree;

public class PedigreeFileReader {
    private final CreatePedigree listener = new CreatePedigree();

    public Pedigree getPedigree() {
        return this.listener.pedigree;
    }

    public Genotypes getGenotypes() {
        return this.listener.genotypes;
    }

    public Map<Individual, Integer> getGenders() {
        return this.listener.genders;
    }

    public void read(File f) {
        this.read(f.getPath());
    }

    public void read(String file) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = "";
            StringTokenizer st = null;
            int lineNumber = 0;
            int tokenNumber = 0;
            while ((line = br.readLine()) != null) {
                tokenNumber = 0;
                st = new StringTokenizer(line);
                ArrayList<Integer> alleles = new ArrayList<Integer>(100);
                IndividualListener indiv = this.listener.getIndividualListener(++lineNumber);
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    if (++tokenNumber <= 6) {
                        Integer i = null;
                        try {
                            i = new Integer(t);
                        }
                        catch (NumberFormatException e) {
                            if (tokenNumber == 1) {
                                System.out.println("Family at line number " + lineNumber + " is not an integer: " + e);
                            } else if (tokenNumber == 2) {
                                System.out.println("Individual at line number " + lineNumber + " is not an integer: " + e);
                            } else if (tokenNumber == 3) {
                                System.out.println("Father at line number " + lineNumber + " is not an integer: " + e);
                            } else if (tokenNumber == 4) {
                                System.out.println("Mother at line number " + lineNumber + " is not an integer: " + e);
                            } else if (tokenNumber == 5) {
                                System.out.println("Sex at line number " + lineNumber + " is not an integer: " + e);
                            } else if (tokenNumber == 6) {
                                System.out.println("Affection at line number " + lineNumber + " is not an integer: " + e);
                            }
                            throw new RuntimeException(e);
                        }
                        if (tokenNumber == 5 && i != 0 && i != 1 && i != 2) {
                            System.out.println("Sex at line number " + lineNumber + " is not an allowed integer.");
                            throw new RuntimeException();
                        }
                        if (tokenNumber == 6 && i != 0 && i != 1 && i != 2) {
                            System.out.println("Affection at line number " + lineNumber + " is not an allowed integer.");
                            throw new RuntimeException();
                        }
                        if (tokenNumber == 1) {
                            indiv.addFamilyName(i);
                        }
                        if (tokenNumber == 2) {
                            indiv.addName(i);
                        }
                        if (tokenNumber == 3) {
                            indiv.addFather(i);
                        }
                        if (tokenNumber == 4) {
                            indiv.addMother(i);
                        }
                        if (tokenNumber == 5) {
                            indiv.addGender(i);
                        }
                        if (tokenNumber == 6) {
                            indiv.addDisease(i);
                        }
                    }
                    if (tokenNumber <= 6) continue;
                    Integer a = null;
                    try {
                        a = new Integer(t);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Individual at line number " + lineNumber + " is not an integer: " + e);
                        System.exit(-247);
                    }
                    alleles.add(a);
                }
                if (tokenNumber >= 6 && tokenNumber % 2 == 1) {
                    System.out.println("Line number " + lineNumber + " does not have an even number of alleles.");
                    throw new RuntimeException();
                }
                indiv.processGenotype(alleles);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void checkConsistent(SimplePedigree pedigree, Map<Individual, Integer> genders, Map<Individual, Integer> lineNumbers) {
        HashMap<Individual, ArrayList<Individual>> children = new HashMap<Individual, ArrayList<Individual>>();
        for (Individual indiv : pedigree.individuals()) {
            Individual[] parents = new Individual[2];
            for (int p = 0; p < 2; ++p) {
                parents[p] = pedigree.parent(indiv, p);
                ArrayList<Individual> a = (ArrayList<Individual>)children.get(parents[p]);
                if (a == null) {
                    a = new ArrayList<Individual>();
                    children.put(parents[p], a);
                }
                a.add(indiv);
            }
        }
        HashSet<Individual> visited = new HashSet<Individual>();
        LinkedList<Individual> q = new LinkedList<Individual>();
        Object[] pia = pedigree.individuals().toArray();
        q.add((Individual)pia[0]);
        while (!q.isEmpty()) {
            Individual indiv = (Individual)q.remove();
            visited.add(indiv);
            Individual[] parents = new Individual[2];
            int sum_genders = 0;
            for (int p = 0; p < 2; ++p) {
                parents[p] = pedigree.parent(indiv, p);
                if (parents[p] == null) continue;
                if (!visited.contains(parents[p])) {
                    q.add(parents[p]);
                }
                sum_genders += genders.get(parents[p]).intValue();
            }
            if (sum_genders != 3 && sum_genders != 0) {
                System.out.println("ERROR: individual " + indiv + " at line " + lineNumbers.get(indiv) + " does not have male and female parent.");
                throw new RuntimeException();
            }
            ArrayList a = (ArrayList)children.get(indiv);
            if (a == null) continue;
            for (Individual c : a) {
                if (visited.contains(c)) continue;
                q.add(c);
            }
        }
        boolean visitedAll = true;
        for (Individual indiv : pedigree.individuals()) {
            if (visited.contains(indiv)) continue;
            visitedAll = false;
        }
        if (!visitedAll) {
            // empty if block
        }
    }

    public static void main(String[] args) {
        PedigreeFileReader reader = new PedigreeFileReader();
        reader.read("./src-pedi/pedi/io/ped1.ped");
        System.out.println(reader.getPedigree().individuals());
    }

    public static class CreatePedigree
    implements PedigreeListener {
        private SimplePedigree pedigree = new SimplePedigree();
        private Map<Individual, Integer> genders = new HashMap<Individual, Integer>();
        private Map<Individual, Integer> affection = new HashMap<Individual, Integer>();
        private final Map<Individual, Integer> lineNumbers = new HashMap<Individual, Integer>();
        private final Genotypes genotypes = new Genotypes();

        @Override
        public IndividualListener getIndividualListener(int lineNumber) {
            return new CreateIndividual(lineNumber);
        }

        public class CreateIndividual
        implements IndividualListener {
            int line;
            int currentFamilyName;
            int currentName;

            public CreateIndividual(int n) {
                this.line = n;
            }

            @Override
            public void addFamilyName(Integer i) {
                this.currentFamilyName = i;
            }

            @Override
            public void addName(Integer i) {
                this.currentName = i;
                CreatePedigree.this.pedigree.add(this.getIndividual(i));
                CreatePedigree.this.lineNumbers.put(this.getIndividual(i), this.line);
            }

            public Individual getIndividual(int i) {
                return new Individual("" + i, "" + this.currentFamilyName);
            }

            @Override
            public void addFather(Integer i) {
                if (i == 0) {
                    return;
                }
                CreatePedigree.this.pedigree.addRelation(this.getIndividual(i), this.getIndividual(this.currentName), 0);
            }

            @Override
            public void addMother(Integer i) {
                if (i == 0) {
                    return;
                }
                CreatePedigree.this.pedigree.addRelation(this.getIndividual(i), this.getIndividual(this.currentName), 1);
            }

            @Override
            public void addGender(Integer i) {
                if (i != 0) {
                    if (i != 1 && i != 2) {
                        throw new RuntimeException();
                    }
                    CreatePedigree.this.genders.put(this.getIndividual(this.currentName), i);
                }
            }

            @Override
            public void addDisease(Integer i) {
                if (i != 0) {
                    if (i != 1 && i != 2) {
                        throw new RuntimeException();
                    }
                    CreatePedigree.this.affection.put(this.getIndividual(this.currentName), i);
                }
            }

            @Override
            public void processGenotype(ArrayList<Integer> alleles) {
                CreatePedigree.this.genotypes.putBiAllelicDiploidGenotype(this.getIndividual(this.currentName), alleles);
            }
        }
    }

    public static interface IndividualListener {
        public void addFamilyName(Integer var1);

        public void addName(Integer var1);

        public void addFather(Integer var1);

        public void addMother(Integer var1);

        public void addGender(Integer var1);

        public void addDisease(Integer var1);

        public void processGenotype(ArrayList<Integer> var1);
    }

    public static interface PedigreeListener {
        public IndividualListener getIndividualListener(int var1);
    }
}

