/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import java.util.ArrayList;
import java.util.List;
import pepper.FeatureVector;
import pepper.NaturalClass;
import pepper.Rule;
import pepper.RuleBank;
import pepper.SparseFeatureVector;

public class SubstitutionRuleBank
implements RuleBank {
    private static final Character[] consonantsArray = new Character[]{Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
    private static final Character[] vowelsArray = new Character[]{Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u')};
    private static List<Character> letter = null;
    private static NaturalClass consonants = null;
    private static NaturalClass vowels = null;

    public static List<Character> getAlphabet() {
        if (letter != null) {
            return letter;
        }
        List<Character> letter = SubstitutionRuleBank.charArray2List(consonantsArray);
        letter.addAll(SubstitutionRuleBank.charArray2List(vowelsArray));
        return letter;
    }

    public static NaturalClass getConsonants() {
        if (consonants != null) {
            return consonants;
        }
        consonants = new NaturalClass("C", SubstitutionRuleBank.charArray2List(consonantsArray));
        return consonants;
    }

    public static NaturalClass getVowels() {
        if (vowels != null) {
            return vowels;
        }
        vowels = new NaturalClass("V", SubstitutionRuleBank.charArray2List(vowelsArray));
        return vowels;
    }

    public static List<Character> charArray2List(Character[] array) {
        ArrayList<Character> result = new ArrayList<Character>();
        Character[] characterArray = array;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char c = characterArray[i].charValue();
            result.add(Character.valueOf(c));
        }
        return result;
    }

    @Override
    public List<Rule> getRules() {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (char c1 : SubstitutionRuleBank.getAlphabet()) {
            for (char c2 : SubstitutionRuleBank.getAlphabet()) {
                if (c1 == c2) continue;
                result.add(new SubstitutionRule(SubstitutionRuleBank.getVowels(), SubstitutionRuleBank.getVowels(), Character.valueOf(c1), Character.valueOf(c2)));
                result.add(new SubstitutionRule(SubstitutionRuleBank.getConsonants(), SubstitutionRuleBank.getConsonants(), Character.valueOf(c1), Character.valueOf(c2)));
            }
        }
        return result;
    }

    private static FeatureVector applyMult(FeatureVector fv, double scalingOnFinalEnv, double scalingOnInitEnv, NaturalClass c1, NaturalClass c2, Character initialChar, Character finalChar) {
        SparseFeatureVector result = new SparseFeatureVector(fv);
        for (Character nce1 : c1.getElements()) {
            for (Character nce2 : c2.getElements()) {
                String finalEnv;
                String initialEnv = "" + nce1 + initialChar + nce2;
                double currentValue = fv.getValue(initialEnv);
                if (currentValue != 0.0) {
                    result.setValue(initialEnv, currentValue * scalingOnInitEnv);
                }
                if ((currentValue = fv.getValue(finalEnv = "" + nce1 + finalChar + nce2)) == 0.0) continue;
                result.setValue(finalEnv, currentValue * scalingOnFinalEnv);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        SparseFeatureVector fv = new SparseFeatureVector();
        fv.setValue("sas", 1.0);
        fv.setValue("sbs", 1.0E-4);
        SubstitutionRule r = new SubstitutionRule(SubstitutionRuleBank.getConsonants(), SubstitutionRuleBank.getConsonants(), Character.valueOf('a'), Character.valueOf('b'));
        FeatureVector fv2 = r.applyRule(fv);
        System.out.println(fv);
        System.out.println(fv2);
    }

    public static class BrokenSubstitutionRule
    implements Rule {
        public static double scaling = 2.0;
        public static double inverseScaling = 0.5;
        private NaturalClass c1;
        private NaturalClass c2;
        private Character initialChar;
        private Character finalChar;

        public BrokenSubstitutionRule(NaturalClass c1, NaturalClass c2, Character initialChar, Character finalChar) {
            this.c1 = c1;
            this.c2 = c2;
            this.initialChar = initialChar;
            this.finalChar = finalChar;
        }

        @Override
        public FeatureVector applyInverse(FeatureVector fv) {
            return SubstitutionRuleBank.applyMult((SparseFeatureVector)fv, BrokenSubstitutionRule.scaling, BrokenSubstitutionRule.inverseScaling, this.c1, this.c2, this.initialChar, this.finalChar);
        }

        @Override
        public FeatureVector applyRule(FeatureVector fv) {
            return SubstitutionRuleBank.applyMult((SparseFeatureVector)fv, BrokenSubstitutionRule.inverseScaling, BrokenSubstitutionRule.scaling, this.c1, this.c2, this.initialChar, this.finalChar);
        }

        public String toString() {
            return this.c1.toString() + this.initialChar + this.c2.toString() + " -> " + this.c1.toString() + this.finalChar + this.c2.toString();
        }
    }

    public static class SubstitutionRule
    implements Rule {
        public static final double epsilon = 0.1;
        private NaturalClass c1;
        private NaturalClass c2;
        private Character initialChar;
        private Character finalChar;

        public SubstitutionRule(NaturalClass c1, NaturalClass c2, Character initialChar, Character finalChar) {
            this.c1 = c1;
            this.c2 = c2;
            this.initialChar = initialChar;
            this.finalChar = finalChar;
        }

        public String toString() {
            return this.c1.toString() + this.initialChar + this.c2.toString() + " -> " + this.c1.toString() + this.finalChar + this.c2.toString();
        }

        @Override
        public FeatureVector applyInverse(FeatureVector fv) {
            double oldInitMass;
            double initMass = this.getMass(false, fv);
            double finalMass = this.getMass(true, fv);
            double oldFinalMass = finalMass - 0.9 * (oldInitMass = initMass / 0.1);
            if (oldFinalMass == 0.0) {
                return null;
            }
            double alpha = 0.9 * oldInitMass / oldFinalMass;
            return SubstitutionRuleBank.applyMult(fv, 1.0 / (1.0 + alpha), 10.0, this.c1, this.c2, this.initialChar, this.finalChar);
        }

        @Override
        public FeatureVector applyRule(FeatureVector fv) {
            double initMass = this.getMass(false, fv);
            double finalMass = this.getMass(true, fv);
            if (finalMass == 0.0) {
                return null;
            }
            double alpha = 0.9 * initMass / finalMass;
            return SubstitutionRuleBank.applyMult(fv, 1.0 + alpha, 0.1, this.c1, this.c2, this.initialChar, this.finalChar);
        }

        private double getMass(boolean useFinalEnv, FeatureVector fv) {
            double mass = 0.0;
            for (Character nce1 : this.c1.getElements()) {
                for (Character nce2 : this.c2.getElements()) {
                    String key = null;
                    key = useFinalEnv ? "" + nce1 + this.finalChar + nce2 : "" + nce1 + this.initialChar + nce2;
                    mass += fv.getValue(key);
                }
            }
            return mass;
        }
    }
}

