/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.BigStatFig;
import fig.basic.Exceptions;
import fig.basic.LogInfo;
import fig.basic.NumUtils;
import fig.basic.Option;
import fig.basic.Pair;
import fig.basic.StrUtils;
import fig.exec.Execution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import pepper.Edit;
import pepper.Encodings;
import pepper.WordSampler;
import pepper.editmodel.EditParam;
import pepper.editmodel.PhonemeModel;
import pepper.editmodel.Utils;

public class TimeConvectorWordSampler {
    private final Encodings enc;
    private double[][][][][][] sumProb;
    private double[] ntopSumProb;
    private double globalSumProb;
    private EditParam top2MiddleParam;
    private EditParam middle2Bottom1Param;
    private EditParam middle2Bottom2Param;
    private PhonemeModel phonemeModel;
    private String topStr;
    private String bottom1Str;
    private String bottom2Str;
    private int nbottom1;
    private int nbottom2;
    private int nc;
    private int[] top;
    private int[] bottom1;
    private int[] bottom2;
    private int boundaryx;
    private int boundaryc;
    private int minNtop;
    private int maxNtop;
    private boolean samplingFailed;
    private StringBuilder middleStrBuf;
    private List<Edit> top2MiddleEdits;
    private List<Edit> middle2Bottom1Edits;
    private List<Edit> middle2Bottom2Edits;
    private double outputProb;
    private Random random;
    private int maxDeviation;
    private boolean onlySubAfterFission;
    private boolean findViterbi;
    public boolean verboseRecursion = false;
    public boolean verboseDPTable = false;
    private static final double epsilon = 1.0E-6;
    public RecursionChoice nullChoice = new NullChoice();
    public RestChoice restChoice = new RestChoice();
    public Top2MiddleChoice top2MiddleChoice = new Top2MiddleChoice();
    public Top2MiddleDeletionChoice top2MiddleDeletionChoice = new Top2MiddleDeletionChoice();
    public NextMiddleClassChoice nextMiddleClassChoice = new NextMiddleClassChoice();
    public Top2MiddleSubstitutionChoice top2MiddleSubstitutionChoice = new Top2MiddleSubstitutionChoice();
    public RecursionChoice top2MiddleFissionChoice = new Top2MiddleFissionChoice();
    public RecursionChoice middle2BottomsChoice = new Middle2BottomsChoice(false);
    public RecursionChoice middle2BottomsOnlySubChoice = new Middle2BottomsChoice(true);
    public RecursionChoice middle2Bottom1Choice;
    public RecursionChoice middle2Bottom2Choice;
    public RecursionChoice middle2Bottom1OnlySubChoice;
    public RecursionChoice middle2Bottom2OnlySubChoice;
    private static List<Integer> allSuccessors = null;

    private boolean topExists() {
        return this.topStr != null;
    }

    private boolean bottom1Exists() {
        return this.bottom1Str != null;
    }

    private boolean bottom2Exists() {
        return this.bottom2Str != null;
    }

    public TimeConvectorWordSampler(Encodings enc) {
        this.enc = enc;
    }

    public void init(Random random, PhonemeModel phonemeModel, EditParam top2MiddleParam, EditParam middle2Bottom1Param, EditParam middle2Bottom2Param, int maxDeviation, String topStr, String bottom1Str, String bottom2Str, boolean onlySubAfterFission) {
        this.random = random;
        this.phonemeModel = phonemeModel == null ? new PhonemeModel(top2MiddleParam.getEncodings()) : phonemeModel;
        this.top2MiddleParam = top2MiddleParam;
        this.middle2Bottom1Param = middle2Bottom1Param;
        this.middle2Bottom2Param = middle2Bottom2Param;
        this.topStr = topStr;
        this.bottom1Str = bottom1Str;
        this.bottom2Str = bottom2Str;
        this.maxDeviation = maxDeviation;
        this.onlySubAfterFission = onlySubAfterFission;
        this.top = this.encode(topStr);
        this.bottom1 = this.encode(bottom1Str);
        this.bottom2 = this.encode(bottom2Str);
        this.nbottom1 = this.bottom1.length;
        this.nbottom2 = this.bottom2.length;
        this.nc = this.enc.getNumberOfEqClasses();
        this.boundaryx = this.enc.getBoundaryPhoneId();
        this.boundaryc = this.enc.getBoundaryEqClassId();
        if (this.topExists()) assert (top2MiddleParam != null);
        if (this.bottom1Exists()) {
            if (middle2Bottom1Param == null) {
                throw new RuntimeException("m2b1 is null");
            }
            if (this.nbottom1 <= 0) {
                throw new RuntimeException("nb1=" + this.nbottom1);
            }
        }
        if (this.bottom2Exists()) {
            if (middle2Bottom2Param == null) {
                throw new RuntimeException("m2b2 is null");
            }
            if (this.nbottom2 <= 0) {
                throw new RuntimeException("nb2=" + this.nbottom2);
            }
        }
        if (this.topExists()) {
            this.minNtop = this.maxNtop = this.top.length;
        } else if (!this.bottom1Exists() && !this.bottom2Exists()) {
            this.minNtop = 1;
            this.maxNtop = 3;
        } else {
            maxDeviation = Math.min(maxDeviation, 1000000);
            this.minNtop = Integer.MAX_VALUE;
            if (this.bottom1Exists()) {
                this.minNtop = Math.min(this.minNtop, this.nbottom1);
            }
            if (this.bottom2Exists()) {
                this.minNtop = Math.min(this.minNtop, this.nbottom2);
            }
            this.minNtop = Math.max(this.minNtop - maxDeviation, 1);
            this.maxNtop = 0;
            if (this.bottom1Exists()) {
                this.maxNtop = Math.max(this.maxNtop, this.nbottom1);
            }
            if (this.bottom2Exists()) {
                this.maxNtop = Math.max(this.maxNtop, this.nbottom2);
            }
            this.maxNtop = Math.min(this.maxNtop + maxDeviation, this.maxNtop * 2);
        }
    }

    private int[] encode(String s) {
        return s == null ? new int[]{} : this.enc.string2PhoneIds(s);
    }

    public void setFindViterbi(boolean findViterbi) {
        this.findViterbi = findViterbi;
    }

    public boolean sample() {
        boolean v = false;
        if (v) {
            LogInfo.track("SAMPLE %s %s %s (maxDeviation=%d, ntop=%d,%d)", this.topStr, this.bottom1Str, this.bottom2Str, this.maxDeviation, this.minNtop, this.maxNtop);
        }
        if (this.sumProb == null) {
            this.globalSumProb = Double.NaN;
            this.ntopSumProb = new double[this.maxNtop + 1];
            this.sumProb = new double[this.maxNtop + 1][][][][][];
            for (int ntop = this.minNtop; ntop <= this.maxNtop; ++ntop) {
                this.ntopSumProb[ntop] = Double.NaN;
                this.sumProb[ntop] = new double[this.maxNtop + 1][this.nbottom1 + 1][this.nbottom2 + 1][this.nc][this.nc];
                for (int i = 0; i <= this.maxNtop; ++i) {
                    for (int j = 0; j <= this.nbottom1; ++j) {
                        for (int k = 0; k <= this.nbottom2; ++k) {
                            for (int c1 = 0; c1 < this.nc; ++c1) {
                                for (int c2 = 0; c2 < this.nc; ++c2) {
                                    this.sumProb[ntop][i][j][k][c1][c2] = Double.NaN;
                                }
                            }
                        }
                    }
                }
            }
        }
        this.samplingFailed = false;
        this.middleStrBuf = new StringBuilder();
        this.top2MiddleEdits = new ArrayList<Edit>();
        this.middle2Bottom1Edits = new ArrayList<Edit>();
        this.middle2Bottom2Edits = new ArrayList<Edit>();
        this.outputProb = 1.0;
        this.middle2Bottom1Choice = new Middle2BottomChoice(1, false);
        this.middle2Bottom2Choice = new Middle2BottomChoice(2, false);
        this.middle2Bottom1OnlySubChoice = new Middle2BottomChoice(1, true);
        this.middle2Bottom2OnlySubChoice = new Middle2BottomChoice(2, true);
        this.computeSumProb(false);
        this.computeSumProb(true);
        this.middleStrBuf.reverse();
        if (this.findViterbi) assert (Math.abs(this.globalSumProb - this.outputProb) < 1.0E-6);
        if (v) {
            LogInfo.end_track();
        }
        return !this.samplingFailed;
    }

    public String getMiddleStr() {
        return this.middleStrBuf.toString();
    }

    private List<Edit> reverse(List<Edit> edits) {
        ArrayList<Edit> result = new ArrayList<Edit>();
        result.addAll(edits);
        Collections.reverse(result);
        return result;
    }

    public List<Edit> getTop2MiddleEdits() {
        return this.reverse(this.top2MiddleEdits);
    }

    public List<Edit> getMiddle2Bottom1Edits() {
        return this.reverse(this.middle2Bottom1Edits);
    }

    public List<Edit> getMiddle2Bottom2Edits() {
        return this.reverse(this.middle2Bottom2Edits);
    }

    public double getOutputProb() {
        return this.outputProb;
    }

    public double getSumProb() {
        return this.globalSumProb;
    }

    public double getOutputNormProb() {
        return this.outputProb / this.globalSumProb;
    }

    private int topx(int i) {
        if (this.topExists()) {
            return i >= 0 && i < this.top.length ? this.top[i] : this.boundaryx;
        }
        return this.boundaryx;
    }

    private int topc(int i) {
        return this.x2c(this.topx(i));
    }

    private int x2c(int x) {
        return this.enc.phoneId2EqClassId(x);
    }

    public void addmx(int mx) {
        this.middleStrBuf.append(this.enc.phoneId2Char(mx));
    }

    private double computeSumProb(boolean doSample) {
        if (!doSample && !Double.isNaN(this.globalSumProb)) {
            return this.globalSumProb;
        }
        double accumProb = 0.0;
        double targetProb = Double.NaN;
        if (doSample) {
            targetProb = this.findViterbi ? this.globalSumProb : this.random.nextDouble() * this.globalSumProb;
        }
        for (int ntop = this.minNtop; ntop <= this.maxNtop; ++ntop) {
            accumProb = this.findViterbi ? Math.max(accumProb, this.computeSumProb(ntop, false)) : (accumProb += this.computeSumProb(ntop, false));
            if (!doSample || !(accumProb >= targetProb)) continue;
            return this.computeSumProb(ntop, true);
        }
        if (doSample) {
            this.samplingFailed = true;
            return Double.NaN;
        }
        if (this.verboseDPTable) {
            LogInfo.dbg("globalSumProb = %f", accumProb);
        }
        this.globalSumProb = accumProb;
        return this.globalSumProb;
    }

    private double computeSumProb(int ntop, boolean doSample) {
        if (!doSample && !Double.isNaN(this.ntopSumProb[ntop])) {
            return this.ntopSumProb[ntop];
        }
        double accumProb = 0.0;
        double targetProb = Double.NaN;
        if (doSample) {
            targetProb = this.findViterbi ? this.ntopSumProb[ntop] : this.random.nextDouble() * this.ntopSumProb[ntop];
        }
        int mc1 = this.boundaryc;
        for (int mc2 = 0; mc2 < this.nc; ++mc2) {
            accumProb = this.findViterbi ? Math.max(accumProb, this.computeSumProb(ntop, 0, 0, 0, mc1, mc2, false)) : (accumProb += this.computeSumProb(ntop, 0, 0, 0, mc1, mc2, false));
            if (!doSample || !(accumProb >= targetProb)) continue;
            return this.computeSumProb(ntop, 0, 0, 0, mc1, mc2, true);
        }
        if (doSample) {
            this.samplingFailed = true;
            return Double.NaN;
        }
        if (this.verboseDPTable) {
            LogInfo.dbg("ntopSumProb[ntop=%d] = %f", ntop, accumProb);
        }
        this.ntopSumProb[ntop] = accumProb;
        return this.ntopSumProb[ntop];
    }

    private double computeSumProb(int ntop, int i, int j, int k, int c1, int c2, boolean doSample) {
        if (this.bottom1Exists()) {
            if (Math.abs(i - j) > this.maxDeviation) {
                return 0.0;
            }
            if (i == ntop && j < this.nbottom1) {
                return 0.0;
            }
        }
        if (this.bottom2Exists()) {
            if (Math.abs(i - k) > this.maxDeviation) {
                return 0.0;
            }
            if (i == ntop && k < this.nbottom2) {
                return 0.0;
            }
        }
        if (i == ntop && j == this.nbottom1 && k == this.nbottom2) {
            return c2 == this.boundaryc ? 1.0 : 0.0;
        }
        if (!doSample && !Double.isNaN(this.sumProb[ntop][i][j][k][c1][c2])) {
            return this.sumProb[ntop][i][j][k][c1][c2];
        }
        RecursionState state = new RecursionState(ntop, i, j, k, c1, c2);
        RecursionInfo info = new RecursionInfo(state);
        info.recursiveSample(this.top2MiddleChoice);
        double accumProb = info.getAccumProb();
        NumUtils.assertIsFinite(accumProb);
        if (!doSample) {
            if (this.verboseDPTable) {
                LogInfo.dbg("sumProb[ntop=%d, i=%d, j=%d, k=%d, c1=%d, c2=%d] = %f", ntop, i, j, k, c1, c2, accumProb);
            }
            double d = accumProb;
            this.sumProb[ntop][i][j][k][c1][c2] = d;
            return d;
        }
        if (info.prepareToSelect()) {
            info.recursiveSample(this.top2MiddleChoice);
        } else {
            this.samplingFailed = true;
        }
        return Double.NaN;
    }

    public static List<Integer> allSuccessors(Encodings enc) {
        if (allSuccessors == null) {
            allSuccessors = new ArrayList<Integer>();
            for (int x = 0; x < enc.getNumberOfPhonemes(); ++x) {
                allSuccessors.add(x);
            }
        }
        return allSuccessors;
    }

    public void printDebug() {
        LogInfo.logs("%s -> %s -> %s, %s (%f)", this.topStr, this.getMiddleStr(), this.bottom1Str, this.bottom2Str, this.getOutputNormProb());
        if (this.topExists()) {
            LogInfo.logs("top2MiddleEdits = " + StrUtils.join(this.getTop2MiddleEdits(), " || "));
        }
        if (this.bottom1Exists()) {
            LogInfo.logs("middle2Bottom1Edits = " + StrUtils.join(this.getMiddle2Bottom1Edits(), " || "));
        }
        if (this.bottom2Exists()) {
            LogInfo.logs("middle2Bottom2Edits = " + StrUtils.join(this.getMiddle2Bottom2Edits(), " || "));
        }
    }

    public static void main(String[] args) {
        Execution.run(args, new Tester());
    }

    public static class Tester
    implements Runnable {
        @Option
        public static Random rand = new Random(1L);
        @Option
        public static String topStr = "aa";
        @Option
        public static String bottom1Str = "abab";
        @Option
        public static String bottom2Str = null;
        @Option
        public static int testCase = 5;
        @Option
        public static int numIters = 1;
        @Option
        public static int maxDeviation = Integer.MAX_VALUE;
        @Option
        public static boolean onlySubAfterFission = false;
        @Option
        public static boolean findViterbi = false;
        @Option
        public static boolean verboseRecursion = false;
        @Option
        public static boolean verboseDPTable = false;
        @Option
        public static boolean verboseOutput = false;

        public static int count(String s, char c) {
            int n = 0;
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) != c) continue;
                ++n;
            }
            return n;
        }

        static void runTestCase(EditParam param, String a, String b, boolean timeConvector, int T) {
            LogInfo.track("runTestCase(%s -> %s; %s, T=%d)", a, b, timeConvector, T);
            LogInfo.logs("Starting...");
            Random random = new Random(1L);
            Encodings enc = param.getEncodings();
            TimeConvectorWordSampler tsampler = new TimeConvectorWordSampler(enc);
            tsampler.init(random, new PhonemeModel(enc), param, param, param, Integer.MAX_VALUE, a, b, null, onlySubAfterFission);
            tsampler.setFindViterbi(findViterbi);
            tsampler.verboseRecursion = verboseRecursion;
            tsampler.verboseDPTable = verboseDPTable;
            WordSampler sampler = new WordSampler(random, param, Integer.MAX_VALUE, a, b);
            BigStatFig fig = new BigStatFig();
            int L = Math.max(a.length(), b.length());
            double[][] counts = new double[L + 3][L + 3];
            int m = 0;
            for (int t = 0; t < T; ++t) {
                String s;
                if (timeConvector) {
                    assert (tsampler.sample());
                    s = tsampler.getMiddleStr();
                } else {
                    sampler.sample();
                    s = sampler.getMiddleStr();
                }
                double[] dArray = counts[Tester.count(s, 'a')];
                int n = Tester.count(s, 'b');
                dArray[n] = dArray[n] + 1.0;
                if (Tester.count(s, 'a') == 1) {
                    ++m;
                }
                fig.add(s.length());
            }
            System.out.println("\t0\t1\t2\t3\t4\t5\t6");
            for (int a_index = 0; a_index <= L; ++a_index) {
                System.out.print("" + a_index + "\t");
                for (int b_index = 0; b_index <= L; ++b_index) {
                    System.out.print("" + counts[a_index][b_index] / (double)T + "\t");
                }
                System.out.print("\n");
            }
            System.out.println("--->" + (double)m / (double)T);
            LogInfo.logs("Length = %s", fig);
            LogInfo.end_track();
        }

        @Override
        public void run() {
            EditParam param;
            EditParam top2MiddleParam = param = EditParam.getSanityCheck(testCase);
            EditParam middle2Bottom1Param = param;
            EditParam middle2Bottom2Param = param;
            TimeConvectorWordSampler sampler = new TimeConvectorWordSampler(param.getEncodings());
            sampler.init(rand, new PhonemeModel(param.getEncodings()), top2MiddleParam, middle2Bottom1Param, middle2Bottom2Param, maxDeviation, topStr, bottom1Str, bottom2Str, onlySubAfterFission);
            sampler.setFindViterbi(findViterbi);
            sampler.verboseRecursion = verboseRecursion;
            sampler.verboseDPTable = verboseDPTable;
            for (int i = 0; i < numIters; ++i) {
                assert (sampler.sample());
                if (verboseOutput) {
                    sampler.printDebug();
                } else {
                    LogInfo.logs(sampler.getMiddleStr() + " " + sampler.getOutputNormProb());
                }
                List<Edit> top2Middle = sampler.getTop2MiddleEdits();
                if (sampler.getMiddleStr().equals(Utils.bottomWord(top2Middle))) continue;
                throw new RuntimeException("Expected: " + sampler.getMiddleStr() + ", got: " + Utils.bottomWord(top2Middle));
            }
        }
    }

    class Middle2BottomChoice
    extends RecursionChoice {
        private int which;
        private EditParam param;
        private List<Edit> edits;
        private boolean onlySub;

        public Middle2BottomChoice(int which, boolean onlySub) {
            this.which = which;
            this.onlySub = onlySub;
            if (which == 1) {
                this.param = TimeConvectorWordSampler.this.middle2Bottom1Param;
                this.edits = TimeConvectorWordSampler.this.middle2Bottom1Edits;
            } else if (which == 2) {
                this.param = TimeConvectorWordSampler.this.middle2Bottom2Param;
                this.edits = TimeConvectorWordSampler.this.middle2Bottom2Edits;
            } else {
                throw Exceptions.unknownCase(which);
            }
        }

        public int getBottomIndex(RecursionState S) {
            if (this.which == 1) {
                return S.j;
            }
            if (this.which == 2) {
                return S.k;
            }
            throw Exceptions.unknownCase;
        }

        public int getBottomLength(RecursionState S) {
            if (this.which == 1) {
                return TimeConvectorWordSampler.this.nbottom1;
            }
            if (this.which == 2) {
                return TimeConvectorWordSampler.this.nbottom2;
            }
            throw Exceptions.unknownCase;
        }

        public void incrBottomIndex(RecursionState S, int d) {
            if (this.which == 1) {
                S.j += d;
            } else if (this.which == 2) {
                S.k += d;
            } else {
                throw Exceptions.unknownCase;
            }
        }

        public int getBottomX(int z) {
            if (this.which == 1) {
                return TimeConvectorWordSampler.this.bottom1[z];
            }
            if (this.which == 2) {
                return TimeConvectorWordSampler.this.bottom2[z];
            }
            throw Exceptions.unknownCase;
        }

        @Override
        public boolean recursiveSample(RecursionInfo info, RecursionState S) {
            double prob;
            int n;
            int mc1 = S.prevmidc();
            int mx = S.currmidx();
            int mc2 = S.nextmidc();
            int z = this.getBottomIndex(S);
            if (z + 0 <= (n = this.getBottomLength(S)) && !this.onlySub && info.extendPath(prob = this.param.deletionCost(mc1, mx, mc2))) {
                if (info.recursiveSample()) {
                    TimeConvectorWordSampler.this.outputProb = TimeConvectorWordSampler.this.outputProb * prob;
                    this.edits.add(new Edit(TimeConvectorWordSampler.this.enc, mc1, mx, mc2));
                    return true;
                }
                info.retractPath(prob);
            }
            if (z + 1 <= n && info.extendPath(prob = this.param.substitutionCost(mc1, mx, mc2, this.getBottomX(z)))) {
                this.incrBottomIndex(S, 1);
                if (info.recursiveSample()) {
                    TimeConvectorWordSampler.this.outputProb = TimeConvectorWordSampler.this.outputProb * prob;
                    this.edits.add(new Edit(TimeConvectorWordSampler.this.enc, mc1, mx, mc2, this.getBottomX(z)));
                    return true;
                }
                this.incrBottomIndex(S, -1);
                info.retractPath(prob);
            }
            if (z + 2 <= n && !this.onlySub && info.extendPath(prob = this.param.fissionCost(mc1, mx, mc2, this.getBottomX(z), this.getBottomX(z + 1)))) {
                this.incrBottomIndex(S, 2);
                if (info.recursiveSample()) {
                    TimeConvectorWordSampler.this.outputProb = TimeConvectorWordSampler.this.outputProb * prob;
                    this.edits.add(new Edit(TimeConvectorWordSampler.this.enc, mc1, mx, mc2, this.getBottomX(z), this.getBottomX(z + 1)));
                    return true;
                }
                this.incrBottomIndex(S, -2);
                info.retractPath(prob);
            }
            return false;
        }

        public String toString() {
            return "mid2bot" + this.which;
        }
    }

    class Middle2BottomsChoice
    extends RecursionChoice {
        private boolean onlySub;

        public Middle2BottomsChoice(boolean onlySub) {
            this.onlySub = onlySub;
        }

        @Override
        public boolean recursiveSample(RecursionInfo info, RecursionState S) {
            if (!TimeConvectorWordSampler.this.bottom1Exists() && !TimeConvectorWordSampler.this.bottom2Exists()) {
                return info.recursiveSample();
            }
            ++S.m;
            if (S.m == S.nmx) {
                if (info.recursiveSample()) {
                    return true;
                }
            } else {
                RecursionChoice recursionChoice = TimeConvectorWordSampler.this.bottom1Exists() ? (this.onlySub ? TimeConvectorWordSampler.this.middle2Bottom1OnlySubChoice : TimeConvectorWordSampler.this.middle2Bottom1Choice) : TimeConvectorWordSampler.this.nullChoice;
                RecursionChoice recursionChoice2 = TimeConvectorWordSampler.this.bottom2Exists() ? (this.onlySub ? TimeConvectorWordSampler.this.middle2Bottom2OnlySubChoice : TimeConvectorWordSampler.this.middle2Bottom2Choice) : TimeConvectorWordSampler.this.nullChoice;
                if (info.recursiveSample(recursionChoice, recursionChoice2, this)) {
                    return true;
                }
            }
            --S.m;
            return false;
        }

        public String toString() {
            return "mid2bots";
        }
    }

    class Top2MiddleFissionChoice
    extends RecursionChoice {
        Top2MiddleFissionChoice() {
        }

        @Override
        public boolean recursiveSample(RecursionInfo info, RecursionState S) {
            assert (TimeConvectorWordSampler.this.topExists());
            List<Pair<Integer, Integer>> successors = TimeConvectorWordSampler.this.top2MiddleParam.fissionSuccessors(S.tc1, S.tx, S.tc2);
            for (Pair<Integer, Integer> pair : successors) {
                double prob;
                int mxa = pair.getFirst();
                int mxb = pair.getSecond();
                int mca = TimeConvectorWordSampler.this.x2c(mxa);
                int mcb = TimeConvectorWordSampler.this.x2c(mxb);
                if (mcb != S.c2 || !info.extendPath(prob = TimeConvectorWordSampler.this.top2MiddleParam.fissionCost(S.tc1, S.tx, S.tc2, mxa, mxb) * TimeConvectorWordSampler.this.phonemeModel.getProb(S.c1, mxa) * TimeConvectorWordSampler.this.phonemeModel.getProb(mca, mxb))) continue;
                S.newc1 = mcb;
                S.push(mxa);
                S.push(mxb);
                if (info.recursiveSample(TimeConvectorWordSampler.this.onlySubAfterFission ? TimeConvectorWordSampler.this.middle2BottomsOnlySubChoice : TimeConvectorWordSampler.this.middle2BottomsChoice)) {
                    TimeConvectorWordSampler.this.outputProb = TimeConvectorWordSampler.this.outputProb * prob;
                    TimeConvectorWordSampler.this.addmx(mxb);
                    TimeConvectorWordSampler.this.addmx(mxa);
                    TimeConvectorWordSampler.this.top2MiddleEdits.add(new Edit(TimeConvectorWordSampler.this.enc, S.tc1, S.tx, S.tc2, mxa, mxb));
                    return true;
                }
                S.newc1 = -1;
                S.pop();
                S.pop();
                info.retractPath(prob);
            }
            return false;
        }

        public String toString() {
            return "top2midFis";
        }
    }

    class Top2MiddleSubstitutionChoice
    extends RecursionChoice {
        Top2MiddleSubstitutionChoice() {
        }

        @Override
        public boolean recursiveSample(RecursionInfo info, RecursionState S) {
            List<Integer> successors = TimeConvectorWordSampler.this.topExists() ? TimeConvectorWordSampler.this.top2MiddleParam.substitutionSuccessors(S.tc1, S.tx, S.tc2) : TimeConvectorWordSampler.allSuccessors(TimeConvectorWordSampler.this.enc);
            for (int mx : successors) {
                double prob;
                int mc = TimeConvectorWordSampler.this.x2c(mx);
                if (mc != S.c2 || !info.extendPath(prob = (TimeConvectorWordSampler.this.topExists() ? TimeConvectorWordSampler.this.top2MiddleParam.substitutionCost(S.tc1, S.tx, S.tc2, mx) : 1.0) * TimeConvectorWordSampler.this.phonemeModel.getProb(S.c1, mx))) continue;
                S.newc1 = mc;
                S.push(mx);
                if (info.recursiveSample(TimeConvectorWordSampler.this.middle2BottomsChoice)) {
                    TimeConvectorWordSampler.this.outputProb = TimeConvectorWordSampler.this.outputProb * prob;
                    TimeConvectorWordSampler.this.addmx(mx);
                    if (TimeConvectorWordSampler.this.topExists()) assert (TimeConvectorWordSampler.this.top2MiddleParam.cost(new Edit(TimeConvectorWordSampler.this.enc, S.tc1, S.tx, S.tc2, mx)) > 0.0);
                    if (TimeConvectorWordSampler.this.topExists()) {
                        TimeConvectorWordSampler.this.top2MiddleEdits.add(new Edit(TimeConvectorWordSampler.this.enc, S.tc1, S.tx, S.tc2, mx));
                    }
                    return true;
                }
                S.newc1 = -1;
                S.pop();
                info.retractPath(prob);
            }
            return false;
        }

        public String toString() {
            return "top2midSub";
        }
    }

    class NextMiddleClassChoice
    extends RecursionChoice {
        NextMiddleClassChoice() {
        }

        @Override
        public boolean recursiveSample(RecursionInfo info, RecursionState S) {
            S.newc2 = 0;
            while (S.newc2 < TimeConvectorWordSampler.this.nc) {
                if (info.recursiveSample()) {
                    return true;
                }
                ++S.newc2;
            }
            S.newc2 = -1;
            return false;
        }

        public String toString() {
            return "nextMid";
        }
    }

    class Top2MiddleDeletionChoice
    extends RecursionChoice {
        Top2MiddleDeletionChoice() {
        }

        @Override
        public boolean recursiveSample(RecursionInfo info, RecursionState S) {
            assert (TimeConvectorWordSampler.this.topExists());
            double prob = TimeConvectorWordSampler.this.top2MiddleParam.deletionCost(S.tc1, S.tx, S.tc2);
            if (info.extendPath(prob)) {
                S.newc1 = S.c1;
                S.newc2 = S.c2;
                if (info.recursiveSample()) {
                    TimeConvectorWordSampler.this.outputProb = TimeConvectorWordSampler.this.outputProb * prob;
                    assert (TimeConvectorWordSampler.this.top2MiddleParam.cost(new Edit(TimeConvectorWordSampler.this.enc, S.tc1, S.tx, S.tc2)) > 0.0);
                    TimeConvectorWordSampler.this.top2MiddleEdits.add(new Edit(TimeConvectorWordSampler.this.enc, S.tc1, S.tx, S.tc2));
                    return true;
                }
                S.newc1 = -1;
                S.newc2 = -1;
                info.retractPath(prob);
            }
            return false;
        }

        public String toString() {
            return "top2midDel";
        }
    }

    class Top2MiddleChoice
    extends RecursionChoice {
        Top2MiddleChoice() {
        }

        @Override
        public boolean recursiveSample(RecursionInfo info, RecursionState S) {
            S.tc1 = TimeConvectorWordSampler.this.topc(S.i - 1);
            S.tx = TimeConvectorWordSampler.this.topx(S.i);
            S.tc2 = TimeConvectorWordSampler.this.topc(S.i + 1);
            ++S.i;
            if (TimeConvectorWordSampler.this.topExists()) {
                if (info.recursiveSample(TimeConvectorWordSampler.this.top2MiddleDeletionChoice, TimeConvectorWordSampler.this.restChoice)) {
                    return true;
                }
                if (info.recursiveSample(TimeConvectorWordSampler.this.nextMiddleClassChoice, TimeConvectorWordSampler.this.top2MiddleSubstitutionChoice, TimeConvectorWordSampler.this.restChoice)) {
                    return true;
                }
                if (info.recursiveSample(TimeConvectorWordSampler.this.nextMiddleClassChoice, TimeConvectorWordSampler.this.top2MiddleFissionChoice, TimeConvectorWordSampler.this.restChoice)) {
                    return true;
                }
            } else if (info.recursiveSample(TimeConvectorWordSampler.this.nextMiddleClassChoice, TimeConvectorWordSampler.this.top2MiddleSubstitutionChoice, TimeConvectorWordSampler.this.restChoice)) {
                return true;
            }
            S.tc1 = -1;
            S.tx = -1;
            S.tc2 = -1;
            --S.i;
            return false;
        }

        public String toString() {
            return "top2mid";
        }
    }

    public class RestChoice
    extends RecursionChoice {
        @Override
        public boolean recursiveSample(RecursionInfo info, RecursionState S) {
            double prob = TimeConvectorWordSampler.this.computeSumProb(S.ntop, S.i, S.j, S.k, S.newc1, S.newc2, false);
            if (info.extendPath(prob)) {
                if (info.recursiveSample()) {
                    TimeConvectorWordSampler.this.computeSumProb(S.ntop, S.i, S.j, S.k, S.newc1, S.newc2, true);
                    return true;
                }
                info.retractPath(prob);
            }
            return false;
        }

        public String toString() {
            return "rest";
        }
    }

    public class NullChoice
    extends RecursionChoice {
        @Override
        public boolean recursiveSample(RecursionInfo info, RecursionState S) {
            return info.recursiveSample();
        }

        public String toString() {
            return "null";
        }
    }

    abstract class RecursionChoice {
        RecursionChoice() {
        }

        public abstract boolean recursiveSample(RecursionInfo var1, RecursionState var2);
    }

    class RecursionInfo {
        private double partialProb = 1.0;
        private double accumProb = 0.0;
        private double targetProb = Double.NaN;
        private int numPaths = 0;
        private RecursionChoice[] stack = new RecursionChoice[100];
        private int nstack = 0;
        private RecursionState state;

        public RecursionInfo(RecursionState state) {
            this.state = state;
        }

        public boolean isInSelectMode() {
            return !Double.isNaN(this.targetProb);
        }

        public double getAccumProb() {
            return this.accumProb;
        }

        public boolean endPath() {
            ++this.numPaths;
            if (TimeConvectorWordSampler.this.verboseRecursion) {
                LogInfo.logs("%s.endPath(%d): %f + %f -> %f | target = %f", this, this.numPaths, this.accumProb, this.partialProb, this.accumProb + this.partialProb, this.targetProb);
            }
            this.accumProb = TimeConvectorWordSampler.this.findViterbi ? Math.max(this.accumProb, this.partialProb) : (this.accumProb += this.partialProb);
            if (TimeConvectorWordSampler.this.findViterbi) {
                return this.isInSelectMode() && this.accumProb >= this.targetProb - 1.0E-6;
            }
            return this.isInSelectMode() && this.accumProb >= this.targetProb;
        }

        public boolean extendPath(double prob) {
            if (prob <= 1.0E-100) {
                return false;
            }
            if (TimeConvectorWordSampler.this.verboseRecursion) {
                LogInfo.dbg("extendPath(%f), accumProb = %f, partialProb = %f", prob, this.accumProb, this.partialProb);
            }
            this.partialProb *= prob;
            return true;
        }

        public void retractPath(double prob) {
            this.partialProb /= prob;
            if (TimeConvectorWordSampler.this.verboseRecursion) {
                LogInfo.dbg("retractPath(%f), accumProb = %f, partialProb = %f", prob, this.accumProb, this.partialProb);
            }
        }

        public void push(RecursionChoice choice) {
            this.stack[this.nstack++] = choice;
        }

        public RecursionChoice pop() {
            return this.stack[--this.nstack];
        }

        public boolean recursiveSample() {
            if (this.nstack == 0) {
                return this.endPath();
            }
            if (TimeConvectorWordSampler.this.verboseRecursion) {
                LogInfo.logs("%s.recursiveSample()", this);
            }
            RecursionChoice choice = this.pop();
            boolean result = choice.recursiveSample(this, this.state);
            this.push(choice);
            return result;
        }

        public boolean recursiveSample(RecursionChoice choice) {
            if (TimeConvectorWordSampler.this.verboseRecursion) {
                LogInfo.logs("%s + [%s].recursiveSample()", this, choice);
            }
            return choice.recursiveSample(this, this.state);
        }

        public boolean recursiveSample(RecursionChoice choice1, RecursionChoice choice2) {
            if (TimeConvectorWordSampler.this.verboseRecursion) {
                LogInfo.logs("%s + [%s %s].recursiveSample()", this, choice2, choice1);
            }
            this.push(choice2);
            boolean result = choice1.recursiveSample(this, this.state);
            this.pop();
            return result;
        }

        public boolean recursiveSample(RecursionChoice choice1, RecursionChoice choice2, RecursionChoice choice3) {
            if (TimeConvectorWordSampler.this.verboseRecursion) {
                LogInfo.logs("%s + [%s %s %s].recursiveSample()", this, choice3, choice2, choice1);
            }
            this.push(choice3);
            this.push(choice2);
            boolean result = choice1.recursiveSample(this, this.state);
            this.pop();
            this.pop();
            return result;
        }

        public boolean prepareToSelect() {
            if (this.numPaths == 0) {
                return false;
            }
            if (Double.isNaN(this.accumProb) || this.accumProb < 1.0E-30) {
                return false;
            }
            if (Math.abs(this.partialProb - 1.0) > 1.0E-7) {
                return false;
            }
            this.targetProb = TimeConvectorWordSampler.this.findViterbi ? this.accumProb : TimeConvectorWordSampler.this.random.nextDouble() * this.accumProb;
            this.accumProb = 0.0;
            this.numPaths = 0;
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.nstack; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(this.stack[i]);
            }
            return String.format("%s[%s]", this.isInSelectMode() ? "select" : "compute", sb.toString());
        }
    }

    class RecursionState {
        public int ntop;
        public int c1;
        public int c2;
        public int i;
        public int j;
        public int k;
        public int tc1;
        public int tx;
        public int tc2;
        public int newc1;
        public int newc2;
        public int[] mxs;
        public int nmx;
        public int m;

        public RecursionState(int ntop, int i, int j, int k, int c1, int c2) {
            this.ntop = ntop;
            this.c1 = c1;
            this.c2 = c2;
            this.i = i;
            this.j = j;
            this.k = k;
            this.tc2 = -1;
            this.tx = -1;
            this.tc1 = -1;
            this.newc2 = -1;
            this.newc1 = -1;
            this.mxs = new int[100];
            this.nmx = 0;
            this.m = -1;
        }

        public int prevmidc() {
            return this.m == 0 ? this.c1 : TimeConvectorWordSampler.this.x2c(this.mxs[this.m - 1]);
        }

        public int currmidx() {
            return this.mxs[this.m];
        }

        public int nextmidc() {
            return this.m == this.nmx - 1 ? this.newc2 : TimeConvectorWordSampler.this.x2c(this.mxs[this.m + 1]);
        }

        public void push(int mx) {
            this.mxs[this.nmx++] = mx;
        }

        public void pop() {
            --this.nmx;
        }
    }
}

