/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel.features;

import java.util.List;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.LabeledInstance;
import nuts.util.Counter;
import pepper.Effect;
import pepper.Environment;

public class UnionOfFeaturesExtractor
implements FeatureExtractor<LabeledInstance<Environment, Effect>, String> {
    private final List<FeatureExtractor<LabeledInstance<Environment, Effect>, String>> extractors;

    public UnionOfFeaturesExtractor(List<FeatureExtractor<LabeledInstance<Environment, Effect>, String>> extractors) {
        this.extractors = extractors;
    }

    @Override
    public Counter<String> extractFeatures(LabeledInstance<Environment, Effect> instance) {
        Counter<String> features = new Counter<String>();
        for (FeatureExtractor<LabeledInstance<Environment, Effect>, String> extractor : this.extractors) {
            features.incrementAll(extractor.extractFeatures(instance));
        }
        return features;
    }

    @Override
    public double regularizationFactor(String feature) {
        double result = 1.0;
        for (FeatureExtractor<LabeledInstance<Environment, Effect>, String> extractor : this.extractors) {
            result *= extractor.regularizationFactor(feature);
        }
        return result;
    }
}

