/*
 * Decompiled with CFR 0.152.
 */
package sage;

import fig.basic.IOUtils;
import goblin.CognateId;
import goblin.DerivationTree;
import goblin.HLParams;
import goblin.LineageSampler;
import goblin.Taxon;
import java.io.ObjectOutputStream;
import java.util.Random;
import ma.AffineGapAlignmentSampler;
import nuts.math.MeasureZeroException;
import nuts.math.Sampling;
import nuts.util.Arbre;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import sage.LikelihoodModel;

public class GlobalAlignmentSampler
implements Sampling.Proposal<Arbre<DerivationTree.DerivationNode>> {
    private final double nRejectAnneal;
    private final boolean rejAnneal;
    private final HLParams proposal;
    private final LikelihoodModel model;
    private final Arbre<DerivationTree.LineagedNode> initial;
    private Arbre<DerivationTree.LineagedNode> cSample;
    private final Taxon botLang;
    private final AffineGapAlignmentSampler affineGapAlignSampler;
    private final Random rand;
    private final DerivationTree.Derivation initialDerivation;
    private final DerivationTree.Window topWindow;
    private final DerivationTree.Window botWindow;
    private final CognateId id;
    private double _initialLogRatio = Double.NaN;

    public boolean usePairedModel() {
        return this.model != null && this.proposal != this.model;
    }

    private GlobalAlignmentSampler(Taxon botLang, Arbre<DerivationTree.LineagedNode> initial, LikelihoodModel model, HLParams proposal, Random rand, boolean rejAnneal, int nRejectAnneal, CognateId id) {
        this.rejAnneal = rejAnneal;
        this.nRejectAnneal = nRejectAnneal;
        this.botLang = botLang;
        this.initial = initial.root();
        this.model = model;
        this.proposal = proposal;
        this.rand = rand;
        this.id = id;
        Arbre<DerivationTree.LineagedNode> node = DerivationTree.findLineagedNodeByLangName(initial, botLang);
        this.initialDerivation = node.getContents().getDerivationNode().getDerivation();
        this.botWindow = node.getContents().getWindow();
        this.topWindow = node.getParent().getContents().getWindow();
        this.affineGapAlignSampler = AffineGapAlignmentSampler.createHLAlignmentSampler(this.topWindow, this.botWindow, this.initialDerivation, proposal.getBranchParams().get(botLang));
    }

    private double initialLogRatio() {
        if (this.rejAnneal || !this.usePairedModel()) {
            return Double.NaN;
        }
        if (!Double.isNaN(this._initialLogRatio)) {
            return this._initialLogRatio;
        }
        this._initialLogRatio = this.proposal.partialLogLikelihood(this.initial, this.id) - this.model.partialLogLikelihood(this.initial, this.id);
        return this._initialLogRatio;
    }

    @Override
    public double mhRatio() {
        if (this.rejAnneal || !this.usePairedModel()) {
            return 1.0;
        }
        double logRatio = this.initialLogRatio() + this.model.partialLogLikelihood(this.cSample, this.id) - this.proposal.partialLogLikelihood(this.cSample, this.id);
        return Math.min(1.0, Math.exp(logRatio));
    }

    private Arbre<DerivationTree.LineagedNode> _sample() throws MeasureZeroException {
        this.cSample = this.initial.copy();
        Arbre<DerivationTree.LineagedNode> node = DerivationTree.findLineagedNodeByLangName(this.cSample, this.botLang);
        DerivationTree.Derivation newPartialDerivation = this.affineGapAlignSampler.sample(this.rand);
        DerivationTree.Derivation newFullDerivation = LineageSampler.LongGapAlignmentSamplerAdaptor.replaceDerivation(this.initialDerivation, this.topWindow, this.botWindow, newPartialDerivation);
        node.setContents(new DerivationTree.LineagedNode(new DerivationTree.DerivationNode(this.botLang, node.getContents().getDerivationNode().getWord(), newFullDerivation), this.botWindow));
        return this.cSample;
    }

    @Override
    public Arbre<DerivationTree.DerivationNode> proposed() {
        try {
            return DerivationTree.derivation(this.rejAnneal ? this.rejectAnneal() : this._sample());
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ObjectOutputStream oos = IOUtils.openBinOut("core-" + System.currentTimeMillis());
                oos.writeObject(this.affineGapAlignSampler);
                oos.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            try {
                return this.proposal.resampleAlignments(DerivationTree.derivation(this.cSample), this.rand);
            }
            catch (MeasureZeroException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private Arbre<DerivationTree.LineagedNode> rejectAnneal() throws MeasureZeroException {
        LikelihoodModel llm = this.usePairedModel() ? this.model : this.proposal;
        double max = Double.NEGATIVE_INFINITY;
        Arbre<DerivationTree.LineagedNode> argmax = null;
        int i = 0;
        while ((double)i < this.nRejectAnneal) {
            Arbre<DerivationTree.LineagedNode> current = this._sample();
            double curScore = llm.partialLogLikelihood(current, this.id);
            if (curScore > max) {
                max = curScore;
                argmax = current;
            }
            ++i;
        }
        return argmax;
    }

    public static Arbre<DerivationTree.DerivationNode> next(Arbre<DerivationTree.DerivationNode> initial, LikelihoodModel model, HLParams proposal, Random rand, boolean anneal, int nRounds, SummaryStatistics acceptStats, CognateId id) {
        Arbre<DerivationTree.DerivationNode> result = initial;
        for (Arbre<DerivationTree.DerivationNode> subt : initial.nodes()) {
            if (subt.isRoot()) continue;
            result = GlobalAlignmentSampler.next(result, subt.getContents().getLanguage(), model, proposal, rand, anneal, nRounds, acceptStats, id);
        }
        return result;
    }

    public static Arbre<DerivationTree.DerivationNode> next(Arbre<DerivationTree.DerivationNode> initial, Taxon lang, LikelihoodModel model, HLParams proposal, Random rand, boolean isAnneal, int nRounds, SummaryStatistics acceptStats, CognateId id) {
        Arbre<DerivationTree.DerivationNode> subt;
        Arbre<DerivationTree.DerivationNode> result = initial.copy();
        if (result.root().getChildren().get(0).getContents().getDerivation() == null) {
            try {
                result = proposal.resampleAlignments(result, rand);
            }
            catch (MeasureZeroException e) {
                throw new RuntimeException(e);
            }
        }
        if ((subt = DerivationTree.findNodeByLangName(initial.root(), lang)).isRoot()) {
            throw new RuntimeException();
        }
        Arbre<DerivationTree.LineagedNode> fullLineage = DerivationTree.fullLineage(result);
        Arbre<DerivationTree.LineagedNode> temp = DerivationTree.findLineagedNodeByLangName(fullLineage, lang);
        DerivationTree.LineagedNode node = temp.getContents();
        DerivationTree.LineagedNode parent = temp.getParent().getContents();
        DerivationTree.DerivationNode newParent = new DerivationTree.DerivationNode(parent.getDerivationNode().getLanguage(), parent.getDerivationNode().getWord());
        DerivationTree.Window topWin = parent.getWindow();
        DerivationTree.LineagedNode newParentLin = new DerivationTree.LineagedNode(newParent, topWin);
        Arbre<DerivationTree.LineagedNode> subTree = Arbre.arbre(node, Arbre.arbre(newParentLin)).root();
        Arbre<DerivationTree.DerivationNode> newSample = GlobalAlignmentSampler.next(lang, subTree, model, proposal, rand, isAnneal, nRounds, acceptStats, id);
        DerivationTree.findNodeByLangName(result, lang).setContents(newSample.root().getChildren().get(0).getContents());
        return result;
    }

    private static Arbre<DerivationTree.DerivationNode> next(Taxon botLang, Arbre<DerivationTree.LineagedNode> initial, LikelihoodModel model, HLParams proposal, Random rand, boolean rejAnneal, int nRounds, SummaryStatistics acceptStats, CognateId id) {
        GlobalAlignmentSampler gas = new GlobalAlignmentSampler(botLang, initial, model, proposal, rand, rejAnneal, nRounds, id);
        if (rejAnneal) {
            return gas.proposed();
        }
        return Sampling.metropolisHastingsStep(rand, gas, acceptStats);
    }

    @Override
    public Arbre<DerivationTree.DerivationNode> initial() {
        return DerivationTree.derivation(this.initial);
    }
}

