/*
 * Decompiled with CFR 0.152.
 */
package sand;

import fig.prob.SampleUtils;
import java.util.Random;
import sand.TransitionKernel;

public class Kernels {
    public static TransitionKernel initialDistribution(double[] prs) {
        return new DeltaKernel(prs, true);
    }

    public static TransitionKernel emissionLikelihood(double[] likelihoodsFromParentState) {
        return new DeltaKernel(likelihoodsFromParentState, false);
    }

    public static TransitionKernel initialDistKernel(TransitionKernel kernel) {
        int nStates = kernel.nNextStates();
        double[] prs = new double[nStates];
        for (int s = 0; s < nStates; ++s) {
            prs[s] = kernel.pr(0, s);
        }
        return Kernels.initialDistribution(prs);
    }

    public static TransitionKernel emissionLikelihood(TransitionKernel kernel, int observedState) {
        double[] prs = new double[kernel.nCurrentStates()];
        for (int s = 0; s < prs.length; ++s) {
            prs[s] = kernel.pr(s, observedState);
        }
        return Kernels.emissionLikelihood(prs);
    }

    public static class DeltaKernel
    implements TransitionKernel {
        private final double[] prs;
        private final boolean deltaOnSource;

        public DeltaKernel(double[] prs, boolean deltaOnSource) {
            this.deltaOnSource = deltaOnSource;
            this.prs = prs;
        }

        @Override
        public int nCurrentStates() {
            if (this.deltaOnSource) {
                return 1;
            }
            return this.prs.length;
        }

        @Override
        public int nNextStates() {
            if (!this.deltaOnSource) {
                return 1;
            }
            return this.prs.length;
        }

        @Override
        public double pr(int currentState, int nextState) {
            if (this.deltaOnSource) {
                if (currentState != 0) {
                    throw new RuntimeException();
                }
                return this.prs[nextState];
            }
            if (nextState != 0) {
                throw new RuntimeException();
            }
            return this.prs[currentState];
        }

        @Override
        public int sample(int currentState, Random rand) {
            if (!this.deltaOnSource) {
                return 0;
            }
            if (currentState != 0) {
                throw new RuntimeException();
            }
            return SampleUtils.sampleMultinomial(rand, this.prs);
        }
    }
}

