/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.util.HashSet;
import java.util.Random;
import nuts.util.Counter;

public class CoverTime {
    private int cycleSize = 20;
    private int state = 0;
    private int t = 0;
    private static Random rand = new Random();

    public void transition() {
        ++this.t;
        int decision = rand.nextInt(2);
        this.state = this.state + decision * 2 - 1;
        if (this.state < 0) {
            this.state += this.cycleSize;
        }
        this.state %= this.cycleSize;
    }

    public void cover() {
        HashSet<Integer> visited = new HashSet<Integer>();
        visited.add(0);
        while (visited.size() < this.cycleSize) {
            this.transition();
            visited.add(this.state);
        }
    }

    public static void main(String[] args) {
        Counter<Integer> counter = new Counter<Integer>();
        double maxIters = 100000.0;
        double sum = 0.0;
        int i = 0;
        while ((double)i < maxIters) {
            CoverTime ct = new CoverTime();
            ct.cover();
            counter.incrementCount(ct.state, 1.0);
            sum += (double)ct.t;
            ++i;
        }
        counter.normalize();
        System.out.println("Distrib of last state: " + counter.toString());
        System.out.println("Mean cover time: " + sum / maxIters);
    }
}

