/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.basic.Pair;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JApplet;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.Counter;
import nuts.util.MathUtils;

public class DrawIPADiagram
extends JApplet
implements Printable {
    private String universalWeightsFile = "doc/results/dataAnalysis2/universals";
    private String langSpecWeightsFile = "doc/results/dataAnalysis2/languageSpecific";
    private String lang = null;
    private String consFile = "doc/ipaChart.csv";
    private String vowFile = "doc/ipaChart-vow.csv";
    public static String[] ipaFiles = new String[]{"encodings/converted-cons.ipa", "encodings/converted-vow.ipa"};
    public static final boolean isRandom = false;
    private static final double gridWidth = 10.0;
    private static final double gridHeight = 25.0;
    private static final double miniGridWidth = 10.0;
    private static final double off = 12.5;
    private static final double vowFact = 5.0;
    private final double exp = 1.0;
    private final boolean showVowels = true;
    public static boolean useGray = true;
    public static double threshold = 10.0;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    private Counter<Pair<Character, Character>> nns = null;
    private Map<Character, Pair<Double, Double>> coordinates = new HashMap<Character, Pair<Double, Double>>();
    private Set<Character> valids = null;
    private double max = Double.NEGATIVE_INFINITY;
    public static final Random rand = new Random(1L);

    @Override
    public void init() {
        throw new RuntimeException("Use DrawIPADiagram2 instead!");
    }

    private Set<Character> getValids() {
        if (this.valids != null) {
            return this.valids;
        }
        this.valids = new HashSet<Character>();
        for (String ipaFile : ipaFiles) {
            for (String line : IO.i(ipaFile)) {
                if (!line.matches(".\\t.*")) continue;
                this.valids.add(Character.valueOf(StringUtils.selectFirstRegex("^(.)\\t.*", line).charAt(0)));
            }
        }
        return this.valids;
    }

    private Counter<Pair<Character, Character>> getNN(String weiFile) {
        Counter<Pair<Character, Character>> result = new Counter<Pair<Character, Character>>();
        Pattern p = Pattern.compile("\\t?(.) -> (.)\\t(.*)");
        String cLang = null;
        for (String line : IO.i(weiFile)) {
            char c2;
            if (this.lang != null) {
                if (line.matches("^\\S+\\t.*")) {
                    cLang = StringUtils.selectFirstRegex("^(\\S+)\\t.*", line);
                    continue;
                }
                if (cLang == null || !cLang.equals(this.lang)) continue;
            }
            if (!line.matches("\\t?. -> .\\t\\d.*")) continue;
            List<String> fields = StringUtils.multiSelectFirstRegex(p, line);
            Double w = Double.parseDouble(fields.get(2));
            char c1 = fields.get(0).charAt(0);
            if (c1 == (c2 = fields.get(1).charAt(0))) continue;
            Pair<Character, Character> key1 = Pair.makePair(Character.valueOf(c1), Character.valueOf(c2));
            Pair<Character, Character> key2 = Pair.makePair(Character.valueOf(c2), Character.valueOf(c1));
            result.incrementCount(key1, w);
            result.incrementCount(key2, w);
            this.max = Math.max(result.getCount(key1), this.max);
        }
        return result;
    }

    private void drawLine(Graphics2D g2, Pair<Double, Double> pair, Pair<Double, Double> pair2) {
        if (MathUtils.close(pair.getSecond(), pair2.getSecond())) {
            Pair<Double, Double> left = pair2;
            Pair<Double, Double> right = pair;
            if (pair.getFirst() < pair2.getFirst()) {
                left = pair;
                right = pair2;
            }
            g2.draw(new Arc2D.Double(left.getFirst() + 3.0, left.getSecond() - 6.25 + 1.0, right.getFirst() - left.getFirst(), 12.5, 180.0, 182.0, 0));
        } else {
            Pair<Double, Double> top = pair2;
            Pair<Double, Double> bot = pair;
            if (pair.getSecond() < pair2.getSecond()) {
                top = pair;
                bot = pair2;
            }
            int incr = 11;
            if (MathUtils.close(top.getSecond(), bot.getSecond())) {
                incr = 0;
            }
            g2.draw(new Line2D.Double(top.getFirst() + 3.0, top.getSecond() + 1.0, bot.getFirst() + 3.0, bot.getSecond() - (double)incr));
        }
    }

    private void computeCoordinates(String file, boolean isCons, int baseX, int baseY) {
        double cX = baseX;
        double cY = baseY;
        int row = 0;
        for (String line : IO.i(file)) {
            double cGridWidth = isCons ? 10.0 : (5.0 - (double)row) * 10.0;
            cX = isCons ? (double)baseX : (double)baseX + 2.0 * (50.0 - (5.0 - (double)row) * 10.0);
            int i = 0;
            for (String field : line.split("[,]")) {
                for (Character c : this.subFields(field, isCons)) {
                    if (c != null && !this.coordinates.containsKey(c) && this.getValids().contains(c)) {
                        this.coordinates.put(c, Pair.makePair(cX, cY));
                    }
                    cX += 10.0;
                }
                cX += isCons ? cGridWidth : (i % 2 == 0 ? 0.0 : cGridWidth);
                ++i;
            }
            cY += 25.0;
            ++row;
        }
    }

    private List<Character> subFields(String field, boolean isCons) {
        if (isCons) {
            ArrayList<Character> result = new ArrayList<Character>();
            if (field.matches("\\s*")) {
                result.add(null);
                result.add(null);
                return result;
            }
            if (field.charAt(0) == '\t' || field.charAt(0) == ' ') {
                result.add(null);
            } else {
                result.add(Character.valueOf(field.charAt(0)));
            }
            if (field.length() == 1) {
                result.add(null);
                return result;
            }
            result.add(Character.valueOf(StringUtils.selectFirstRegex(".\\s*(\\S)", field).charAt(0)));
            return result;
        }
        if (field.length() == 0) {
            return Collections.singletonList(null);
        }
        if (field.length() == 1) {
            return Collections.singletonList(Character.valueOf(field.charAt(0)));
        }
        throw new RuntimeException();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(new Font("Times New Roman", 0, 12));
        Iterator<Serializable> iterator = this.coordinates.keySet().iterator();
        while (iterator.hasNext()) {
            char c = iterator.next().charValue();
            g2.drawString("" + c, this.coordinates.get(Character.valueOf(c)).getFirst().intValue(), this.coordinates.get(Character.valueOf(c)).getSecond().intValue());
        }
        g2.setPaint(new Color(0.0f, 0.0f, 0.0f, 0.3f));
        for (Pair pair : this.nns) {
            if (!(this.nns.getCount(pair) > threshold) || !this.coordinates.containsKey(pair.getFirst()) || !this.coordinates.containsKey(pair.getSecond())) continue;
            float alpha = (float)(this.nns.getCount(pair) / this.max);
            if (useGray) {
                g2.setPaint(new Color(0.0f, 0.0f, 0.0f, (float)Math.pow(alpha, 1.0)));
            }
            this.drawLine(g2, this.coordinates.get(pair.getFirst()), this.coordinates.get(pair.getSecond()));
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pagefmt, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        this.paint(graphics);
        return 0;
    }
}

