/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import fig.basic.NumUtils;
import fig.prob.SampleUtils;
import java.util.Arrays;
import java.util.Random;
import nuts.math.MtxUtils;
import nuts.math.RateMtxUtils;
import nuts.tui.Table;
import pty.learn.CTMCExpectations;

public class UniformCTMCExp {
    public static void main(String[] args) {
        double[][] Q = new double[][]{{0.0, 0.1, 1.0}, {1.0, 0.0, 1.0}, {0.0, 0.0, 0.0}};
        RateMtxUtils.fillRateMatrixDiagonalEntries(Q);
        EigenvalueDecomposition ed = new EigenvalueDecomposition(new Matrix((double[][])Q));
        System.out.println("D:\n" + Table.toString(ed.getD()));
        System.out.println("Rate:\n" + Table.toString(Q));
        double[] initD = new double[]{0.5, 0.3, 0.2};
        Matrix pi = new Matrix(initD, 1);
        System.out.println(Table.toString(pi));
        int size = Q.length;
        Matrix exponentiatedMtx = MtxUtils.zeroes(size);
        double L = 1.0;
        Matrix D2 = ed.getD();
        for (int i = 0; i < size; ++i) {
            double d = D2.get(i, i);
            if (Math.abs(d) > 1.0E-6) {
                exponentiatedMtx.set(i, i, (Math.exp(1.0 * d) - 1.0) / d);
                continue;
            }
            exponentiatedMtx.set(i, i, 1.0);
        }
        Matrix U = ed.getV();
        System.out.println("Rough:\n" + Table.toString(pi.times(new Matrix(RateMtxUtils.marginalTransitionMtx(Q, 1.0)))));
        Matrix result = pi.times(U.times(exponentiatedMtx.times(U.inverse()))).times(1.0);
        System.out.println("Analytic:\n" + Table.toString(result));
        double[][] marginal = RateMtxUtils.marginalTransitionMtx(Q, 1.0);
        System.out.println("Marginal:\n" + Table.toString(marginal));
        double[] avg = new double[Q.length];
        double N2 = 1000000.0;
        Random rand = new Random(1L);
        int i = 0;
        while ((double)i < 1000000.0) {
            int initS = SampleUtils.sampleMultinomial(rand, initD);
            double t = rand.nextDouble();
            int n = CTMCExpectations.stateAtT(CTMCExpectations.simulate(initS, t, rand, Q), t);
            avg[n] = avg[n] + 1.0;
            ++i;
        }
        NumUtils.normalize(avg);
        System.out.println("MC stat. dist.: " + Arrays.toString(avg));
    }
}

