/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nuts.util.CollUtils;
import smc.Model;
import smc.RandomGenerator;

public class SMC<S>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int T;
    private final int N;
    private final Model<S> model;
    private final RandomGenerator random;
    private Particle[][] particles;

    public SMC(int T, int N2, Model<S> model) {
        this.T = T;
        this.N = N2;
        this.model = model;
        this.random = new RandomGenerator(T);
        this.particles = new Particle[N2][T];
    }

    public static <S> SMC<S> runSMC(int T, int N2, Model<S> model) {
        LogInfo.logs("Run SMC algorithm");
        SMC<S> smc = new SMC<S>(T, N2, model);
        super.generateParticles();
        return smc;
    }

    private void generateParticles() {
        LogInfo.logs("Generating particles...");
        double norm = 0.0;
        ArrayList xprev = new ArrayList();
        for (int n = 0; n < this.N; ++n) {
            Particle<S> p;
            S sample = this.model.generateSample(this.random.getSeed(0, n), 0, xprev);
            double weight = this.model.evaluateWeight(0, xprev, sample);
            norm += weight;
            this.particles[n][0] = p = new Particle<S>(n, 0, weight, sample, null);
        }
        for (int t = 1; t < this.T; ++t) {
            int n;
            double[] weights = new double[this.N];
            for (n = 0; n < this.N; ++n) {
                this.particles[n][t - 1].normalize(norm);
                weights[n] = this.particles[n][t - 1].getNormalizedWeight();
            }
            norm = 0.0;
            for (n = 0; n < this.N; ++n) {
                Particle<S> p;
                int sampledParent = RandomGenerator.discreteMultinomial(this.random.getSeed(t, n), weights, 1.0);
                xprev = new ArrayList();
                Particle ancestor = this.particles[sampledParent][t - 1];
                xprev.add(0, ancestor.sample);
                while (ancestor.parent != null) {
                    ancestor = ancestor.parent;
                    xprev.add(0, ancestor.sample);
                }
                S sample = this.model.generateSample(this.random.getSeed(t, n), t, xprev);
                double weight = weights[sampledParent] * this.model.evaluateWeight(t, xprev, sample);
                norm += weight;
                this.particles[n][t] = p = new Particle<S>(n, t, weight, sample, this.particles[sampledParent][t - 1]);
            }
        }
    }

    public Particle<S> getParticle(int t, int n) {
        return this.particles[n][t];
    }

    public static class Particle<S>
    implements Comparable<Particle<S>> {
        public int id;
        public int time;
        public int machineId;
        public Particle<S> parent = null;
        public List<Particle<S>> children = CollUtils.list();
        public Long seed = null;
        public double weight;
        public double norm;
        public S sample = null;
        private HashMap<Integer, Integer> machineMap;
        public static final int NO_PARENT = -1;

        public Particle(int id, int time, int machineId, double weight, S sample, Particle<S> parent) {
            this.id = id;
            this.time = time;
            this.machineId = machineId;
            this.sample = sample;
            this.weight = weight;
            this.parent = parent;
            this.machineMap = new HashMap();
        }

        public Particle(int id, int time, int machineId, Particle<S> parent, long seed) {
            this.id = id;
            this.time = time;
            this.machineId = machineId;
            this.parent = parent;
            this.seed = new Long(seed);
            this.machineMap = new HashMap();
        }

        public Particle(int id, int time, double weight, S sample, Particle<S> parent) {
            this.id = id;
            this.time = time;
            this.weight = weight;
            this.sample = sample;
            this.parent = parent;
        }

        public int getId() {
            return this.id;
        }

        public void addChild(Particle<S> child) {
            this.children.add(child);
        }

        public void normalize(double norm) {
            this.norm = norm;
        }

        public void setRawWeight(double weight) {
            this.weight = weight;
        }

        public double getRawWeight() {
            return this.weight;
        }

        public double getNormalizedWeight() {
            if (this.norm > 0.0) {
                return this.weight / this.norm;
            }
            throw new RuntimeException("Bad normalization factor");
        }

        public HashMap<Integer, Integer> getMachineMap() {
            return this.machineMap;
        }

        public boolean isDead() {
            return this.machineMap.isEmpty();
        }

        public void addMachine(int machineId) {
            int value = 0;
            if (this.machineMap.containsKey(machineId)) {
                value = this.machineMap.get(machineId);
            }
            this.machineMap.put(machineId, ++value);
        }

        public boolean containsMachine(int machineId) {
            return this.machineMap.containsKey(machineId);
        }

        @Override
        public int compareTo(Particle<S> o) {
            if (this.time < o.time) {
                return -1;
            }
            if (o.time == this.time) {
                if (this.id == o.id) {
                    return 0;
                }
                if (this.id < o.id) {
                    return -1;
                }
                return 1;
            }
            return 1;
        }

        public boolean equals(Particle<S> o) {
            if (this == o) {
                return true;
            }
            return o.time == this.time && o.id == this.id;
        }
    }
}

