/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.protein.DomainId;

public class pfam2go_extractor {
    private static final String PRG_NAME = "pfam2go_extractor";

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            pfam2go_extractor.printHelp();
        }
        PfamToGoParser pfamToGoParser = new PfamToGoParser(new File(stringArray[0]));
        List<PfamToGoMapping> list = null;
        try {
            list = pfamToGoParser.parse();
        }
        catch (IOException iOException) {
            pfam2go_extractor.printHelp();
            iOException.printStackTrace();
        }
        OBOparser oBOparser = new OBOparser(new File(stringArray[1]), OBOparser.ReturnType.BASIC_GO_TERM);
        List<GoTerm> list2 = null;
        try {
            list2 = oBOparser.parse();
        }
        catch (IOException iOException) {
            pfam2go_extractor.printHelp();
            iOException.printStackTrace();
        }
        Map<GoId, GoTerm> map = GoUtils.createGoIdToGoTermMap(list2);
        System.out.println("# pfam2go : " + stringArray[0]);
        System.out.println("# OBO file: " + stringArray[1]);
        GoId[] goIdArray = new GoId[stringArray.length - 2];
        for (int i = 2; i < stringArray.length; ++i) {
            goIdArray[i - 2] = new GoId(stringArray[i]);
            System.out.println("# " + (i - 2) + ": " + goIdArray[i - 2].getId() + " = " + map.get(goIdArray[i - 2]).getName() + " (" + map.get(goIdArray[i - 2]).getDefinition() + ")");
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (PfamToGoMapping object : list) {
            DomainId domainId = object.getKey();
            GoId goId = object.getValue();
            SortedSet<GoId> sortedSet = GoUtils.getAllSuperGoIds(goId, map);
            sortedSet.add(goId);
            for (int i = 0; i < goIdArray.length; ++i) {
                if (!sortedSet.contains(goIdArray[i])) continue;
                treeSet.add(domainId.toString());
            }
        }
        for (String string : treeSet) {
            System.out.println(string);
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("pfam2go_extractor <pfam2go mapping file> <file with all GO terms, in 'obo' format> <GO id> [more GO ids]");
        System.out.println();
    }
}

