/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Font;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Constants;
import org.forester.phylogeny.PhylogenyNodeI;
import org.forester.phylogeny.data.NodeVisualization;
import org.forester.util.ForesterUtil;

public final class Options {
    static final double MIN_CONFIDENCE_DEFAULT = 0.0;
    private boolean _show_branch_length_values;
    private boolean _internal_number_are_confidence_for_nh_parsing;
    private boolean _show_scale;
    private boolean _show_overview;
    private boolean _antialias_screen;
    private boolean _antialias_print;
    private boolean _graphics_export_visible_only;
    private int _print_size_x;
    private int _print_size_y;
    private double _min_confidence_value;
    private boolean _print_black_and_white;
    private boolean _print_using_actual_size;
    private boolean _graphics_export_using_actual_size;
    private PHYLOGENY_GRAPHICS_TYPE _phylogeny_graphics_type;
    private CLADOGRAM_TYPE _cladogram_type;
    private OVERVIEW_PLACEMENT_TYPE _ov_placement;
    private NODE_LABEL_DIRECTION _node_label_direction;
    private Font _base_font;
    private boolean _match_whole_terms_only;
    private boolean _search_case_sensitive;
    private float _print_line_width;
    private boolean _inverse_search_result;
    private double _scale_bar_length;
    private short _number_of_digits_after_comma_for_confidence_values;
    private short _number_of_digits_after_comma_for_branch_length_values;
    private boolean _nh_parsing_replace_underscores;
    private boolean _nh_parsing_extract_pfam_taxonomy_codes;
    private boolean _editable;
    private boolean _background_color_gradient;
    private boolean _show_domain_labels;
    private boolean _color_labels_same_as_parent_branch;
    private boolean _abbreviate_scientific_names;
    private NodeVisualization.NodeShape _default_node_shape;
    private NodeVisualization.NodeFill _default_node_fill;
    private short _default_node_shape_size;
    private boolean _taxonomy_colorize_node_shapes;
    private boolean _show_default_node_shapes;
    private boolean _show_confidence_stddev;
    private PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE _nh_conversion_support_value_style;

    private Options() {
        this.init();
    }

    final Font getBaseFont() {
        return this._base_font;
    }

    final CLADOGRAM_TYPE getCladogramType() {
        return this._cladogram_type;
    }

    final NodeVisualization.NodeFill getDefaultNodeFill() {
        return this._default_node_fill;
    }

    final NodeVisualization.NodeShape getDefaultNodeShape() {
        return this._default_node_shape;
    }

    final short getDefaultNodeShapeSize() {
        return this._default_node_shape_size;
    }

    final double getMinConfidenceValue() {
        return this._min_confidence_value;
    }

    final NODE_LABEL_DIRECTION getNodeLabelDirection() {
        return this._node_label_direction;
    }

    final short getNumberOfDigitsAfterCommaForBranchLengthValues() {
        return this._number_of_digits_after_comma_for_branch_length_values;
    }

    final short getNumberOfDigitsAfterCommaForConfidenceValues() {
        return this._number_of_digits_after_comma_for_confidence_values;
    }

    final OVERVIEW_PLACEMENT_TYPE getOvPlacement() {
        return this._ov_placement;
    }

    final PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._phylogeny_graphics_type;
    }

    final float getPrintLineWidth() {
        return this._print_line_width;
    }

    final int getPrintSizeX() {
        return this._print_size_x;
    }

    final int getPrintSizeY() {
        return this._print_size_y;
    }

    final double getScaleBarLength() {
        return this._scale_bar_length;
    }

    private final void init() {
        this._default_node_shape = NodeVisualization.NodeShape.CIRCLE;
        this._default_node_fill = NodeVisualization.NodeFill.GRADIENT;
        this._default_node_shape_size = (short)6;
        this._taxonomy_colorize_node_shapes = false;
        this._show_branch_length_values = false;
        this._internal_number_are_confidence_for_nh_parsing = false;
        this._show_scale = false;
        this._antialias_screen = true;
        this._antialias_print = true;
        this._graphics_export_visible_only = false;
        this._editable = true;
        this._background_color_gradient = false;
        this._show_default_node_shapes = false;
        if (AptxUtil.isUsOrCanada()) {
            this._print_size_x = 612;
            this._print_size_y = 792;
        } else {
            this._print_size_x = 595;
            this._print_size_y = 845;
        }
        this._min_confidence_value = 0.0;
        this._print_black_and_white = false;
        this._print_using_actual_size = false;
        this._graphics_export_using_actual_size = true;
        this._phylogeny_graphics_type = PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
        this._base_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 10);
        this._match_whole_terms_only = false;
        this._search_case_sensitive = false;
        this._print_line_width = 0.5f;
        this._show_overview = true;
        this._ov_placement = OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT;
        this._node_label_direction = NODE_LABEL_DIRECTION.HORIZONTAL;
        this._inverse_search_result = false;
        this._scale_bar_length = 0.0;
        this._number_of_digits_after_comma_for_branch_length_values = (short)2;
        this._number_of_digits_after_comma_for_confidence_values = 1;
        this._nh_parsing_replace_underscores = false;
        this._nh_parsing_extract_pfam_taxonomy_codes = false;
        this._cladogram_type = Constants.CLADOGRAM_TYPE_DEFAULT;
        this._show_domain_labels = true;
        this.setAbbreviateScientificTaxonNames(false);
        this._color_labels_same_as_parent_branch = false;
        this._show_confidence_stddev = true;
        this._nh_conversion_support_value_style = PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE;
    }

    boolean isShowConfidenceStddev() {
        return this._show_confidence_stddev;
    }

    void setShowConfidenceStddev(boolean bl) {
        this._show_confidence_stddev = bl;
    }

    PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE getNhConversionSupportValueStyle() {
        return this._nh_conversion_support_value_style;
    }

    void setNhConversionSupportValueStyle(PhylogenyNodeI.NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE) {
        this._nh_conversion_support_value_style = nH_CONVERSION_SUPPORT_VALUE_STYLE;
    }

    final boolean isAbbreviateScientificTaxonNames() {
        return this._abbreviate_scientific_names;
    }

    boolean isAllowMagnificationOfTaxonomyImages() {
        return true;
    }

    final boolean isAntialiasPrint() {
        return this._antialias_print;
    }

    final boolean isAntialiasScreen() {
        return this._antialias_screen;
    }

    final boolean isBackgroundColorGradient() {
        return this._background_color_gradient;
    }

    final boolean isColorLabelsSameAsParentBranch() {
        return this._color_labels_same_as_parent_branch;
    }

    final boolean isEditable() {
        return this._editable;
    }

    final boolean isExtractPfamTaxonomyCodesInNhParsing() {
        return this._nh_parsing_extract_pfam_taxonomy_codes;
    }

    final boolean isGraphicsExportUsingActualSize() {
        return this._graphics_export_using_actual_size;
    }

    final boolean isGraphicsExportVisibleOnly() {
        return this._graphics_export_visible_only;
    }

    final boolean isInternalNumberAreConfidenceForNhParsing() {
        return this._internal_number_are_confidence_for_nh_parsing;
    }

    final boolean isInverseSearchResult() {
        return this._inverse_search_result;
    }

    final boolean isMatchWholeTermsOnly() {
        return this._match_whole_terms_only;
    }

    final boolean isPrintBlackAndWhite() {
        return this._print_black_and_white;
    }

    final boolean isPrintUsingActualSize() {
        return this._print_using_actual_size;
    }

    final boolean isReplaceUnderscoresInNhParsing() {
        return this._nh_parsing_replace_underscores;
    }

    final boolean isSearchCaseSensitive() {
        return this._search_case_sensitive;
    }

    final boolean isShowBranchLengthValues() {
        return this._show_branch_length_values;
    }

    public final boolean isShowDomainLabels() {
        return this._show_domain_labels;
    }

    final boolean isShowOverview() {
        return this._show_overview;
    }

    final boolean isShowScale() {
        return this._show_scale;
    }

    boolean isTaxonomyColorizeNodeShapes() {
        return this._taxonomy_colorize_node_shapes;
    }

    final void setAbbreviateScientificTaxonNames(boolean bl) {
        this._abbreviate_scientific_names = bl;
    }

    final void setAntialiasPrint(boolean bl) {
        this._antialias_print = bl;
    }

    final void setAntialiasScreen(boolean bl) {
        this._antialias_screen = bl;
    }

    public void setBackgroundColorGradient(boolean bl) {
        this._background_color_gradient = bl;
    }

    final void setBaseFont(Font font) {
        this._base_font = font;
    }

    final void setCladogramType(CLADOGRAM_TYPE cLADOGRAM_TYPE) {
        this._cladogram_type = cLADOGRAM_TYPE;
    }

    public void setColorLabelsSameAsParentBranch(boolean bl) {
        this._color_labels_same_as_parent_branch = bl;
    }

    final void setDefaultNodeFill(NodeVisualization.NodeFill nodeFill) {
        this._default_node_fill = nodeFill;
    }

    final void setDefaultNodeShape(NodeVisualization.NodeShape nodeShape) {
        this._default_node_shape = nodeShape;
    }

    final void setDefaultNodeShapeSize(short s) {
        this._default_node_shape_size = s;
    }

    final void setEditable(boolean bl) {
        this._editable = bl;
    }

    final void setExtractPfamTaxonomyCodesInNhParsing(boolean bl) {
        this._nh_parsing_extract_pfam_taxonomy_codes = bl;
    }

    final void setGraphicsExportUsingActualSize(boolean bl) {
        this._graphics_export_using_actual_size = bl;
        if (!bl) {
            this.setGraphicsExportVisibleOnly(false);
        }
    }

    final void setGraphicsExportVisibleOnly(boolean bl) {
        this._graphics_export_visible_only = bl;
        if (bl) {
            this.setGraphicsExportUsingActualSize(true);
        }
    }

    final void setInternalNumberAreConfidenceForNhParsing(boolean bl) {
        this._internal_number_are_confidence_for_nh_parsing = bl;
    }

    final void setInverseSearchResult(boolean bl) {
        this._inverse_search_result = bl;
    }

    final void setMatchWholeTermsOnly(boolean bl) {
        this._match_whole_terms_only = bl;
    }

    final void setMinConfidenceValue(double d) {
        this._min_confidence_value = d;
    }

    final void setNodeLabelDirection(NODE_LABEL_DIRECTION nODE_LABEL_DIRECTION) {
        this._node_label_direction = nODE_LABEL_DIRECTION;
    }

    private final void setNumberOfDigitsAfterCommaForBranchLength(short s) {
        this._number_of_digits_after_comma_for_branch_length_values = s;
    }

    private final void setNumberOfDigitsAfterCommaForConfidenceValues(short s) {
        this._number_of_digits_after_comma_for_confidence_values = s;
    }

    final void setOvPlacement(OVERVIEW_PLACEMENT_TYPE oVERVIEW_PLACEMENT_TYPE) {
        this._ov_placement = oVERVIEW_PLACEMENT_TYPE;
    }

    final void setPhylogenyGraphicsType(PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE) {
        this._phylogeny_graphics_type = pHYLOGENY_GRAPHICS_TYPE;
    }

    final void setPrintBlackAndWhite(boolean bl) {
        this._print_black_and_white = bl;
    }

    final void setPrintLineWidth(float f) {
        this._print_line_width = f;
    }

    final void setPrintSizeX(int n) {
        this._print_size_x = n;
    }

    final void setPrintSizeY(int n) {
        this._print_size_y = n;
    }

    final void setPrintUsingActualSize(boolean bl) {
        this._print_using_actual_size = bl;
    }

    final void setReplaceUnderscoresInNhParsing(boolean bl) {
        this._nh_parsing_replace_underscores = bl;
    }

    final void setScaleBarLength(double d) {
        this._scale_bar_length = d;
    }

    final void setSearchCaseSensitive(boolean bl) {
        this._search_case_sensitive = bl;
    }

    final void setShowBranchLengthValues(boolean bl) {
        this._show_branch_length_values = bl;
    }

    public void setShowDomainLabels(boolean bl) {
        this._show_domain_labels = bl;
    }

    final void setShowOverview(boolean bl) {
        this._show_overview = bl;
    }

    final void setShowScale(boolean bl) {
        this._show_scale = bl;
    }

    void setTaxonomyColorizeNodeShapes(boolean bl) {
        this._taxonomy_colorize_node_shapes = bl;
    }

    static final Options createDefaultInstance() {
        return new Options();
    }

    boolean isShowDefaultNodeShapes() {
        return this._show_default_node_shapes;
    }

    void setShowDefaultNodeShapes(boolean bl) {
        this._show_default_node_shapes = bl;
    }

    public static final Options createInstance(Configuration configuration) {
        Options options = Options.createDefaultInstance();
        if (configuration != null) {
            options.setAntialiasScreen(configuration.isAntialiasScreen());
            options.setShowScale(configuration.isShowScale());
            options.setShowBranchLengthValues(configuration.isShowBranchLengthValues());
            options.setShowOverview(configuration.isShowOverview());
            options.setCladogramType(configuration.getCladogramType());
            options.setOvPlacement(configuration.getOvPlacement());
            options.setPrintLineWidth(configuration.getPrintLineWidth());
            options.setNodeLabelDirection(configuration.getNodeLabelDirection());
            options.setBackgroundColorGradient(configuration.isBackgroundColorGradient());
            if (configuration.getNumberOfDigitsAfterCommaForBranchLengthValues() >= 0) {
                options.setNumberOfDigitsAfterCommaForBranchLength(configuration.getNumberOfDigitsAfterCommaForBranchLengthValues());
            }
            if (configuration.getNumberOfDigitsAfterCommaForConfidenceValues() >= 0) {
                options.setNumberOfDigitsAfterCommaForConfidenceValues(configuration.getNumberOfDigitsAfterCommaForConfidenceValues());
            }
            options.setExtractPfamTaxonomyCodesInNhParsing(configuration.isExtractPfamTaxonomyCodesInNhParsing());
            options.setReplaceUnderscoresInNhParsing(configuration.isReplaceUnderscoresInNhParsing());
            options.setInternalNumberAreConfidenceForNhParsing(configuration.isInternalNumberAreConfidenceForNhParsing());
            options.setEditable(configuration.isEditable());
            options.setColorLabelsSameAsParentBranch(configuration.isColorLabelsSameAsParentBranch());
            options.setShowDomainLabels(configuration.isShowDomainLabels());
            options.setAbbreviateScientificTaxonNames(configuration.isAbbreviateScientificTaxonNames());
            if (configuration.getMinConfidenceValue() != 0.0) {
                options.setMinConfidenceValue(configuration.getMinConfidenceValue());
            }
            if (configuration.getGraphicsExportX() > 0) {
                options.setPrintSizeX(configuration.getGraphicsExportX());
            }
            if (configuration.getGraphicsExportY() > 0) {
                options.setPrintSizeY(configuration.getGraphicsExportY());
            }
            if (configuration.getBaseFontSize() > 0) {
                options.setBaseFont(options.getBaseFont().deriveFont((float)configuration.getBaseFontSize()));
            }
            if (!ForesterUtil.isEmpty(configuration.getBaseFontFamilyName())) {
                options.setBaseFont(new Font(configuration.getBaseFontFamilyName(), 0, options.getBaseFont().getSize()));
            }
            if (configuration.getPhylogenyGraphicsType() != null) {
                options.setPhylogenyGraphicsType(configuration.getPhylogenyGraphicsType());
            }
            if (configuration.getDefaultNodeFill() != null) {
                options.setDefaultNodeFill(configuration.getDefaultNodeFill());
            }
            if (configuration.getDefaultNodeShape() != null) {
                options.setDefaultNodeShape(configuration.getDefaultNodeShape());
            }
            if (configuration.getDefaultNodeShapeSize() >= 0) {
                options.setDefaultNodeShapeSize(configuration.getDefaultNodeShapeSize());
            }
            options.setTaxonomyColorizeNodeShapes(configuration.isTaxonomyColorizeNodeShapes());
            options.setShowDefaultNodeShapes(configuration.isShowDefaultNodeShapes());
        }
        return options;
    }

    public static enum PHYLOGENY_GRAPHICS_TYPE {
        RECTANGULAR,
        TRIANGULAR,
        EURO_STYLE,
        ROUNDED,
        CONVEX,
        CURVED,
        UNROOTED,
        CIRCULAR;

    }

    static enum OVERVIEW_PLACEMENT_TYPE {
        UPPER_LEFT("upper left"),
        UPPER_RIGHT("upper right"),
        LOWER_LEFT("lower left"),
        LOWER_RIGHT("lower right");

        private final String _name;

        private OVERVIEW_PLACEMENT_TYPE(String string2) {
            this._name = string2;
        }

        public String toString() {
            return this._name;
        }

        public String toTag() {
            return this.toString().replaceAll(" ", "_");
        }
    }

    public static enum NODE_LABEL_DIRECTION {
        HORIZONTAL,
        RADIAL;

    }

    public static enum CLADOGRAM_TYPE {
        NON_LINED_UP,
        EXT_NODE_SUM_DEP,
        TOTAL_NODE_SUM_DEP;

    }
}

