/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.util.ForesterUtil;

public final class ParserUtils {
    private static final Pattern TAXOMONY_CODE_PATTERN_1 = Pattern.compile("[A-Z0-9]{5}");
    private static final Pattern TAXOMONY_CODE_PATTERN_2 = Pattern.compile("([A-Z0-9]{5})[^A-Z].*");

    public static final PhylogenyParser createParserDependingFileContents(File file, boolean bl) throws FileNotFoundException, IOException {
        PhylogenyParser phylogenyParser = null;
        String string = ForesterUtil.getFirstLine(file).trim().toLowerCase();
        if (string.startsWith("<")) {
            ClassLoader classLoader;
            URL uRL;
            phylogenyParser = new PhyloXmlParser();
            if (bl && (uRL = (classLoader = PhyloXmlParser.class.getClassLoader()).getResource("resources/phyloxml.xsd")) != null) {
                ((PhyloXmlParser)phylogenyParser).setValidateAgainstSchema(uRL.toString());
            }
        } else {
            phylogenyParser = string.startsWith("nexus") || string.startsWith("#nexus") || string.startsWith("# nexus") || string.startsWith("begin") ? new NexusPhylogeniesParser() : new NHXParser();
        }
        return phylogenyParser;
    }

    public static final PhylogenyParser createParserDependingOnFileType(File file, boolean bl) throws FileNotFoundException, IOException {
        PhylogenyParser phylogenyParser = null;
        phylogenyParser = ParserUtils.createParserDependingOnSuffix(file.getName(), bl);
        if (phylogenyParser == null) {
            phylogenyParser = ParserUtils.createParserDependingFileContents(file, bl);
        }
        return phylogenyParser;
    }

    public static final PhylogenyParser createParserDependingOnSuffix(String string, boolean bl) {
        PhylogenyParser phylogenyParser = null;
        String string2 = string.toLowerCase();
        if (string2.endsWith(".tol") || string2.endsWith(".tolxml") || string2.endsWith(".tol.zip")) {
            phylogenyParser = new TolParser();
        } else if (string2.endsWith(".xml") || string2.endsWith(".px") || string2.endsWith("phyloxml") || string2.endsWith(".zip")) {
            ClassLoader classLoader;
            URL uRL;
            phylogenyParser = new PhyloXmlParser();
            if (bl && (uRL = (classLoader = PhyloXmlParser.class.getClassLoader()).getResource("resources/phyloxml.xsd")) != null) {
                ((PhyloXmlParser)phylogenyParser).setValidateAgainstSchema(uRL.toString());
            }
        } else if (string2.endsWith(".nexus") || string2.endsWith(".nex") || string2.endsWith(".nx")) {
            phylogenyParser = new NexusPhylogeniesParser();
        } else if (string2.endsWith(".nhx") || string2.endsWith(".nh") || string2.endsWith(".newick") || string2.endsWith(".nwk")) {
            phylogenyParser = new NHXParser();
        }
        return phylogenyParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final PhylogenyParser createParserDependingOnUrlContents(URL uRL, boolean bl) throws FileNotFoundException, IOException {
        String string = uRL.getFile().toString().toLowerCase();
        PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnSuffix(string, bl);
        if (phylogenyParser != null && string.endsWith(".zip")) {
            if (phylogenyParser instanceof PhyloXmlParser) {
                ((PhyloXmlParser)phylogenyParser).setZippedInputstream(true);
            } else if (phylogenyParser instanceof TolParser) {
                ((TolParser)phylogenyParser).setZippedInputstream(true);
            }
        }
        if (phylogenyParser != null) return phylogenyParser;
        String string2 = ForesterUtil.getFirstLine(uRL).trim().toLowerCase();
        if (!string2.startsWith("<")) {
            if (string2.startsWith("nexus")) return new NexusPhylogeniesParser();
            if (string2.startsWith("#nexus")) return new NexusPhylogeniesParser();
            if (string2.startsWith("# nexus")) return new NexusPhylogeniesParser();
            if (!string2.startsWith("begin")) return new NHXParser();
            return new NexusPhylogeniesParser();
        }
        phylogenyParser = new PhyloXmlParser();
        if (!bl) return phylogenyParser;
        ClassLoader classLoader = PhyloXmlParser.class.getClassLoader();
        URL uRL2 = classLoader.getResource("resources/phyloxml.xsd");
        if (uRL2 == null) throw new RuntimeException("failed to get URL for phyloXML XSD from jar file from [resources/phyloxml.xsd]");
        ((PhyloXmlParser)phylogenyParser).setValidateAgainstSchema(uRL2.toString());
        return phylogenyParser;
    }

    public static BufferedReader createReader(Object object) throws IOException, FileNotFoundException {
        BufferedReader bufferedReader = null;
        if (object instanceof File || object instanceof String) {
            File file = null;
            file = object instanceof File ? (File)object : new File((String)object);
            if (!file.exists()) {
                throw new IOException("[" + file.getAbsolutePath() + "] does not exist");
            }
            if (!file.isFile()) {
                throw new IOException("[" + file.getAbsolutePath() + "] is not a file");
            }
            if (!file.canRead()) {
                throw new IOException("[" + file.getAbsolutePath() + "] is not a readable");
            }
            bufferedReader = new BufferedReader(new FileReader(file));
        } else if (object instanceof InputStream) {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        } else if (object instanceof StringBuffer || object instanceof StringBuilder) {
            bufferedReader = new BufferedReader(new StringReader(object.toString()));
        } else {
            throw new IllegalArgumentException("attempt to parse object of type [" + object.getClass() + "] (can only parse objects of type File/String, InputStream, StringBuffer, or StringBuilder)");
        }
        return bufferedReader;
    }

    public static String extractTaxonomyCodeFromNodeName(String string, PhylogenyMethods.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) {
        String[] stringArray;
        if (!(string.indexOf("_") <= 0 || string.length() >= 31 || string.indexOf("|") >= 0 || string.indexOf(".") >= 0 || tAXONOMY_EXTRACTION == PhylogenyMethods.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY && string.indexOf("/") < 0 || string.indexOf("/") >= 0 && string.indexOf("/") <= string.indexOf("_") || (stringArray = string.split("[_/]")).length <= 1)) {
            String string2 = stringArray[1];
            if (string2.length() < 5 && (string2.startsWith("RAT") || string2.startsWith("PIG"))) {
                return string2.substring(0, 3);
            }
            Matcher matcher = TAXOMONY_CODE_PATTERN_1.matcher(string2);
            if (matcher.matches()) {
                return matcher.group();
            }
            Matcher matcher2 = TAXOMONY_CODE_PATTERN_2.matcher(string2);
            if (matcher2.matches()) {
                return matcher2.group(1);
            }
        }
        return null;
    }

    public static final Phylogeny[] readPhylogenies(File file) throws FileNotFoundException, IOException {
        return PhylogenyMethods.readPhylogenies(ParserUtils.createParserDependingOnFileType(file, true), file);
    }

    public static final Phylogeny[] readPhylogenies(String string) throws FileNotFoundException, IOException {
        return ParserUtils.readPhylogenies(new File(string));
    }
}

