/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.FailedConditionCheckException;
import org.forester.util.ForesterUtil;

public class PhylogenyMethods {
    private static PhylogenyMethods _instance = null;
    private final Set<Integer> _temp_hash_set = new HashSet<Integer>();
    private PhylogenyNode _farthest_1 = null;
    private PhylogenyNode _farthest_2 = null;

    private PhylogenyMethods() {
    }

    public double calculateDistance(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        PhylogenyNode phylogenyNode3 = this.obtainLCA(phylogenyNode, phylogenyNode2);
        PhylogenyNode phylogenyNode4 = phylogenyNode;
        PhylogenyNode phylogenyNode5 = phylogenyNode2;
        return PhylogenyMethods.getDistance(phylogenyNode4, phylogenyNode3) + PhylogenyMethods.getDistance(phylogenyNode5, phylogenyNode3);
    }

    public double calculateFurthestDistance(Phylogeny phylogeny) {
        if (phylogeny.getNumberOfExternalNodes() < 2) {
            return 0.0;
        }
        this._farthest_1 = null;
        this._farthest_2 = null;
        PhylogenyNode phylogenyNode = null;
        PhylogenyNode phylogenyNode2 = null;
        double d = -1.7976931348623157E308;
        PhylogenyMethods phylogenyMethods = PhylogenyMethods.getInstance();
        List<PhylogenyNode> list = phylogeny.getRoot().getAllExternalDescendants();
        for (int i = 1; i < list.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                double d2 = phylogenyMethods.calculateDistance(list.get(i), list.get(j));
                if (d2 < 0.0) {
                    throw new RuntimeException("distance cannot be negative");
                }
                if (!(d2 > d)) continue;
                d = d2;
                phylogenyNode = list.get(i);
                phylogenyNode2 = list.get(j);
            }
        }
        this._farthest_1 = phylogenyNode;
        this._farthest_2 = phylogenyNode2;
        return d;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public PhylogenyNode getFarthestNode1() {
        return this._farthest_1;
    }

    public PhylogenyNode getFarthestNode2() {
        return this._farthest_2;
    }

    public PhylogenyNode obtainLCA(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        this._temp_hash_set.clear();
        PhylogenyNode phylogenyNode3 = phylogenyNode;
        PhylogenyNode phylogenyNode4 = phylogenyNode2;
        this._temp_hash_set.add(phylogenyNode3.getId());
        while (!phylogenyNode3.isRoot()) {
            phylogenyNode3 = phylogenyNode3.getParent();
            this._temp_hash_set.add(phylogenyNode3.getId());
        }
        while (!this._temp_hash_set.contains(phylogenyNode4.getId()) && !phylogenyNode4.isRoot()) {
            phylogenyNode4 = phylogenyNode4.getParent();
        }
        if (!this._temp_hash_set.contains(phylogenyNode4.getId())) {
            throw new IllegalArgumentException("attempt to get LCA of two nodes which do not share a common root");
        }
        return phylogenyNode4;
    }

    public List<PhylogenyNode> getOrthologousNodes(Phylogeny phylogeny, PhylogenyNode phylogenyNode) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode2 = phylogenyNodeIterator.next();
            if (phylogenyNode2 == phylogenyNode || !this.isAreOrthologous(phylogenyNode, phylogenyNode2)) continue;
            arrayList.add(phylogenyNode2);
        }
        return arrayList;
    }

    public boolean isAreOrthologous(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        return !this.obtainLCA(phylogenyNode, phylogenyNode2).isDuplication();
    }

    public static final Phylogeny[] readPhylogenies(PhylogenyParser phylogenyParser, File file) throws IOException {
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        Phylogeny[] phylogenyArray = phylogenyFactory.create(file, phylogenyParser);
        if (phylogenyArray == null || phylogenyArray.length == 0) {
            throw new PhylogenyParserException("Unable to parse phylogeny from file: " + file);
        }
        return phylogenyArray;
    }

    public static final Phylogeny[] readPhylogenies(PhylogenyParser phylogenyParser, List<File> list) throws IOException {
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        for (File file : list) {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny[] phylogenyArray = phylogenyFactory.create(file, phylogenyParser);
            if (phylogenyArray == null || phylogenyArray.length == 0) {
                throw new PhylogenyParserException("Unable to parse phylogeny from file: " + file);
            }
            arrayList.addAll(Arrays.asList(phylogenyArray));
        }
        return arrayList.toArray(new Phylogeny[arrayList.size()]);
    }

    public static final void transferInternalNodeNamesToConfidence(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.getBranchData().isHasConfidences() || ForesterUtil.isEmpty(phylogenyNode.getName())) continue;
            double d = -1.0;
            try {
                d = Double.parseDouble(phylogenyNode.getName());
            }
            catch (Exception exception) {
                d = -1.0;
            }
            if (!(d >= 0.0)) continue;
            phylogenyNode.getBranchData().addConfidence(new Confidence(d, ""));
            phylogenyNode.setName("");
        }
    }

    public static final void transferInternalNamesToBootstrapSupport(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || ForesterUtil.isEmpty(phylogenyNode.getName())) continue;
            double d = -1.0;
            try {
                d = Double.parseDouble(phylogenyNode.getName());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("failed to parse number from [" + phylogenyNode.getName() + "]: " + numberFormatException.getLocalizedMessage());
            }
            if (!(d >= 0.0)) continue;
            phylogenyNode.getBranchData().addConfidence(new Confidence(d, "bootstrap"));
            phylogenyNode.setName("");
        }
    }

    public static final void sortNodeDescendents(PhylogenyNode phylogenyNode, DESCENDANT_SORT_PRIORITY dESCENDANT_SORT_PRIORITY) {
        Comparator<PhylogenyNode> comparator;
        switch (dESCENDANT_SORT_PRIORITY) {
            case SEQUENCE: {
                class PhylogenyNodeSortSequencePriority
                implements Comparator<PhylogenyNode> {
                    PhylogenyNodeSortSequencePriority() {
                    }

                    @Override
                    public int compare(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
                        if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode2.getNodeData().isHasSequence()) {
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getName())) {
                                return phylogenyNode.getNodeData().getSequence().getName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getSequence().getName().toLowerCase());
                            }
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getSymbol())) {
                                return phylogenyNode.getNodeData().getSequence().getSymbol().compareTo(phylogenyNode2.getNodeData().getSequence().getSymbol());
                            }
                            if (phylogenyNode.getNodeData().getSequence().getAccession() != null && phylogenyNode2.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getAccession().getValue())) {
                                return phylogenyNode.getNodeData().getSequence().getAccession().getValue().compareTo(phylogenyNode2.getNodeData().getSequence().getAccession().getValue());
                            }
                        }
                        if (phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode2.getNodeData().isHasTaxonomy()) {
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName())) {
                                return phylogenyNode.getNodeData().getTaxonomy().getScientificName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getScientificName().toLowerCase());
                            }
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                                return phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode());
                            }
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getCommonName())) {
                                return phylogenyNode.getNodeData().getTaxonomy().getCommonName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getCommonName().toLowerCase());
                            }
                        }
                        if (!ForesterUtil.isEmpty(phylogenyNode.getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getName())) {
                            return phylogenyNode.getName().toLowerCase().compareTo(phylogenyNode2.getName().toLowerCase());
                        }
                        return 0;
                    }
                }
                comparator = new PhylogenyNodeSortSequencePriority();
                break;
            }
            case NODE_NAME: {
                class PhylogenyNodeSortNodeNamePriority
                implements Comparator<PhylogenyNode> {
                    PhylogenyNodeSortNodeNamePriority() {
                    }

                    @Override
                    public int compare(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
                        if (!ForesterUtil.isEmpty(phylogenyNode.getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getName())) {
                            return phylogenyNode.getName().toLowerCase().compareTo(phylogenyNode2.getName().toLowerCase());
                        }
                        if (phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode2.getNodeData().isHasTaxonomy()) {
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName())) {
                                return phylogenyNode.getNodeData().getTaxonomy().getScientificName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getScientificName().toLowerCase());
                            }
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                                return phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode());
                            }
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getCommonName())) {
                                return phylogenyNode.getNodeData().getTaxonomy().getCommonName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getCommonName().toLowerCase());
                            }
                        }
                        if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode2.getNodeData().isHasSequence()) {
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getName())) {
                                return phylogenyNode.getNodeData().getSequence().getName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getSequence().getName().toLowerCase());
                            }
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getSymbol())) {
                                return phylogenyNode.getNodeData().getSequence().getSymbol().compareTo(phylogenyNode2.getNodeData().getSequence().getSymbol());
                            }
                            if (phylogenyNode.getNodeData().getSequence().getAccession() != null && phylogenyNode2.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getAccession().getValue())) {
                                return phylogenyNode.getNodeData().getSequence().getAccession().getValue().compareTo(phylogenyNode2.getNodeData().getSequence().getAccession().getValue());
                            }
                        }
                        return 0;
                    }
                }
                comparator = new PhylogenyNodeSortNodeNamePriority();
                break;
            }
            default: {
                class PhylogenyNodeSortTaxonomyPriority
                implements Comparator<PhylogenyNode> {
                    PhylogenyNodeSortTaxonomyPriority() {
                    }

                    @Override
                    public int compare(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
                        if (phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode2.getNodeData().isHasTaxonomy()) {
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName())) {
                                return phylogenyNode.getNodeData().getTaxonomy().getScientificName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getScientificName().toLowerCase());
                            }
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                                return phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode());
                            }
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getCommonName())) {
                                return phylogenyNode.getNodeData().getTaxonomy().getCommonName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getCommonName().toLowerCase());
                            }
                        }
                        if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode2.getNodeData().isHasSequence()) {
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getName())) {
                                return phylogenyNode.getNodeData().getSequence().getName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getSequence().getName().toLowerCase());
                            }
                            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getSymbol())) {
                                return phylogenyNode.getNodeData().getSequence().getSymbol().compareTo(phylogenyNode2.getNodeData().getSequence().getSymbol());
                            }
                            if (phylogenyNode.getNodeData().getSequence().getAccession() != null && phylogenyNode2.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getAccession().getValue())) {
                                return phylogenyNode.getNodeData().getSequence().getAccession().getValue().compareTo(phylogenyNode2.getNodeData().getSequence().getAccession().getValue());
                            }
                        }
                        if (!ForesterUtil.isEmpty(phylogenyNode.getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getName())) {
                            return phylogenyNode.getName().toLowerCase().compareTo(phylogenyNode2.getName().toLowerCase());
                        }
                        return 0;
                    }
                }
                comparator = new PhylogenyNodeSortTaxonomyPriority();
            }
        }
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        Collections.sort(list, comparator);
        int n = 0;
        for (PhylogenyNode phylogenyNode2 : list) {
            phylogenyNode.setChildNode(n++, phylogenyNode2);
        }
    }

    public static final void transferNodeNameToField(Phylogeny phylogeny, PhylogenyNodeField phylogenyNodeField, boolean bl) throws PhyloXmlDataFormatException {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            String string;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (bl && phylogenyNode.isInternal() || ForesterUtil.isEmpty(string = phylogenyNode.getName().trim())) continue;
            switch (phylogenyNodeField) {
                case TAXONOMY_CODE: {
                    phylogenyNode.setName("");
                    PhylogenyMethods.setTaxonomyCode(phylogenyNode, string);
                    break;
                }
                case TAXONOMY_SCIENTIFIC_NAME: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setScientificName(string);
                    break;
                }
                case TAXONOMY_COMMON_NAME: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setCommonName(string);
                    break;
                }
                case SEQUENCE_SYMBOL: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasSequence()) {
                        phylogenyNode.getNodeData().setSequence(new Sequence());
                    }
                    phylogenyNode.getNodeData().getSequence().setSymbol(string);
                    break;
                }
                case SEQUENCE_NAME: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasSequence()) {
                        phylogenyNode.getNodeData().setSequence(new Sequence());
                    }
                    phylogenyNode.getNodeData().getSequence().setName(string);
                    break;
                }
                case TAXONOMY_ID_UNIPROT_1: {
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    String string2 = string;
                    int n = string.indexOf(95);
                    if (n > 0) {
                        string2 = string.substring(0, n);
                    } else {
                        phylogenyNode.setName("");
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(string2, "uniprot"));
                    break;
                }
                case TAXONOMY_ID_UNIPROT_2: {
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    String string2 = string;
                    int n = string.indexOf(95);
                    if (n > 0) {
                        string2 = string.substring(n + 1, string.length());
                    } else {
                        phylogenyNode.setName("");
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(string2, "uniprot"));
                    break;
                }
                case TAXONOMY_ID: {
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(string));
                }
            }
        }
    }

    static double addPhylogenyDistances(double d, double d2) {
        if (d >= 0.0 && d2 >= 0.0) {
            return d + d2;
        }
        if (d >= 0.0) {
            return d;
        }
        if (d2 >= 0.0) {
            return d2;
        }
        return -1024.0;
    }

    public static boolean areAllChildrenDuplications(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isExternal()) {
            return false;
        }
        if (phylogenyNode.isDuplication()) {
            for (PhylogenyNode phylogenyNode2 : phylogenyNode.getDescendants()) {
                if (PhylogenyMethods.areAllChildrenDuplications(phylogenyNode2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int calculateDepth(PhylogenyNode phylogenyNode) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        int n = 0;
        while (!phylogenyNode2.isRoot()) {
            ++n;
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        return n;
    }

    public static double calculateDistanceToRoot(PhylogenyNode phylogenyNode) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        double d = 0.0;
        while (!phylogenyNode2.isRoot()) {
            if (phylogenyNode2.getDistanceToParent() > 0.0) {
                d += phylogenyNode2.getDistanceToParent();
            }
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        return d;
    }

    public static short calculateMaxBranchesToLeaf(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isExternal()) {
            return 0;
        }
        short s = 0;
        Iterator<PhylogenyNode> iterator = phylogenyNode.getAllExternalDescendants().iterator();
        while (iterator.hasNext()) {
            short s2 = 0;
            for (PhylogenyNode phylogenyNode2 = iterator.next(); phylogenyNode2 != phylogenyNode; phylogenyNode2 = phylogenyNode2.getParent()) {
                s2 = phylogenyNode2.isCollapse() ? (short)0 : (short)(s2 + 1);
            }
            if (s >= s2) continue;
            s = s2;
        }
        return s;
    }

    public static int calculateMaxDepth(Phylogeny phylogeny) {
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            int n2 = PhylogenyMethods.calculateDepth(phylogenyNode);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static double calculateMaxDistanceToRoot(Phylogeny phylogeny) {
        double d = 0.0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            double d2 = PhylogenyMethods.calculateDistanceToRoot(phylogenyNode);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static int countNumberOfPolytomies(Phylogeny phylogeny) {
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.getNumberOfDescendants() <= 2) continue;
            ++n;
        }
        return n;
    }

    public static DescriptiveStatistics calculatNumberOfDescendantsPerNodeStatistics(Phylogeny phylogeny) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) continue;
            basicDescriptiveStatistics.addValue(phylogenyNode.getNumberOfDescendants());
        }
        return basicDescriptiveStatistics;
    }

    public static DescriptiveStatistics calculatBranchLengthStatistics(Phylogeny phylogeny) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isRoot() || !(phylogenyNode.getDistanceToParent() >= 0.0)) continue;
            basicDescriptiveStatistics.addValue(phylogenyNode.getDistanceToParent());
        }
        return basicDescriptiveStatistics;
    }

    public static List<DescriptiveStatistics> calculatConfidenceStatistics(Phylogeny phylogeny) {
        ArrayList<DescriptiveStatistics> arrayList = new ArrayList<DescriptiveStatistics>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.isRoot() || !phylogenyNode.getBranchData().isHasConfidences()) continue;
            for (int i = 0; i < phylogenyNode.getBranchData().getConfidences().size(); ++i) {
                Confidence confidence = phylogenyNode.getBranchData().getConfidences().get(i);
                if (i > arrayList.size() - 1 || arrayList.get(i) == null) {
                    arrayList.add(i, new BasicDescriptiveStatistics());
                }
                if (!ForesterUtil.isEmpty(confidence.getType())) {
                    if (!ForesterUtil.isEmpty(((DescriptiveStatistics)arrayList.get(i)).getDescription()) && !((DescriptiveStatistics)arrayList.get(i)).getDescription().equalsIgnoreCase(confidence.getType())) {
                        throw new IllegalArgumentException("support values in node [" + phylogenyNode.toString() + "] appear inconsistently ordered");
                    }
                    ((DescriptiveStatistics)arrayList.get(i)).setDescription(confidence.getType());
                }
                ((DescriptiveStatistics)arrayList.get(i)).addValue(confidence != null && confidence.getValue() >= 0.0 ? confidence.getValue() : 0.0);
            }
        }
        return arrayList;
    }

    public static Set<Taxonomy> obtainDistinctTaxonomies(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        HashSet<Taxonomy> hashSet = new HashSet<Taxonomy>();
        for (PhylogenyNode phylogenyNode2 : list) {
            if (!phylogenyNode2.getNodeData().isHasTaxonomy() || phylogenyNode2.getNodeData().getTaxonomy().isEmpty()) {
                return null;
            }
            hashSet.add(phylogenyNode2.getNodeData().getTaxonomy());
        }
        return hashSet;
    }

    public static SortedMap<Taxonomy, Integer> obtainDistinctTaxonomyCounts(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        TreeMap<Taxonomy, Integer> treeMap = new TreeMap<Taxonomy, Integer>();
        for (PhylogenyNode phylogenyNode2 : list) {
            if (!phylogenyNode2.getNodeData().isHasTaxonomy() || phylogenyNode2.getNodeData().getTaxonomy().isEmpty()) {
                return null;
            }
            Taxonomy taxonomy = phylogenyNode2.getNodeData().getTaxonomy();
            if (treeMap.containsKey(taxonomy)) {
                treeMap.put(taxonomy, (Integer)treeMap.get(taxonomy) + 1);
                continue;
            }
            treeMap.put(taxonomy, 1);
        }
        return treeMap;
    }

    public static int calculateNumberOfExternalNodesWithoutTaxonomy(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        int n = 0;
        for (PhylogenyNode phylogenyNode2 : list) {
            if (phylogenyNode2.getNodeData().isHasTaxonomy() && !phylogenyNode2.getNodeData().getTaxonomy().isEmpty()) continue;
            ++n;
        }
        return n;
    }

    static PhylogenyNode copySubTree(PhylogenyNode phylogenyNode) {
        if (phylogenyNode == null) {
            return null;
        }
        PhylogenyNode phylogenyNode2 = phylogenyNode.copyNodeData();
        if (!phylogenyNode.isExternal()) {
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                phylogenyNode2.setChildNode(i, PhylogenyMethods.copySubTree(phylogenyNode.getChildNode(i)));
            }
        }
        return phylogenyNode2;
    }

    static PhylogenyNode copySubTreeShallow(PhylogenyNode phylogenyNode) {
        if (phylogenyNode == null) {
            return null;
        }
        PhylogenyNode phylogenyNode2 = phylogenyNode.copyNodeDataShallow();
        if (!phylogenyNode.isExternal()) {
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                phylogenyNode2.setChildNode(i, PhylogenyMethods.copySubTreeShallow(phylogenyNode.getChildNode(i)));
            }
        }
        return phylogenyNode2;
    }

    public static void deleteExternalNodesNegativeSelection(Set<Integer> set, Phylogeny phylogeny) {
        phylogeny.clearHashIdToNodeMap();
        for (Integer n : set) {
            phylogeny.deleteSubtree(phylogeny.getNode(n), true);
        }
        phylogeny.clearHashIdToNodeMap();
        phylogeny.externalNodesHaveChanged();
    }

    public static void deleteExternalNodesNegativeSelection(String[] stringArray, Phylogeny phylogeny) throws IllegalArgumentException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (ForesterUtil.isEmpty(stringArray[i])) continue;
            List<PhylogenyNode> list = null;
            list = phylogeny.getNodes(stringArray[i]);
            for (PhylogenyNode phylogenyNode : list) {
                if (!phylogenyNode.isExternal()) {
                    throw new IllegalArgumentException("attempt to delete non-external node \"" + stringArray[i] + "\"");
                }
                phylogeny.deleteSubtree(phylogenyNode, true);
            }
        }
        phylogeny.clearHashIdToNodeMap();
        phylogeny.externalNodesHaveChanged();
    }

    public static void deleteExternalNodesPositiveSelection(Set<Taxonomy> set, Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                if (set.contains(phylogenyNode.getNodeData().getTaxonomy())) continue;
                phylogeny.deleteSubtree(phylogenyNode, true);
                continue;
            }
            throw new IllegalArgumentException("node " + phylogenyNode.getId() + " has no taxonomic data");
        }
        phylogeny.clearHashIdToNodeMap();
        phylogeny.externalNodesHaveChanged();
    }

    public static List<String> deleteExternalNodesPositiveSelection(String[] stringArray, Phylogeny phylogeny) {
        Object object;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        String[] stringArray2 = new String[phylogeny.getNumberOfExternalNodes()];
        int n = 0;
        Arrays.sort(stringArray);
        while (phylogenyNodeIterator.hasNext()) {
            object = phylogenyNodeIterator.next().getName();
            if (Arrays.binarySearch(stringArray, object) >= 0) continue;
            stringArray2[n++] = object;
        }
        PhylogenyMethods.deleteExternalNodesNegativeSelection(stringArray2, phylogeny);
        object = new ArrayList();
        for (String string : stringArray2) {
            if (ForesterUtil.isEmpty(string)) continue;
            object.add(string);
        }
        return object;
    }

    public static List<PhylogenyNode> getAllDescendants(PhylogenyNode phylogenyNode) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (!phylogenyNode.isExternal()) {
            List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
            for (PhylogenyNode phylogenyNode2 : list) {
                arrayList.add(phylogenyNode2);
                while (phylogenyNode2 != phylogenyNode) {
                    if (hashSet.contains((phylogenyNode2 = phylogenyNode2.getParent()).getId())) continue;
                    arrayList.add(phylogenyNode2);
                    hashSet.add(phylogenyNode2.getId());
                }
            }
        }
        return arrayList;
    }

    public static Color getBranchColorValue(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.getBranchData().getBranchColor() == null) {
            return null;
        }
        return phylogenyNode.getBranchData().getBranchColor().getValue();
    }

    public static double getBranchWidthValue(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getBranchData().isHasBranchWidth()) {
            return 1.0;
        }
        return phylogenyNode.getBranchData().getBranchWidth().getValue();
    }

    public static double getConfidenceValue(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getBranchData().isHasConfidences()) {
            return -9999.0;
        }
        return phylogenyNode.getBranchData().getConfidence(0).getValue();
    }

    public static double[] getConfidenceValuesAsArray(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getBranchData().isHasConfidences()) {
            return new double[0];
        }
        double[] dArray = new double[phylogenyNode.getBranchData().getConfidences().size()];
        int n = 0;
        for (Confidence confidence : phylogenyNode.getBranchData().getConfidences()) {
            dArray[n++] = confidence.getValue();
        }
        return dArray;
    }

    private static double getDistance(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        double d = 0.0;
        while (phylogenyNode != phylogenyNode2) {
            if (phylogenyNode.getDistanceToParent() > 0.0) {
                d += phylogenyNode.getDistanceToParent();
            }
            phylogenyNode = phylogenyNode.getParent();
        }
        return d;
    }

    public static Taxonomy getExternalDescendantsTaxonomy(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        Taxonomy taxonomy = null;
        for (PhylogenyNode phylogenyNode2 : list) {
            if (!phylogenyNode2.getNodeData().isHasTaxonomy() || phylogenyNode2.getNodeData().getTaxonomy().isEmpty()) {
                return null;
            }
            if (taxonomy == null) {
                taxonomy = phylogenyNode2.getNodeData().getTaxonomy();
                continue;
            }
            if (!phylogenyNode2.getNodeData().getTaxonomy().isEmpty() && taxonomy.isEqual(phylogenyNode2.getNodeData().getTaxonomy())) continue;
            return null;
        }
        return taxonomy;
    }

    public static PhylogenyNode getFurthestDescendant(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        PhylogenyNode phylogenyNode2 = null;
        double d = -1.7976931348623157E308;
        for (PhylogenyNode phylogenyNode3 : list) {
            if (!(PhylogenyMethods.getDistance(phylogenyNode3, phylogenyNode) > d)) continue;
            phylogenyNode2 = phylogenyNode3;
            d = PhylogenyMethods.getDistance(phylogenyNode3, phylogenyNode);
        }
        return phylogenyNode2;
    }

    public static PhylogenyMethods getInstance() {
        if (_instance == null) {
            _instance = new PhylogenyMethods();
        }
        return _instance;
    }

    public static double getMaximumConfidenceValue(Phylogeny phylogeny) {
        double d = -1.7976931348623157E308;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            double d2 = PhylogenyMethods.getConfidenceValue(phylogenyNodeIterator.next());
            if (d2 == -9999.0 || !(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static int getMinimumDescendentsPerInternalNodes(Phylogeny phylogeny) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isInternal() || (n2 = phylogenyNode.getNumberOfDescendants()) >= n) continue;
            n = n2;
        }
        return n;
    }

    public static String getSpecies(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
            return "";
        }
        if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName())) {
            return phylogenyNode.getNodeData().getTaxonomy().getScientificName();
        }
        if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode())) {
            return phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode();
        }
        return phylogenyNode.getNodeData().getTaxonomy().getCommonName();
    }

    public static List<PhylogenyNode> getSuperOrthologousNodes(PhylogenyNode phylogenyNode) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        PhylogenyNode phylogenyNode3 = null;
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        if (!phylogenyNode2.isExternal()) {
            return null;
        }
        while (!phylogenyNode2.isRoot() && !phylogenyNode2.getParent().isDuplication()) {
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        phylogenyNode3 = phylogenyNode2;
        phylogenyNode3.setIndicatorsToZero();
        do {
            if (!phylogenyNode2.isExternal()) {
                if (phylogenyNode2.getIndicator() == 0) {
                    phylogenyNode2.setIndicator((byte)1);
                    if (!phylogenyNode2.isDuplication()) {
                        phylogenyNode2 = phylogenyNode2.getChildNode1();
                    }
                }
                if (phylogenyNode2.getIndicator() == 1) {
                    phylogenyNode2.setIndicator((byte)2);
                    if (!phylogenyNode2.isDuplication()) {
                        phylogenyNode2 = phylogenyNode2.getChildNode2();
                    }
                }
                if (phylogenyNode2 == phylogenyNode3 || phylogenyNode2.getIndicator() != 2) continue;
                phylogenyNode2 = phylogenyNode2.getParent();
                continue;
            }
            if (phylogenyNode2 != phylogenyNode) {
                arrayList.add(phylogenyNode2);
            }
            if (phylogenyNode2 != phylogenyNode3) {
                phylogenyNode2 = phylogenyNode2.getParent();
                continue;
            }
            phylogenyNode2.setIndicator((byte)2);
        } while (phylogenyNode2 != phylogenyNode3 || phylogenyNode3.getIndicator() != 2);
        return arrayList;
    }

    public static String getTaxonomyIdentifier(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasTaxonomy() || phylogenyNode.getNodeData().getTaxonomy().getIdentifier() == null) {
            return "";
        }
        return phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue();
    }

    public static List<PhylogenyNode> getUltraParalogousNodes(PhylogenyNode phylogenyNode) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        if (!phylogenyNode2.isExternal()) {
            return null;
        }
        while (!phylogenyNode2.isRoot() && phylogenyNode2.getParent().isDuplication() && PhylogenyMethods.areAllChildrenDuplications(phylogenyNode2.getParent())) {
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        List<PhylogenyNode> list = phylogenyNode2.getAllExternalDescendants();
        list.remove(phylogenyNode);
        return list;
    }

    public static String inferCommonPartOfScientificNameOfDescendants(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        String string = null;
        for (PhylogenyNode phylogenyNode2 : list) {
            if (!phylogenyNode2.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName())) {
                return null;
            }
            if (string == null) {
                string = phylogenyNode2.getNodeData().getTaxonomy().getScientificName().trim();
                continue;
            }
            String string2 = phylogenyNode2.getNodeData().getTaxonomy().getScientificName().trim();
            if (string.equals(string2)) continue;
            boolean bl = false;
            while (string.indexOf(32) >= 0 || string2.indexOf(32) >= 0) {
                if (ForesterUtil.countChars(string, ' ') > ForesterUtil.countChars(string2, ' ')) {
                    string = string.substring(0, string.lastIndexOf(32)).trim();
                } else {
                    string2 = string2.substring(0, string2.lastIndexOf(32)).trim();
                }
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return null;
        }
        return string;
    }

    public static boolean isHasExternalDescendant(PhylogenyNode phylogenyNode) {
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            if (!phylogenyNode.getChildNode(i).isExternal()) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean isTaxonomyHasIdentifierOfGivenProvider(Taxonomy taxonomy, String[] stringArray) {
        if (taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getProvider())) {
            String string = taxonomy.getIdentifier().getProvider();
            for (String string2 : stringArray) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean match(String string, String string2, boolean bl, boolean bl2) {
        if (ForesterUtil.isEmpty(string) || ForesterUtil.isEmpty(string2)) {
            return false;
        }
        String string3 = string.trim();
        String string4 = string2.trim();
        if (!bl) {
            string3 = string3.toLowerCase();
            string4 = string4.toLowerCase();
        }
        if (bl2) {
            return string3.indexOf(string4) >= 0;
        }
        return string3.equals(string4);
    }

    public static void midpointRoot(Phylogeny phylogeny) {
        if (phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        PhylogenyMethods phylogenyMethods = PhylogenyMethods.getInstance();
        double d = phylogenyMethods.calculateFurthestDistance(phylogeny);
        PhylogenyNode phylogenyNode = phylogenyMethods.getFarthestNode1();
        PhylogenyNode phylogenyNode2 = phylogenyMethods.getFarthestNode2();
        if (d <= 0.0) {
            return;
        }
        double d2 = d / 2.0;
        PhylogenyNode phylogenyNode3 = phylogenyNode;
        if (PhylogenyMethods.getDistance(phylogenyNode, phylogeny.getRoot()) < PhylogenyMethods.getDistance(phylogenyNode2, phylogeny.getRoot())) {
            phylogenyNode3 = phylogenyNode2;
        }
        while (d2 > phylogenyNode3.getDistanceToParent() && !phylogenyNode3.isRoot()) {
            d2 -= phylogenyNode3.getDistanceToParent() > 0.0 ? phylogenyNode3.getDistanceToParent() : 0.0;
            phylogenyNode3 = phylogenyNode3.getParent();
        }
        phylogeny.reRoot(phylogenyNode3, d2);
        phylogeny.recalculateNumberOfExternalDescendants(true);
        PhylogenyNode phylogenyNode4 = PhylogenyMethods.getFurthestDescendant(phylogeny.getRoot().getChildNode1());
        PhylogenyNode phylogenyNode5 = PhylogenyMethods.getFurthestDescendant(phylogeny.getRoot().getChildNode2());
        double d3 = PhylogenyMethods.getDistance(phylogenyNode4, phylogeny.getRoot());
        double d4 = PhylogenyMethods.getDistance(phylogenyNode5, phylogeny.getRoot());
        if (Math.abs(d3 - d4) > 1.0E-6) {
            throw new FailedConditionCheckException("this should not have happened: midpoint rooting failed:  da=" + d3 + ",  db=" + d4 + ",  diff=" + Math.abs(d3 - d4));
        }
    }

    public static void normalizeBootstrapValues(Phylogeny phylogeny, double d, double d2) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            double d3;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isInternal() || (d3 = PhylogenyMethods.getConfidenceValue(phylogenyNode)) == -9999.0) continue;
            if (d3 >= d) {
                PhylogenyMethods.setBootstrapConfidence(phylogenyNode, d2);
                continue;
            }
            PhylogenyMethods.setBootstrapConfidence(phylogenyNode, d3 * d2 / d);
        }
    }

    public static List<PhylogenyNode> obtainAllNodesAsList(Phylogeny phylogeny) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        if (phylogeny.isEmpty()) {
            return arrayList;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            arrayList.add(phylogenyNodeIterator.next());
        }
        return arrayList;
    }

    public static void postorderBranchColorAveragingExternalNodeBased(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            int n = 0;
            if (!phylogenyNode.isInternal()) continue;
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
                Color color = PhylogenyMethods.getBranchColorValue(phylogenyNode2);
                if (color == null) continue;
                ++n;
                d += (double)color.getRed();
                d2 += (double)color.getGreen();
                d3 += (double)color.getBlue();
            }
            PhylogenyMethods.setBranchColorValue(phylogenyNode, new Color(ForesterUtil.roundToInt(d / (double)n), ForesterUtil.roundToInt(d2 / (double)n), ForesterUtil.roundToInt(d3 / (double)n)));
        }
    }

    public static void removeNode(PhylogenyNode phylogenyNode, Phylogeny phylogeny) {
        if (phylogenyNode.isRoot()) {
            throw new IllegalArgumentException("ill advised attempt to remove root node");
        }
        if (phylogenyNode.isExternal()) {
            phylogeny.deleteSubtree(phylogenyNode, false);
            phylogeny.clearHashIdToNodeMap();
            phylogeny.externalNodesHaveChanged();
        } else {
            PhylogenyNode phylogenyNode2 = phylogenyNode.getParent();
            List<PhylogenyNode> list = phylogenyNode.getDescendants();
            phylogenyNode2.removeChildNode(phylogenyNode);
            for (PhylogenyNode phylogenyNode3 : list) {
                phylogenyNode2.addAsChild(phylogenyNode3);
                phylogenyNode3.setDistanceToParent(PhylogenyMethods.addPhylogenyDistances(phylogenyNode.getDistanceToParent(), phylogenyNode3.getDistanceToParent()));
            }
            phylogenyNode.setParent(null);
            phylogeny.clearHashIdToNodeMap();
            phylogeny.externalNodesHaveChanged();
        }
    }

    public static List<PhylogenyNode> searchData(String string, Phylogeny phylogeny, boolean bl, boolean bl2) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        if (phylogeny.isEmpty() || string == null) {
            return arrayList;
        }
        if (ForesterUtil.isEmpty(string)) {
            return arrayList;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            Object object;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            boolean bl3 = false;
            if (PhylogenyMethods.match(phylogenyNode.getName(), string, bl, bl2)) {
                bl3 = true;
            } else if (phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode(), string, bl, bl2)) {
                bl3 = true;
            } else if (phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getCommonName(), string, bl, bl2)) {
                bl3 = true;
            } else if (phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getScientificName(), string, bl, bl2)) {
                bl3 = true;
            } else if (phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode.getNodeData().getTaxonomy().getIdentifier() != null && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue(), string, bl, bl2)) {
                bl3 = true;
            } else if (phylogenyNode.getNodeData().isHasTaxonomy() && !phylogenyNode.getNodeData().getTaxonomy().getSynonyms().isEmpty()) {
                object = phylogenyNode.getNodeData().getTaxonomy().getSynonyms();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (!PhylogenyMethods.match(string2, string, bl, bl2)) continue;
                    bl3 = true;
                    break;
                }
            }
            if (!bl3 && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getName(), string, bl, bl2)) {
                bl3 = true;
            }
            if (!bl3 && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getSymbol(), string, bl, bl2)) {
                bl3 = true;
            }
            if (!bl3 && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getAccession().getValue(), string, bl, bl2)) {
                bl3 = true;
            }
            if (!bl3 && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getDomainArchitecture() != null) {
                object = phylogenyNode.getNodeData().getSequence().getDomainArchitecture();
                for (int i = 0; i < ((DomainArchitecture)object).getNumberOfDomains(); ++i) {
                    if (!PhylogenyMethods.match(((DomainArchitecture)object).getDomain(i).getName(), string, bl, bl2)) continue;
                    bl3 = true;
                    break;
                }
            }
            if (!bl3 && phylogenyNode.getNodeData().getBinaryCharacters() != null) {
                object = phylogenyNode.getNodeData().getBinaryCharacters().getPresentCharacters().iterator();
                while (object.hasNext()) {
                    if (!PhylogenyMethods.match((String)object.next(), string, bl, bl2)) continue;
                    bl3 = true;
                    break;
                }
                object = phylogenyNode.getNodeData().getBinaryCharacters().getGainedCharacters().iterator();
                while (object.hasNext()) {
                    if (!PhylogenyMethods.match((String)object.next(), string, bl, bl2)) continue;
                    bl3 = true;
                    break;
                }
            }
            if (!bl3) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    public static List<PhylogenyNode> searchDataLogicalAnd(String[] stringArray, Phylogeny phylogeny, boolean bl, boolean bl2) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        if (phylogeny.isEmpty() || stringArray == null || stringArray.length < 1) {
            return arrayList;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            boolean bl3 = true;
            for (String string : stringArray) {
                Object object;
                boolean bl4 = false;
                if (ForesterUtil.isEmpty(string)) continue;
                if (PhylogenyMethods.match(phylogenyNode.getName(), string, bl, bl2)) {
                    bl4 = true;
                } else if (phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode(), string, bl, bl2)) {
                    bl4 = true;
                } else if (phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getCommonName(), string, bl, bl2)) {
                    bl4 = true;
                } else if (phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getScientificName(), string, bl, bl2)) {
                    bl4 = true;
                } else if (phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode.getNodeData().getTaxonomy().getIdentifier() != null && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue(), string, bl, bl2)) {
                    bl4 = true;
                } else if (phylogenyNode.getNodeData().isHasTaxonomy() && !phylogenyNode.getNodeData().getTaxonomy().getSynonyms().isEmpty()) {
                    object = phylogenyNode.getNodeData().getTaxonomy().getSynonyms();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (!PhylogenyMethods.match(string2, string, bl, bl2)) continue;
                        bl4 = true;
                        break;
                    }
                }
                if (!bl4 && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getName(), string, bl, bl2)) {
                    bl4 = true;
                }
                if (!bl4 && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getSymbol(), string, bl, bl2)) {
                    bl4 = true;
                }
                if (!bl4 && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getAccession().getValue(), string, bl, bl2)) {
                    bl4 = true;
                }
                if (!bl4 && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getDomainArchitecture() != null) {
                    object = phylogenyNode.getNodeData().getSequence().getDomainArchitecture();
                    for (int i = 0; i < ((DomainArchitecture)object).getNumberOfDomains(); ++i) {
                        if (!PhylogenyMethods.match(((DomainArchitecture)object).getDomain(i).getName(), string, bl, bl2)) continue;
                        bl4 = true;
                        break;
                    }
                }
                if (!bl4 && phylogenyNode.getNodeData().getBinaryCharacters() != null) {
                    object = phylogenyNode.getNodeData().getBinaryCharacters().getPresentCharacters().iterator();
                    while (object.hasNext()) {
                        if (!PhylogenyMethods.match((String)object.next(), string, bl, bl2)) continue;
                        bl4 = true;
                        break;
                    }
                    object = phylogenyNode.getNodeData().getBinaryCharacters().getGainedCharacters().iterator();
                    while (object.hasNext()) {
                        if (!PhylogenyMethods.match((String)object.next(), string, bl, bl2)) continue;
                        bl4 = true;
                        break;
                    }
                }
                if (bl4) continue;
                bl3 = false;
                break;
            }
            if (!bl3) continue;
            arrayList.add(phylogenyNode);
        }
        return arrayList;
    }

    public static void setBootstrapConfidence(PhylogenyNode phylogenyNode, double d) {
        PhylogenyMethods.setConfidence(phylogenyNode, d, "bootstrap");
    }

    public static void setBranchColorValue(PhylogenyNode phylogenyNode, Color color) {
        if (phylogenyNode.getBranchData().getBranchColor() == null) {
            phylogenyNode.getBranchData().setBranchColor(new BranchColor());
        }
        phylogenyNode.getBranchData().getBranchColor().setValue(color);
    }

    public static void setBranchWidthValue(PhylogenyNode phylogenyNode, double d) {
        phylogenyNode.getBranchData().setBranchWidth(new BranchWidth(d));
    }

    public static void setConfidence(PhylogenyNode phylogenyNode, double d) {
        PhylogenyMethods.setConfidence(phylogenyNode, d, "");
    }

    public static void setConfidence(PhylogenyNode phylogenyNode, double d, String string) {
        Confidence confidence = null;
        if (phylogenyNode.getBranchData().getNumberOfConfidences() > 0) {
            confidence = phylogenyNode.getBranchData().getConfidence(0);
        } else {
            confidence = new Confidence();
            phylogenyNode.getBranchData().addConfidence(confidence);
        }
        confidence.setType(string);
        confidence.setValue(d);
    }

    public static void setScientificName(PhylogenyNode phylogenyNode, String string) {
        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
        }
        phylogenyNode.getNodeData().getTaxonomy().setScientificName(string);
    }

    public static void setTaxonomyCode(PhylogenyNode phylogenyNode, String string) throws PhyloXmlDataFormatException {
        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
        }
        phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode(string);
    }

    public static int taxonomyBasedDeletionOfExternalNodes(Phylogeny phylogeny, Phylogeny phylogeny2) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        Iterator<PhylogenyNode> iterator = phylogeny.iteratorExternalForward();
        while (iterator.hasNext()) {
            hashSet.add(PhylogenyMethods.getSpecies(iterator.next()));
        }
        iterator = phylogeny2.iteratorExternalForward();
        while (iterator.hasNext()) {
            PhylogenyNode phylogenyNode = iterator.next();
            if (hashSet.contains(PhylogenyMethods.getSpecies(phylogenyNode))) continue;
            arrayList.add(phylogenyNode);
        }
        for (PhylogenyNode phylogenyNode : arrayList) {
            phylogeny2.deleteSubtree(phylogenyNode, true);
        }
        phylogeny2.clearHashIdToNodeMap();
        phylogeny2.externalNodesHaveChanged();
        return arrayList.size();
    }

    public static void orderAppearance(PhylogenyNode phylogenyNode, boolean bl, boolean bl2, DESCENDANT_SORT_PRIORITY dESCENDANT_SORT_PRIORITY) {
        int n;
        if (phylogenyNode.isExternal()) {
            return;
        }
        PhylogenyNode phylogenyNode2 = null;
        if (phylogenyNode.getNumberOfDescendants() == 2 && phylogenyNode.getChildNode1().getNumberOfExternalNodes() != phylogenyNode.getChildNode2().getNumberOfExternalNodes() && phylogenyNode.getChildNode1().getNumberOfExternalNodes() < phylogenyNode.getChildNode2().getNumberOfExternalNodes() == bl) {
            phylogenyNode2 = phylogenyNode.getChildNode1();
            phylogenyNode.setChild1(phylogenyNode.getChildNode2());
            phylogenyNode.setChild2(phylogenyNode2);
        } else if (bl2) {
            n = 1;
            for (PhylogenyNode phylogenyNode3 : phylogenyNode.getDescendants()) {
                if (phylogenyNode3.isExternal()) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                PhylogenyMethods.sortNodeDescendents(phylogenyNode, dESCENDANT_SORT_PRIORITY);
            }
        }
        for (n = 0; n < phylogenyNode.getNumberOfDescendants(); ++n) {
            PhylogenyMethods.orderAppearance(phylogenyNode.getChildNode(n), bl, bl2, dESCENDANT_SORT_PRIORITY);
        }
    }

    public static enum DESCENDANT_SORT_PRIORITY {
        TAXONOMY,
        SEQUENCE,
        NODE_NAME;

    }

    public static enum TAXONOMY_EXTRACTION {
        NO,
        YES,
        PFAM_STYLE_ONLY;

    }

    public static enum PhylogenyNodeField {
        CLADE_NAME,
        TAXONOMY_CODE,
        TAXONOMY_SCIENTIFIC_NAME,
        TAXONOMY_COMMON_NAME,
        SEQUENCE_SYMBOL,
        SEQUENCE_NAME,
        TAXONOMY_ID_UNIPROT_1,
        TAXONOMY_ID_UNIPROT_2,
        TAXONOMY_ID;

    }
}

