/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDI;
import org.forester.sdi.SDIException;
import org.forester.util.ForesterUtil;

public final class GSDI
extends SDI {
    private final boolean _most_parsimonious_duplication_model;
    private final boolean _strip_gene_tree;
    private final boolean _strip_species_tree;
    private int _speciation_or_duplication_events_sum = 0;
    private int _speciations_sum = 0;
    private final List<PhylogenyNode> _stripped_gene_tree_nodes;
    private final List<PhylogenyNode> _stripped_species_tree_nodes;
    private final Set<PhylogenyNode> _mapped_species_tree_nodes;
    private SDI.TaxonomyComparisonBase _tax_comp_base;
    private final SortedSet<String> _scientific_names_mapped_to_reduced_specificity;

    public GSDI(Phylogeny phylogeny, Phylogeny phylogeny2, boolean bl, boolean bl2, boolean bl3) throws SDIException {
        super(phylogeny, phylogeny2);
        this._most_parsimonious_duplication_model = bl;
        this._duplications_sum = 0;
        this._strip_gene_tree = bl2;
        this._strip_species_tree = bl3;
        this._stripped_gene_tree_nodes = new ArrayList<PhylogenyNode>();
        this._stripped_species_tree_nodes = new ArrayList<PhylogenyNode>();
        this._mapped_species_tree_nodes = new HashSet<PhylogenyNode>();
        this._scientific_names_mapped_to_reduced_specificity = new TreeSet<String>();
        this.linkNodesOfG();
        this.getSpeciesTree().preOrderReId();
        this.geneTreePostOrderTraversal();
    }

    GSDI(Phylogeny phylogeny, Phylogeny phylogeny2, boolean bl) throws SDIException {
        this(phylogeny, phylogeny2, bl, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private final void determineEvent(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        boolean bl = false;
        if (phylogenyNode2.getChildNode1().getLink() == phylogenyNode || phylogenyNode2.getChildNode2().getLink() == phylogenyNode) {
            bl = true;
        }
        if (phylogenyNode2.getLink().getNumberOfDescendants() == 2) {
            if (bl) {
                phylogenyNode2.getNodeData().setEvent(this.createDuplicationEvent());
            } else {
                phylogenyNode2.getNodeData().setEvent(this.createSpeciationEvent());
            }
        } else if (bl) {
            HashSet<void> hashSet = new HashSet<void>();
            for (PhylogenyNode phylogenyNode3 : phylogenyNode2.getChildNode1().getAllExternalDescendants()) {
                PhylogenyNode phylogenyNode4;
                void object;
                PhylogenyNode phylogenyNode5 = phylogenyNode3.getLink();
                while (object.getParent() != phylogenyNode && !(phylogenyNode4 = object.getParent()).isRoot()) {
                }
                hashSet.add(object);
            }
            boolean bl2 = false;
            for (PhylogenyNode phylogenyNode6 : phylogenyNode2.getChildNode2().getAllExternalDescendants()) {
                phylogenyNode6 = phylogenyNode6.getLink();
                while (phylogenyNode6.getParent() != phylogenyNode && !(phylogenyNode6 = phylogenyNode6.getParent()).isRoot()) {
                }
                if (!hashSet.contains(phylogenyNode6)) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                phylogenyNode2.getNodeData().setEvent(this.createDuplicationEvent());
            } else if (this._most_parsimonious_duplication_model) {
                phylogenyNode2.getNodeData().setEvent(this.createSpeciationEvent());
            } else {
                phylogenyNode2.getNodeData().setEvent(this.createSingleSpeciationOrDuplicationEvent());
            }
        } else {
            phylogenyNode2.getNodeData().setEvent(this.createSpeciationEvent());
        }
    }

    final void geneTreePostOrderTraversal() {
        PhylogenyNodeIterator phylogenyNodeIterator = this.getGeneTree().iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isInternal()) continue;
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode1().getLink();
            PhylogenyNode phylogenyNode3 = phylogenyNode.getChildNode2().getLink();
            while (phylogenyNode2 != phylogenyNode3) {
                if (phylogenyNode2.getId() > phylogenyNode3.getId()) {
                    phylogenyNode2 = phylogenyNode2.getParent();
                    continue;
                }
                phylogenyNode3 = phylogenyNode3.getParent();
            }
            phylogenyNode.setLink(phylogenyNode2);
            this.determineEvent(phylogenyNode2, phylogenyNode);
        }
    }

    private final Event createDuplicationEvent() {
        Event event = Event.createSingleDuplicationEvent();
        ++this._duplications_sum;
        return event;
    }

    private final Event createSingleSpeciationOrDuplicationEvent() {
        Event event = Event.createSingleSpeciationOrDuplicationEvent();
        ++this._speciation_or_duplication_events_sum;
        return event;
    }

    private final Event createSpeciationEvent() {
        Event event = Event.createSingleSpeciationEvent();
        ++this._speciations_sum;
        return event;
    }

    public final int getSpeciationOrDuplicationEventsSum() {
        return this._speciation_or_duplication_events_sum;
    }

    public final int getSpeciationsSum() {
        return this._speciations_sum;
    }

    @Override
    final void linkNodesOfG() throws SDIException {
        String string;
        PhylogenyNode phylogenyNode;
        HashMap<String, PhylogenyNode> hashMap = new HashMap<String, PhylogenyNode>();
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        this._tax_comp_base = GSDI.determineTaxonomyComparisonBase(this._gene_tree);
        PhylogenyNodeIterator phylogenyNodeIterator = this._species_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            arrayList.add(phylogenyNode);
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(string = GSDI.taxonomyToString(phylogenyNode, this._tax_comp_base))) continue;
            if (hashMap.containsKey(string)) {
                throw new SDIException("taxonomy \"" + phylogenyNode + "\" is not unique in species tree");
            }
            hashMap.put(string, phylogenyNode);
        }
        phylogenyNodeIterator = this._gene_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                if (this._strip_gene_tree) {
                    this._stripped_gene_tree_nodes.add(phylogenyNode);
                    continue;
                }
                throw new SDIException("gene tree node \"" + phylogenyNode + "\" has no taxonomic data");
            }
            string = GSDI.taxonomyToString(phylogenyNode, this._tax_comp_base);
            if (ForesterUtil.isEmpty(string)) {
                if (this._strip_gene_tree) {
                    this._stripped_gene_tree_nodes.add(phylogenyNode);
                    continue;
                }
                throw new SDIException("gene tree node \"" + phylogenyNode + "\" has no appropriate taxonomic data");
            }
            PhylogenyNode phylogenyNode2 = (PhylogenyNode)hashMap.get(string);
            if (this._tax_comp_base == SDI.TaxonomyComparisonBase.SCIENTIFIC_NAME && phylogenyNode2 == null && ForesterUtil.countChars(string, ' ') > 1) {
                phylogenyNode2 = this.tryMapByRemovingOverlySpecificData(hashMap, string);
            }
            if (phylogenyNode2 == null) {
                if (this._strip_gene_tree) {
                    this._stripped_gene_tree_nodes.add(phylogenyNode);
                    continue;
                }
                throw new SDIException("taxonomy \"" + phylogenyNode.getNodeData().getTaxonomy() + "\" not present in species tree");
            }
            phylogenyNode.setLink(phylogenyNode2);
            this._mapped_species_tree_nodes.add(phylogenyNode2);
        }
        if (this._strip_gene_tree) {
            this.stripGeneTree();
            if (this.getGeneTree().isEmpty() || this.getGeneTree().getNumberOfExternalNodes() < 2) {
                throw new SDIException("species could not be mapped between gene tree and species tree");
            }
        }
        if (this._strip_species_tree) {
            this.stripSpeciesTree(arrayList);
        }
    }

    private final PhylogenyNode tryMapByRemovingOverlySpecificData(Map<String, PhylogenyNode> map, String string) {
        String[] stringArray;
        PhylogenyNode phylogenyNode = this.tryMapByRemovingOverlySpecificData(map, string, " (");
        if (phylogenyNode == null && ForesterUtil.countChars(string, ' ') == 2 && (phylogenyNode = map.get(stringArray = string.substring(0, string.lastIndexOf(32)).trim())) != null) {
            this.addScientificNamesMappedToReducedSpecificity(string, (String)stringArray);
        }
        if (phylogenyNode == null) {
            String string2;
            stringArray = new String[]{" subspecies ", " strain ", " variety ", " varietas ", " subvariety ", " form ", " subform ", " cultivar ", " section ", " subsection "};
            int n = stringArray.length;
            for (int i = 0; i < n && (phylogenyNode = this.tryMapByRemovingOverlySpecificData(map, string, string2 = stringArray[i])) == null; ++i) {
            }
        }
        return phylogenyNode;
    }

    private final PhylogenyNode tryMapByRemovingOverlySpecificData(Map<String, PhylogenyNode> map, String string, String string2) {
        int n = string.indexOf(string2);
        if (n > 4) {
            String string3 = string.substring(0, n).trim();
            PhylogenyNode phylogenyNode = map.get(string3);
            if (phylogenyNode != null) {
                this.addScientificNamesMappedToReducedSpecificity(string, string3);
            }
            return phylogenyNode;
        }
        return null;
    }

    private final void addScientificNamesMappedToReducedSpecificity(String string, String string2) {
        this._scientific_names_mapped_to_reduced_specificity.add(string + " -> " + string2);
    }

    public final SortedSet<String> getReMappedScientificNamesFromGeneTree() {
        return this._scientific_names_mapped_to_reduced_specificity;
    }

    public SDI.TaxonomyComparisonBase getTaxCompBase() {
        return this._tax_comp_base;
    }

    private void stripSpeciesTree(List<PhylogenyNode> list) {
        for (PhylogenyNode phylogenyNode : list) {
            if (this._mapped_species_tree_nodes.contains(phylogenyNode)) continue;
            this._species_tree.deleteSubtree(phylogenyNode, true);
            this._stripped_species_tree_nodes.add(phylogenyNode);
        }
        this._species_tree.clearHashIdToNodeMap();
        this._species_tree.externalNodesHaveChanged();
    }

    public List<PhylogenyNode> getStrippedSpeciesTreeNodes() {
        return this._stripped_species_tree_nodes;
    }

    private void stripGeneTree() {
        for (PhylogenyNode phylogenyNode : this._stripped_gene_tree_nodes) {
            this._gene_tree.deleteSubtree(phylogenyNode, true);
        }
        this._gene_tree.clearHashIdToNodeMap();
        this._gene_tree.externalNodesHaveChanged();
    }

    public Set<PhylogenyNode> getMappedExternalSpeciesTreeNodes() {
        return this._mapped_species_tree_nodes;
    }

    public static SDI.TaxonomyComparisonBase determineTaxonomyComparisonBase(Phylogeny phylogeny) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) continue;
            Taxonomy taxonomy = phylogenyNode.getNodeData().getTaxonomy();
            if (taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()) && ++n > n4) {
                n4 = n;
            }
            if (!ForesterUtil.isEmpty(taxonomy.getTaxonomyCode()) && ++n2 > n4) {
                n4 = n2;
            }
            if (ForesterUtil.isEmpty(taxonomy.getScientificName()) || ++n3 <= n4) continue;
            n4 = n3;
        }
        if (n4 == 0) {
            throw new IllegalArgumentException("gene tree has no taxonomic data");
        }
        if (n4 == 1) {
            throw new IllegalArgumentException("gene tree has only one node with taxonomic data");
        }
        if (n4 == n) {
            return SDI.TaxonomyComparisonBase.ID;
        }
        if (n4 == n3) {
            return SDI.TaxonomyComparisonBase.SCIENTIFIC_NAME;
        }
        return SDI.TaxonomyComparisonBase.CODE;
    }

    public List<PhylogenyNode> getStrippedExternalGeneTreeNodes() {
        return this._stripped_gene_tree_nodes;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Most parsimonious duplication model: " + this._most_parsimonious_duplication_model);
        stringBuffer.append(ForesterUtil.getLineSeparator());
        stringBuffer.append("Speciations sum                    : " + this.getSpeciationsSum());
        stringBuffer.append(ForesterUtil.getLineSeparator());
        stringBuffer.append("Duplications sum                   : " + this.getDuplicationsSum());
        stringBuffer.append(ForesterUtil.getLineSeparator());
        if (!this._most_parsimonious_duplication_model) {
            stringBuffer.append("Speciation or duplications sum     : " + this.getSpeciationOrDuplicationEventsSum());
            stringBuffer.append(ForesterUtil.getLineSeparator());
        }
        stringBuffer.append("mapping cost L                     : " + this.computeMappingCostL());
        return stringBuffer.toString();
    }
}

