/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.phylogeny.data.Identifier;
import org.forester.util.ForesterUtil;

public final class SequenceIdParser {
    private static final Pattern GENBANK_NUCLEOTIDE_AC_PATTERN_1 = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]\\d{5})(?:[^a-zA-Z0-9]|\\Z)");
    private static final Pattern GENBANK_NUCLEOTIDE_AC_PATTERN_2 = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]{2}\\d{6})(?:[^a-zA-Z0-9]|\\Z)");
    private static final Pattern GENBANK_PROTEIN_AC_PATTERN = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]{3}\\d{5})(?:[^a-zA-Z0-9]|\\Z)");
    private static final Pattern REFSEQ_PATTERN = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]{2}_\\d{6,})(?:[^a-zA-Z0-9]|\\Z)");

    public static final Identifier parse(String string) {
        String string2 = SequenceIdParser.parseGenbankAccessor(string);
        if (!ForesterUtil.isEmpty(string2)) {
            return new Identifier(string2, "ncbi");
        }
        string2 = SequenceIdParser.parseRefSeqAccessor(string);
        if (!ForesterUtil.isEmpty(string2)) {
            return new Identifier(string2, "refseq");
        }
        return null;
    }

    public static String parseGenbankAccessor(String string) {
        Matcher matcher = GENBANK_NUCLEOTIDE_AC_PATTERN_1.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        matcher = GENBANK_NUCLEOTIDE_AC_PATTERN_2.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        matcher = GENBANK_PROTEIN_AC_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        return null;
    }

    private static final String parseRefSeqAccessor(String string) {
        Matcher matcher = REFSEQ_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        return null;
    }

    private SequenceIdParser() {
    }
}

