/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.wabi;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.forester.ws.wabi.RestUtil;

public final class TxSearch {
    private static final String TAXONOMIC_RANK = "Taxonomic rank: ";
    private static final String FULL_LINEAGE = "Full lineage: ";
    private static final String SEARCH_LINEAGE_QUERY_PARAM_NAME = "query";
    private static final String SEARCH_LINEAGE_RANKS_PARAM_NAME = "ranks";
    private static final String SEARCH_LINEAGE_SUPERKINGDOM_PARAM_NAME = "superkingdom";
    private static final String GET_TX_ID_METHOD_NAME = "getTxId";
    private static final String GET_TX_NAME_METHOD_NAME = "getTxName";
    private static final String SEARCH_SIMPLE_METHOD_NAME = "searchSimple";
    private static final String TX_SEARCH_SERVICE_NAME = "TxSearch";
    private static final String TX_NAME_PARAM_NAME = "tx_Name";
    private static final String TX_ID_PARAM_NAME = "tx_Id";
    private static final String SEARCH_LINEAGE_NAME_METHOD_NAME = "searchLineage";
    private static final String SEARCH_PARAM_METHOD_NAME = "searchParam";

    public static String[] getLineage(String string) throws IOException {
        String[] stringArray = null;
        for (String string2 : string.split("\n")) {
            if (!(string2 = string2.trim()).startsWith(FULL_LINEAGE)) continue;
            if (stringArray != null) {
                throw new IOException("search result is not unique");
            }
            stringArray = string2.substring(FULL_LINEAGE.length()).split(";");
        }
        return stringArray;
    }

    public static String getTaxonomicRank(String string) throws IOException {
        String string2 = null;
        for (String string3 : string.split("\n")) {
            if (!(string3 = string3.trim()).startsWith(TAXONOMIC_RANK)) continue;
            if (string2 != null) {
                throw new IOException("search result is not unique");
            }
            string2 = string3.substring(TAXONOMIC_RANK.length()).trim();
        }
        return string2;
    }

    public static String getTxId(String string) throws IOException {
        return RestUtil.getResult(TX_SEARCH_SERVICE_NAME, GET_TX_ID_METHOD_NAME, "tx_Name=" + RestUtil.encode(string)).trim();
    }

    public static String getTxName(String string) throws IOException {
        return RestUtil.getResult(TX_SEARCH_SERVICE_NAME, GET_TX_NAME_METHOD_NAME, "tx_Id=" + RestUtil.encode(string)).trim();
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "";
        try {
            string = TxSearch.searchSimple("SAMSA");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        System.out.println("---------------");
        try {
            string = TxSearch.searchSimple("nematostella");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        String[] stringArray2 = TxSearch.getLineage(string);
        for (String string2 : stringArray2) {
            System.out.println(string2);
        }
        System.out.println(TxSearch.getTaxonomicRank(string));
        System.out.println("---------------");
        try {
            string = TxSearch.getTxId("nematostella");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        System.out.println("---------------");
        try {
            string = TxSearch.getTxName("45350");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        System.out.println("---------------");
        ArrayList arrayList = new ArrayList();
        arrayList.add("Campylobacter coli");
        arrayList.add("Escherichia coli");
        arrayList.add("Arabidopsis");
        arrayList.add("Trichoplax");
        arrayList.add("Samanea saman");
        arrayList.add("Kluyveromyces marxianus");
        arrayList.add("Bacillus subtilis subsp. subtilis str. N170");
        arrayList.add("Bornavirus parrot/PDD/2008");
        ArrayList<RANKS> arrayList2 = new ArrayList<RANKS>();
        arrayList2.add(RANKS.ALL);
        try {
            string = TxSearch.searchLineage(arrayList, arrayList2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        System.out.println("---------------");
        try {
            string = TxSearch.searchParam("Homo sapiens", TAX_NAME_CLASS.ALL, TAX_RANK.SPECIES, 10, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        System.out.println("---------------");
        try {
            string = TxSearch.searchParam("Samanea saman", TAX_NAME_CLASS.SCIENTIFIC_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        System.out.println("---------------");
        try {
            string = TxSearch.searchParam("cow", TAX_NAME_CLASS.COMMON_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        System.out.println("---------------");
        try {
            string = TxSearch.searchParam("Helicogloea lagerheimii", TAX_NAME_CLASS.SCIENTIFIC_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        System.out.println("---------------");
        try {
            string = TxSearch.searchParam("Cronartium ribicola", TAX_NAME_CLASS.SCIENTIFIC_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        System.out.println("---------------");
        try {
            string = TxSearch.searchParam("Peridermium harknessii", TAX_NAME_CLASS.SCIENTIFIC_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
        System.out.println("---------------");
        try {
            string = TxSearch.searchParam("Eukaryota", TAX_NAME_CLASS.SCIENTIFIC_NAME, TAX_RANK.ALL, 10, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println(string);
    }

    private static String ranksAsString(List<RANKS> list) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        for (RANKS rANKS : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("%0A");
            }
            stringBuffer.append(RestUtil.encode(rANKS.toString()));
        }
        return stringBuffer.toString();
    }

    public static String searchLineage(List<String> list, List<RANKS> list2) throws IOException {
        return TxSearch.searchLineage(list, list2, "");
    }

    public static String searchLineage(List<String> list, List<RANKS> list2, String string) throws IOException {
        return RestUtil.getResult(TX_SEARCH_SERVICE_NAME, SEARCH_LINEAGE_NAME_METHOD_NAME, "query=" + RestUtil.listAsString(list) + "&" + SEARCH_LINEAGE_RANKS_PARAM_NAME + "=" + TxSearch.ranksAsString(list2) + "&" + SEARCH_LINEAGE_SUPERKINGDOM_PARAM_NAME + "=" + RestUtil.encode(string)).trim();
    }

    public static String searchParam(String string, TAX_NAME_CLASS tAX_NAME_CLASS, TAX_RANK tAX_RANK, int n, boolean bl) throws IOException {
        String string2 = "no";
        if (bl) {
            string2 = "yes";
        }
        if (n < 1) {
            n = 1;
        }
        return RestUtil.getResult(TX_SEARCH_SERVICE_NAME, SEARCH_PARAM_METHOD_NAME, "tx_Name=" + RestUtil.encode(string) + "&tx_Clas=" + RestUtil.encode(tAX_NAME_CLASS.toString()) + "&tx_Rank=" + RestUtil.encode(tAX_RANK.toString()) + "&tx_Rmax=" + n + "&tx_Dcls=" + string2).trim();
    }

    public static String searchSimple(String string) throws IOException {
        return RestUtil.getResult(TX_SEARCH_SERVICE_NAME, SEARCH_SIMPLE_METHOD_NAME, "tx_Name=" + RestUtil.encode(string)).trim();
    }

    public static enum TAX_RANK {
        ALL("All"),
        NO_RANK("no rank"),
        SUPERKINGDOM("superkingdom"),
        KINGDOM("kingdom"),
        SUBKINGDOM("subkingdom"),
        SUPERPHYLUM("superphylum"),
        PHYLUM("phylum"),
        SUBPHYLUM("subphylum"),
        SUPERCLASS("superclass"),
        CLASS("class"),
        SUBCLASS("subclass"),
        INFRACLASS("infraclass"),
        SUPERORDER("superorder"),
        ORDER("order"),
        SUBORDER("suborder"),
        INFRAORDER("infraorder"),
        PARVORDER("parvorder"),
        SUPERFAMILY("superfamily"),
        FAMILY("family"),
        SUBFAMILY("subfamily"),
        TRIBE("tribe"),
        SUBTRIBE("subtribe"),
        GENUS("genus"),
        SUBGENUS("subgenus"),
        SPECIES_GROUP("species group"),
        SPECIES_SUBGROUP("species subgroup"),
        SPECIES("species"),
        SUBSPECIES("subspecies"),
        VARIETAS("varietas"),
        FORMA("forma");

        private final String _str;

        private TAX_RANK(String string2) {
            this._str = string2;
        }

        public String toString() {
            return this._str;
        }
    }

    public static enum TAX_NAME_CLASS {
        ALL("all"),
        SCIENTIFIC_NAME("scientific name"),
        PREFFERED_COMMON_NAME("preferred common name"),
        COMMON_NAME("common name"),
        SYNONYM("synonym");

        private final String _str;

        private TAX_NAME_CLASS(String string2) {
            this._str = string2;
        }

        public String toString() {
            return this._str;
        }
    }

    public static enum RANKS {
        ALL("all"),
        SUPERKINGDOM("superkingdom"),
        KINGDOM("kingdom"),
        SUBKINGDOM("subkingdom"),
        SUPERPHYLUM("superphylum"),
        PHYLUM("phylum"),
        SUBPHYLUM("subphylum"),
        SUPERCLASS("superclass"),
        CLASS("class"),
        SUBCLASS("subclass"),
        INFRACLASS("infraclass"),
        SUPERORDER("superorder"),
        ORDER("order"),
        SUBORDER("suborder"),
        INFRAORDER("infraorder"),
        PARVORDER("parvorder"),
        SUPERFAMILY("superfamily"),
        FAMILY("family"),
        SUBFAMILY("subfamily"),
        TRIBE("tribe"),
        SUBTRIBE("subtribe"),
        GENUS("genus"),
        SPECIES("species");

        private final String _str;

        private RANKS(String string2) {
            this._str = string2;
        }

        public String toString() {
            return this._str;
        }
    }
}

