/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.HilbertSpace;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.Double2Vector;
import JSci.maths.vectors.VectorDimensionException;

public final class Complex2Vector
extends AbstractComplexVector {
    protected double xre;
    protected double xim;
    protected double yre;
    protected double yim;

    public Complex2Vector() {
        super(2);
    }

    public Complex2Vector(Complex complex, Complex complex2) {
        this();
        this.xre = complex.real();
        this.xim = complex.imag();
        this.yre = complex2.real();
        this.yim = complex2.imag();
    }

    public Complex2Vector(double d, double d2, double d3, double d4) {
        this();
        this.xre = d;
        this.xim = d2;
        this.yre = d3;
        this.yim = d4;
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof Complex2Vector) {
            Complex2Vector complex2Vector = (Complex2Vector)object;
            double d2 = this.xre - complex2Vector.xre;
            double d3 = this.xim - complex2Vector.xim;
            double d4 = this.yre - complex2Vector.yre;
            double d5 = this.yim - complex2Vector.yim;
            return d2 * d2 + d3 * d3 + d4 * d4 + d5 * d5 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(Complex.toString(this.xre, this.xim)).append(',').append(Complex.toString(this.yre, this.yim));
        return stringBuffer.toString();
    }

    public AbstractDoubleVector real() {
        return new Double2Vector(this.xre, this.yre);
    }

    public AbstractDoubleVector imag() {
        return new Double2Vector(this.xim, this.yim);
    }

    public Complex getComponent(int n) {
        switch (n) {
            case 0: {
                return new Complex(this.xre, this.xim);
            }
            case 1: {
                return new Complex(this.yre, this.yim);
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public double getRealComponent(int n) {
        switch (n) {
            case 0: {
                return this.xre;
            }
            case 1: {
                return this.yre;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public double getImagComponent(int n) {
        switch (n) {
            case 0: {
                return this.xim;
            }
            case 1: {
                return this.yim;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, Complex complex) {
        switch (n) {
            case 0: {
                this.xre = complex.real();
                this.xim = complex.imag();
                break;
            }
            case 1: {
                this.yre = complex.real();
                this.yim = complex.imag();
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    public void setComponent(int n, double d, double d2) {
        switch (n) {
            case 0: {
                this.xre = d;
                this.xim = d2;
                break;
            }
            case 1: {
                this.yre = d;
                this.yim = d2;
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    public double norm() {
        return Math.sqrt(this.xre * this.xre + this.xim * this.xim + this.yre * this.yre + this.yim * this.yim);
    }

    public double infNorm() {
        double d = this.xre * this.xre + this.xim * this.xim;
        double d2 = 0.0;
        if (d > d2) {
            d2 = d;
        }
        if ((d = this.yre * this.yre + this.yim * this.yim) > d2) {
            d2 = d;
        }
        return Math.sqrt(d2);
    }

    public AbelianGroup.Member negate() {
        return new Complex2Vector(-this.xre, -this.xim, -this.yre, -this.yim);
    }

    public AbstractComplexVector conjugate() {
        return new Complex2Vector(this.xre, -this.xim, this.yre, -this.yim);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractComplexVector) {
            return this.add((AbstractComplexVector)member);
        }
        if (member instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)member);
        }
        if (member instanceof AbstractIntegerVector) {
            return this.add((AbstractIntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector add(AbstractComplexVector abstractComplexVector) {
        if (abstractComplexVector.N == 2) {
            return new Complex2Vector(this.xre + abstractComplexVector.getComponent(0).real(), this.xim + abstractComplexVector.getComponent(0).imag(), this.yre + abstractComplexVector.getComponent(1).real(), this.yim + abstractComplexVector.getComponent(1).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector.N == 2) {
            return new Complex2Vector(this.xre + abstractDoubleVector.getComponent(0), this.xim, this.yre + abstractDoubleVector.getComponent(1), this.yim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector.N == 2) {
            return new Complex2Vector(this.xre + (double)abstractIntegerVector.getComponent(0), this.xim, this.yre + (double)abstractIntegerVector.getComponent(1), this.yim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractComplexVector) {
            return this.subtract((AbstractComplexVector)member);
        }
        if (member instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)member);
        }
        if (member instanceof AbstractIntegerVector) {
            return this.subtract((AbstractIntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector subtract(AbstractComplexVector abstractComplexVector) {
        if (abstractComplexVector.N == 2) {
            return new Complex2Vector(this.xre - abstractComplexVector.getComponent(0).real(), this.xim - abstractComplexVector.getComponent(0).imag(), this.yre - abstractComplexVector.getComponent(1).real(), this.yim - abstractComplexVector.getComponent(1).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector.N == 2) {
            return new Complex2Vector(this.xre - abstractDoubleVector.getComponent(0), this.xim, this.yre - abstractDoubleVector.getComponent(1), this.yim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector.N == 2) {
            return new Complex2Vector(this.xre - (double)abstractIntegerVector.getComponent(0), this.xim, this.yre - (double)abstractIntegerVector.getComponent(1), this.yim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Complex) {
            return this.scalarMultiply((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        return new Complex2Vector(this.xre * d - this.xim * d2, this.xre * d2 + this.xim * d, this.yre * d - this.yim * d2, this.yre * d2 + this.yim * d);
    }

    public AbstractComplexVector scalarMultiply(double d) {
        return new Complex2Vector(d * this.xre, d * this.xim, d * this.yre, d * this.yim);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof Complex) {
            return this.scalarDivide((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector scalarDivide(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        if (Math.abs(d) < Math.abs(d2)) {
            double d3 = d / d2;
            double d4 = d * d3 + d2;
            return new Complex2Vector((this.xre * d3 + this.xim) / d4, (this.xim * d3 - this.xre) / d4, (this.yre * d3 + this.yim) / d4, (this.yim * d3 - this.yre) / d4);
        }
        double d5 = d2 / d;
        double d6 = d + d2 * d5;
        return new Complex2Vector((this.xre + this.xim * d5) / d6, (this.xim - this.xre * d5) / d6, (this.yre + this.yim * d5) / d6, (this.yim - this.yre * d5) / d6);
    }

    public AbstractComplexVector scalarDivide(double d) {
        return new Complex2Vector(this.xre / d, this.xim / d, this.yre / d, this.yim / d);
    }

    public Complex scalarProduct(HilbertSpace.Member member) {
        if (member instanceof AbstractComplexVector) {
            return this.scalarProduct((AbstractComplexVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex scalarProduct(AbstractComplexVector abstractComplexVector) {
        if (abstractComplexVector instanceof Complex2Vector) {
            return this.scalarProduct((Complex2Vector)abstractComplexVector);
        }
        if (abstractComplexVector.N == 2) {
            return new Complex(this.xre * abstractComplexVector.getComponent(0).real() + this.xim * abstractComplexVector.getComponent(0).imag() + this.yre * abstractComplexVector.getComponent(1).real() + this.yim * abstractComplexVector.getComponent(1).imag(), this.xim * abstractComplexVector.getComponent(0).real() - this.xre * abstractComplexVector.getComponent(0).imag() + this.yim * abstractComplexVector.getComponent(1).real() - this.yre * abstractComplexVector.getComponent(1).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Complex scalarProduct(Complex2Vector complex2Vector) {
        return new Complex(this.xre * complex2Vector.xre + this.xim * complex2Vector.xim + this.yre * complex2Vector.yre + this.yim * complex2Vector.yim, this.xim * complex2Vector.xre - this.xre * complex2Vector.xim + this.yim * complex2Vector.yre - this.yre * complex2Vector.yim);
    }

    public AbstractComplexVector mapComponents(ComplexMapping complexMapping) {
        return new Complex2Vector(complexMapping.map(this.xre, this.xim), complexMapping.map(this.yre, this.yim));
    }
}

