/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.NumericalConstants;
import JSci.maths.wavelet.MultiscaleFunction;

public final class Sine
extends MultiscaleFunction
implements NumericalConstants,
Cloneable {
    private int n0;
    private int freq;
    private double normalisation;

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][freq=");
        string.concat(Integer.toString(this.freq));
        string.concat("]");
        return string;
    }

    public Sine(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The length paramenter " + n + " must be positive");
        }
        if (n2 < 0 || n2 >= n) {
            throw new IllegalArgumentException("The frequency parameter " + n2 + " must be between " + 0 + " and " + (n - 1));
        }
        this.n0 = n;
        this.freq = n2;
        this.normalisation = Math.sqrt((double)this.n0 / 2.0);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Sine) {
            Sine sine = (Sine)object;
            return this.dimension(0) == sine.dimension(0) && this.getFrequency() == sine.getFrequency();
        }
        return false;
    }

    public int getFrequency() {
        return this.freq;
    }

    public double[] evaluate() {
        return ArrayMath.scalarMultiply(1.0 / this.normalisation, Sine.evaluate(this.n0, this.freq));
    }

    private static double[] evaluate(int n, int n2) {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.sin(Math.PI * 2 * (double)i * (double)n2 / (double)n);
        }
        return dArray;
    }

    public int dimension(int n) {
        return this.n0;
    }

    public int dimension() {
        return this.n0;
    }

    public Object clone() {
        Sine sine = (Sine)super.clone();
        sine.n0 = this.n0;
        sine.freq = this.freq;
        return sine;
    }

    public double[] evaluate(int n) {
        return this.evaluate();
    }

    public double mass(double d, double d2, int n) {
        double d3 = 0.0;
        double[] dArray = this.evaluate(n);
        for (int i = 0; i < dArray.length; ++i) {
            d3 += dArray[i];
        }
        d3 = d3 / (double)(dArray.length - 1) * Math.abs(d2 - d);
        return d3;
    }

    public int getFilterType() {
        return this.n0;
    }
}

