/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.util.TreeSet;
import spoon.Launcher;
import spoon.compiler.ModelBuildingException;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.Query;
import spoon.support.compiler.SnippetCompilationError;
import spoon.support.compiler.jdt.JDTSnippetCompiler;
import spoon.support.reflect.declaration.CtElementImpl;

public class SnippetCompilationHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compileAndReplaceSnippetsIn(CtType<?> c) {
        Factory f = c.getFactory();
        CtType<?> workCopy = c;
        TreeSet<ModifierKind> backup = new TreeSet<ModifierKind>(workCopy.getModifiers());
        workCopy.getModifiers().remove((Object)ModifierKind.PUBLIC);
        try {
            SnippetCompilationHelper.build(f, workCopy.toString());
        }
        finally {
            c.setModifiers(backup);
        }
    }

    public static CtStatement compileStatement(CtCodeSnippetStatement st) throws SnippetCompilationError {
        return SnippetCompilationHelper.internalCompileStatement(st);
    }

    private static CtStatement internalCompileStatement(CtStatement st) {
        Factory f = st.getFactory();
        CtClass<?> w = SnippetCompilationHelper.createWrapper(st, f);
        SnippetCompilationHelper.compile(f, w);
        CtType c = f.Type().get("Wrapper");
        CtMethod wrapper = (CtMethod)Query.getElements(c, new Filter<CtMethod<?>>(){

            public Class<CtMethod<?>> getType() {
                try {
                    return Class.forName(CtMethod.class.getName());
                }
                catch (Exception e) {
                    Launcher.logger.error(e.getMessage(), e);
                    return null;
                }
            }

            @Override
            public boolean matches(CtMethod<?> element) {
                return element.getSimpleName().equals("wrap");
            }
        }).get(0);
        CtStatement ret = wrapper.getBody().getStatements().get(0);
        c.getPackage().getTypes().remove(c);
        return ret;
    }

    private static CtClass<?> createWrapper(CtStatement st, Factory f) {
        CtClass w = f.Class().create("Wrapper");
        CtBlock body = f.Core().createBlock();
        body.addStatement(st);
        TreeSet<ModifierKind> x = new TreeSet<ModifierKind>();
        f.Method().create(w, x, f.Type().createReference(Void.TYPE), "wrap", CtElementImpl.<CtParameter<?>>EMPTY_LIST(), CtElementImpl.<CtTypeReference<Throwable>>EMPTY_SET(), body);
        return w;
    }

    private static void compile(Factory f, CtType<?> w) throws SnippetCompilationError {
        String contents = w.toString();
        SnippetCompilationHelper.build(f, contents);
    }

    private static void build(Factory f, String contents) {
        JDTSnippetCompiler builder = new JDTSnippetCompiler(f, contents);
        try {
            builder.build();
        }
        catch (Exception e) {
            throw new ModelBuildingException("snippet compilation error while compiling: " + contents, e);
        }
    }

    public static <T> CtExpression<T> compileExpression(CtCodeSnippetExpression<T> expr) throws SnippetCompilationError {
        Factory f = expr.getFactory();
        CtClass<?> w = SnippetCompilationHelper.createWrapper(expr, f);
        String contents = w.toString();
        SnippetCompilationHelper.build(f, contents);
        CtType c = f.Type().get("Wrapper");
        CtMethod wrapper = (CtMethod)Query.getElements(c, new Filter<CtMethod<T>>(){

            public Class<?> getType() {
                return CtMethod.class;
            }

            @Override
            public boolean matches(CtMethod<T> element) {
                return element.getSimpleName().equals("wrap");
            }
        }).get(0);
        CtReturn ret = (CtReturn)wrapper.getBody().getStatements().get(0);
        c.getPackage().getTypes().remove(c);
        return ret.getReturnedExpression();
    }

    private static <R, B extends R> CtClass<?> createWrapper(CtExpression<B> st, Factory f) {
        CtClass w = f.Class().create("Wrapper");
        CtBlock body = f.Core().createBlock();
        CtReturn<B> ret = f.Core().createReturn();
        ret.setReturnedExpression(st);
        body.addStatement(ret);
        TreeSet<ModifierKind> x = new TreeSet<ModifierKind>();
        f.Method().create(w, x, f.Type().createReference(Object.class), "wrap", CtElementImpl.<CtParameter<?>>EMPTY_LIST(), CtElementImpl.<CtTypeReference<Throwable>>EMPTY_SET(), body);
        return w;
    }
}

