/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.SpoonException;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.code.CtExpressionImpl;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtLambdaImpl<T>
extends CtExpressionImpl<T>
implements CtLambda<T> {
    String simpleName;
    CtExpression<T> expression;
    CtBlock<?> body;
    List<CtParameter<?>> parameters = CtLambdaImpl.EMPTY_LIST();
    Set<CtTypeReference<? extends Throwable>> thrownTypes = CtLambdaImpl.EMPTY_SET();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtLambda(this);
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    @Override
    public <B extends T> CtBlock<B> getBody() {
        return this.body;
    }

    @Override
    public <B extends T> void setBody(CtBlock<B> body) {
        if (this.expression != null) {
            throw new SpoonException("A lambda can't have two bodys.");
        }
        this.body = body;
    }

    @Override
    public List<CtParameter<?>> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(List<CtParameter<?>> parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean addParameter(CtParameter<?> parameter) {
        if (this.parameters == CtElementImpl.EMPTY_LIST()) {
            this.parameters = new ArrayList();
        }
        return this.parameters.add(parameter);
    }

    @Override
    public boolean removeParameter(CtParameter<?> parameter) {
        return this.parameters.remove(parameter);
    }

    @Override
    public Set<CtTypeReference<? extends Throwable>> getThrownTypes() {
        return this.thrownTypes;
    }

    @Override
    public void setThrownTypes(Set<CtTypeReference<? extends Throwable>> thrownTypes) {
        this.thrownTypes = thrownTypes;
    }

    @Override
    public boolean addThrownType(CtTypeReference<? extends Throwable> throwType) {
        if (this.thrownTypes == CtElementImpl.EMPTY_SET()) {
            this.thrownTypes = new TreeSet<CtTypeReference<? extends Throwable>>();
        }
        return this.thrownTypes.add(throwType);
    }

    @Override
    public boolean removeThrownType(CtTypeReference<? extends Throwable> throwType) {
        return this.thrownTypes.remove(throwType);
    }

    @Override
    public CtExecutableReference<T> getReference() {
        return this.getFactory().Executable().createReference(this);
    }

    @Override
    public CtExpression<T> getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(CtExpression<T> expression) {
        if (this.body != null) {
            throw new SpoonException("A lambda can't have two bodys.");
        }
        this.expression = expression;
    }
}

