/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import spoon.Launcher;
import spoon.processing.FactoryAccessor;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.ModelConsistencyChecker;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.ReferenceFilter;
import spoon.reflect.visitor.filter.AnnotationFilter;
import spoon.support.reflect.declaration.CtUncomparableException;
import spoon.support.util.RtHelper;
import spoon.support.visitor.SignaturePrinter;
import spoon.support.visitor.TypeReferenceScanner;

public abstract class CtElementImpl
implements CtElement,
Serializable,
Comparable<CtElement> {
    protected static final Logger logger = Logger.getLogger(CtElementImpl.class);
    private static final List<Object> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private static final Set<Object> EMPTY_SET = Collections.unmodifiableSet(new TreeSet());
    private static final long serialVersionUID = 1L;
    transient Factory factory;
    List<CtAnnotation<? extends Annotation>> annotations = CtElementImpl.EMPTY_LIST();
    String docComment;
    CtElement parent;
    SourcePosition position;
    boolean implicit = false;

    public static <T> List<T> EMPTY_LIST() {
        return EMPTY_LIST;
    }

    public static <T> Set<T> EMPTY_SET() {
        return EMPTY_SET;
    }

    public static <T> Collection<T> EMPTY_COLLECTION() {
        return EMPTY_LIST;
    }

    @Override
    public String getSignature() {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        return pr.getSignature();
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    public CtElementImpl() {
        this.setParent(RootElement.ROOT);
    }

    @Override
    public int compareTo(CtElement o) {
        String current = this.getSignature();
        String other = o.getSignature();
        if (current.length() <= 0 || other.length() <= 0) {
            throw new ClassCastException("Unable to compare elements");
        }
        return current.compareTo(other);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CtElement)) {
            return false;
        }
        String current = this.getSignature();
        String other = ((CtElement)o).getSignature();
        return current.equals(other);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        for (CtAnnotation<? extends Annotation> a : this.getAnnotations()) {
            if (!a.getAnnotationType().toString().equals(annotationType.getName())) continue;
            return (A)a.getActualAnnotation();
        }
        return null;
    }

    @Override
    public <A extends Annotation> CtAnnotation<A> getAnnotation(CtTypeReference<A> annotationType) {
        for (CtAnnotation<? extends Annotation> a : this.getAnnotations()) {
            if (!a.getAnnotationType().equals(annotationType)) continue;
            return a;
        }
        return null;
    }

    @Override
    public List<CtAnnotation<? extends Annotation>> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    @Override
    public String getDocComment() {
        return this.docComment;
    }

    public CtElement getParentNoExceptions() {
        if (this.isRootElement()) {
            return null;
        }
        return this.parent;
    }

    @Override
    public CtElement getParent() throws ParentNotInitializedException {
        if (this.parent == null) {
            String exceptionMsg = "";
            exceptionMsg = this instanceof CtNamedElement ? "parent not initialized for " + ((CtNamedElement)((Object)this)).getSimpleName() + (this.getPosition() != null ? " " + this.getPosition() : " (?)") : "parent not initialized for " + this.getClass() + (this.getPosition() != null ? " " + this.getPosition() : " (?)");
            throw new ParentNotInitializedException(exceptionMsg);
        }
        return this.parent;
    }

    @Override
    public boolean isRootElement() {
        return this.parent instanceof RootElement;
    }

    @Override
    public void setRootElement(boolean rootElement) {
        this.parent = rootElement ? RootElement.ROOT : null;
    }

    @Override
    public <P extends CtElement> P getParent(Class<P> parentType) throws ParentNotInitializedException {
        if (this.getParent() == null) {
            return null;
        }
        if (parentType.isAssignableFrom(this.getParent().getClass())) {
            return (P)this.getParent();
        }
        return this.getParent().getParent(parentType);
    }

    @Override
    public boolean hasParent(CtElement candidate) throws ParentNotInitializedException {
        if (this.isRootElement()) {
            return false;
        }
        if (this.getParent() == candidate) {
            return true;
        }
        return this.getParent().hasParent(candidate);
    }

    @Override
    public SourcePosition getPosition() {
        if (this.position != null) {
            return this.position;
        }
        if (this.isParentInitialized() && !this.isRootElement()) {
            return this.getParentNoExceptions().getPosition();
        }
        return null;
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }

    @Override
    public void replace(CtElement element) {
        try {
            this.replaceIn(this, element, this.getParent());
        }
        catch (CtUncomparableException e1) {
        }
        catch (Exception e1) {
            Launcher.logger.error(e1.getMessage(), e1);
        }
    }

    private <T extends FactoryAccessor> void replaceIn(Object toReplace, T replacement, Object parent) throws IllegalArgumentException, IllegalAccessException {
        for (Field f : RtHelper.getAllFields(parent.getClass())) {
            f.setAccessible(true);
            Object tmp = f.get(parent);
            if (tmp == null) continue;
            if (tmp instanceof List) {
                List lst = (List)tmp;
                for (int i = 0; i < lst.size(); ++i) {
                    if (lst.get(i) == null || !this.compare(lst.get(i), toReplace)) continue;
                    lst.remove(i);
                    if (replacement == null) continue;
                    lst.add(i, this.getReplacement(replacement, parent));
                }
                continue;
            }
            if (tmp instanceof Collection) {
                Object[] array;
                Collection collect = (Collection)tmp;
                for (Object obj : array = collect.toArray()) {
                    if (!this.compare(obj, toReplace)) continue;
                    collect.remove(obj);
                    collect.add(this.getReplacement(replacement, parent));
                }
                continue;
            }
            if (!this.compare(tmp, toReplace)) continue;
            f.set(parent, this.getReplacement(replacement, parent));
        }
    }

    private <T extends FactoryAccessor> T getReplacement(T replacement, Object parent) {
        if (replacement instanceof CtElement && parent instanceof CtElement) {
            ((CtElement)replacement).setParent((CtElement)parent);
        }
        return replacement;
    }

    private boolean compare(Object o1, Object o2) {
        return o1 == o2;
    }

    public void replace(Filter<? extends CtElement> replacementPoints, CtElement element) {
        List<? extends CtElement> l = Query.getElements(this, replacementPoints);
        for (CtElement ctElement : l) {
            ctElement.replace(element);
        }
    }

    @Override
    public void setAnnotations(List<CtAnnotation<? extends Annotation>> annotations) {
        this.annotations = annotations;
    }

    @Override
    public boolean addAnnotation(CtAnnotation<? extends Annotation> annotation) {
        if (this.annotations == CtElementImpl.EMPTY_LIST()) {
            this.annotations = new ArrayList<CtAnnotation<? extends Annotation>>();
        }
        return this.annotations.add(annotation);
    }

    @Override
    public boolean removeAnnotation(CtAnnotation<? extends Annotation> annotation) {
        return this.annotations.remove(annotation);
    }

    @Override
    public void setDocComment(String docComment) {
        this.docComment = docComment;
    }

    @Override
    public void setParent(CtElement parentElement) {
        this.parent = parentElement;
    }

    @Override
    public void setPosition(SourcePosition position) {
        this.position = position;
    }

    @Override
    public void setPositions(final SourcePosition position) {
        this.accept(new CtScanner(){

            @Override
            public void enter(CtElement e) {
                e.setPosition(position);
            }
        });
    }

    public String toString() {
        DefaultJavaPrettyPrinter printer = new DefaultJavaPrettyPrinter(this.getFactory().getEnvironment());
        printer.computeImports(this);
        printer.scan(this);
        return printer.toString();
    }

    @Override
    public <E extends CtElement> List<E> getAnnotatedChildren(Class<? extends Annotation> annotationType) {
        return Query.getElements(this, new AnnotationFilter<CtElement>(CtElement.class, annotationType));
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    @Override
    public Set<CtTypeReference<?>> getReferencedTypes() {
        TypeReferenceScanner s = new TypeReferenceScanner();
        s.scan(this);
        return s.getReferences();
    }

    @Override
    public <E extends CtElement> List<E> getElements(Filter<E> filter) {
        return Query.getElements(this, filter);
    }

    @Override
    public <T extends CtReference> List<T> getReferences(ReferenceFilter<T> filter) {
        return Query.getReferences(this, filter);
    }

    @Override
    public void updateAllParentsBelow() {
        new ModelConsistencyChecker(this.getFactory().getEnvironment(), true, true).scan(this);
    }

    @Override
    public boolean isParentInitialized() {
        return this.parent != null;
    }

    private static class RootElement
    extends CtElementImpl {
        private static final long serialVersionUID = 1L;
        protected static RootElement ROOT = new RootElement();

        private RootElement() {
        }

        @Override
        public void accept(CtVisitor visitor) {
        }

        @Override
        public CtElement getParent() throws ParentNotInitializedException {
            return null;
        }
    }
}

