/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.Launcher;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.reference.CtReferenceImpl;
import spoon.support.reflect.reference.CtTypeReferenceImpl;
import spoon.support.util.RtHelper;

public class CtExecutableReferenceImpl<T>
extends CtReferenceImpl
implements CtExecutableReference<T> {
    private static final long serialVersionUID = 1L;
    boolean stat = false;
    List<CtTypeReference<?>> actualTypeArguments = CtElementImpl.EMPTY_LIST();
    CtTypeReference<?> declaringType;
    CtTypeReference<T> type;
    List<CtTypeReference<?>> parameters = CtElementImpl.EMPTY_LIST();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtExecutableReference(this);
    }

    @Override
    public List<CtTypeReference<?>> getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public boolean isConstructor() {
        return this.getSimpleName().equals("<init>");
    }

    @Override
    public CtExecutable<T> getDeclaration() {
        CtType typeDecl = (CtType)this.getDeclaringType().getDeclaration();
        if (typeDecl == null) {
            return null;
        }
        CtMethod method = typeDecl.getMethod(this.getSimpleName(), this.parameters.toArray(new CtTypeReferenceImpl[this.parameters.size()]));
        if (method == null && typeDecl instanceof CtClass && this.getSimpleName().equals("<init>")) {
            try {
                return ((CtClass)typeDecl).getConstructor(this.parameters.toArray(new CtTypeReferenceImpl[this.parameters.size()]));
            }
            catch (ClassCastException e) {
                Launcher.logger.error(e.getMessage(), e);
            }
        }
        return method;
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public CtTypeReference<T> getType() {
        return this.type;
    }

    @Override
    public List<CtTypeReference<?>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public void setParameters(List<CtTypeReference<?>> parameters) {
        if (this.parameters == CtElementImpl.EMPTY_LIST()) {
            this.parameters = new ArrayList();
            this.parameters.addAll(parameters);
        }
    }

    @Override
    public <S extends T> CtExecutableReference<S> getOverridingExecutable(CtTypeReference<?> subType) {
        if (subType == null || subType.equals(this.getDeclaringType())) {
            return null;
        }
        CtType t = (CtType)subType.getDeclaration();
        if (t == null) {
            return null;
        }
        if (!(t instanceof CtClass)) {
            return null;
        }
        CtClass c = (CtClass)t;
        for (CtMethod<?> m : c.getMethods()) {
            if (!m.getReference().isOverriding(this)) continue;
            return m.getReference();
        }
        return this.getOverridingExecutable(c.getSuperclass());
    }

    @Override
    public boolean isOverriding(CtExecutableReference<?> executable) {
        if (!this.getDeclaringType().isSubtypeOf(executable.getDeclaringType())) {
            return false;
        }
        return this.getSimpleName().equals(executable.getSimpleName());
    }

    @Override
    public void setActualTypeArguments(List<CtTypeReference<?>> actualTypeArguments) {
        this.actualTypeArguments = actualTypeArguments;
    }

    @Override
    public void setDeclaringType(CtTypeReference<?> declaringType) {
        this.declaringType = declaringType;
    }

    @Override
    public void setType(CtTypeReference<T> type) {
        this.type = type;
    }

    @Override
    protected AnnotatedElement getActualAnnotatedElement() {
        if (this.isConstructor()) {
            return this.getActualConstructor();
        }
        return this.getActualMethod();
    }

    @Override
    public Method getActualMethod() {
        List<CtTypeReference<?>> parameters = this.getParameters();
        block0: for (Method m : this.getDeclaringType().getActualClass().getDeclaredMethods()) {
            if (!m.getDeclaringClass().isSynthetic() && m.isSynthetic() || !m.getName().equals(this.getSimpleName()) || m.getParameterTypes().length != parameters.size()) continue;
            for (int i = 0; i < parameters.size(); ++i) {
                if (m.getParameterTypes()[i] != parameters.get(i).getActualClass()) continue block0;
            }
            return m;
        }
        return null;
    }

    @Override
    public Constructor<?> getActualConstructor() {
        List<CtTypeReference<?>> parameters = this.getParameters();
        block0: for (Constructor<?> c : this.getDeclaringType().getActualClass().getDeclaredConstructors()) {
            if (c.getParameterTypes().length != parameters.size()) continue;
            for (int i = 0; i < parameters.size(); ++i) {
                if (c.getParameterTypes()[i] != parameters.get(i).getActualClass()) continue block0;
            }
            return c;
        }
        return null;
    }

    @Override
    public boolean isStatic() {
        return this.stat;
    }

    @Override
    public void setStatic(boolean b) {
        this.stat = b;
    }

    @Override
    public boolean isFinal() {
        CtElement e = this.getDeclaration();
        if (e != null) {
            if (e instanceof CtMethod) {
                return ((CtMethod)e).hasModifier(ModifierKind.FINAL);
            }
            if (e instanceof CtConstructor) {
                return ((CtConstructor)e).hasModifier(ModifierKind.FINAL);
            }
            return false;
        }
        Method m = this.getActualMethod();
        return m != null && Modifier.isFinal(m.getModifiers());
    }

    public Set<ModifierKind> getModifiers() {
        CtElement e = this.getDeclaration();
        if (e != null) {
            if (e instanceof CtMethod) {
                return ((CtMethod)e).getModifiers();
            }
            if (e instanceof CtConstructor) {
                return ((CtConstructor)e).getModifiers();
            }
            return CtElementImpl.EMPTY_SET();
        }
        Method m = this.getActualMethod();
        if (m != null) {
            return RtHelper.getModifiers(m.getModifiers());
        }
        Constructor<?> c = this.getActualConstructor();
        if (c != null) {
            return RtHelper.getModifiers(c.getModifiers());
        }
        return new TreeSet<ModifierKind>();
    }

    @Override
    public CtExecutableReference<?> getOverridingExecutable() {
        CtTypeReference<?> st = this.getDeclaringType().getSuperclass();
        CtTypeReference<Object> objectType = this.getFactory().Type().createReference(Object.class);
        if (st == null) {
            return this.getOverloadedExecutable(objectType, objectType);
        }
        return this.getOverloadedExecutable(st, objectType);
    }

    private CtExecutableReference<?> getOverloadedExecutable(CtTypeReference<?> t, CtTypeReference<Object> objectType) {
        if (t == null) {
            return null;
        }
        for (CtExecutableReference<?> e : t.getDeclaredExecutables()) {
            if (!this.isOverriding(e)) continue;
            return e;
        }
        if (t.equals(objectType)) {
            return null;
        }
        CtTypeReference<?> st = t.getSuperclass();
        if (st == null) {
            return this.getOverloadedExecutable(objectType, objectType);
        }
        return this.getOverloadedExecutable(t.getSuperclass(), objectType);
    }

    @Override
    public boolean addActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (this.actualTypeArguments == CtElementImpl.EMPTY_LIST()) {
            this.actualTypeArguments = new ArrayList();
        }
        return this.actualTypeArguments.add(actualTypeArgument);
    }

    @Override
    public boolean removeActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (this.actualTypeArguments == CtElementImpl.EMPTY_LIST()) {
            return false;
        }
        return this.actualTypeArguments.remove(actualTypeArgument);
    }
}

