/*
 * Decompiled with CFR 0.152.
 */
package smcsampler;

import ev.ex.TreeGenerators;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import fig.basic.UnorderedPair;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.mcmc.PhyloSampler;
import pty.mcmc.ProposalDistribution;
import pty.mcmc.UnrootedTreeState;
import pty.smc.ParticleKernel;

public class AnnealingKernel
implements ParticleKernel<UnrootedTreeState> {
    @Option
    public static double AnnealDeltaProposalRate = 10.0;
    @Option
    public static int nAnnealing = 500;
    @Option
    public static boolean useSteppingStone = true;
    @Option
    public static boolean printBranchLengthMagnitudes = false;
    private final UnrootedTreeState initial;
    private boolean lastIter = false;
    private double temperature = 0.0;
    private double newtemperature = 0.0;
    private double temperatureDifference = 1.0 / (double)nAnnealing;
    private int currentIter = 0;
    private LinkedList<ProposalDistribution> proposalDistributions = null;
    private ProposalDistribution.Options proposalOptions = ProposalDistribution.Util._defaultProposalDistributionOptions;

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double getTemperatureDifference() {
        return this.temperatureDifference;
    }

    public void setTemperatureDifference(double temperatureDifference) {
        this.temperatureDifference = temperatureDifference;
        this.newtemperature = Math.min(this.temperature + temperatureDifference, 1.0);
        LogInfo.logs((Object)("newtemperature: " + this.newtemperature));
        if (this.newtemperature == 1.0) {
            this.lastIter = true;
        }
    }

    public AnnealingKernel(UnrootedTreeState initial, LinkedList<ProposalDistribution> proposalDistributions, ProposalDistribution.Options proposalOptions) {
        this.initial = initial;
        this.proposalDistributions = proposalDistributions;
        this.proposalOptions = proposalOptions;
    }

    public UnrootedTreeState getInitial() {
        return this.initial;
    }

    public boolean isLastIter() {
        return this.lastIter;
    }

    public Object _next(Random rand, UnrootedTreeState current, boolean isPeek) {
        if (this.temperature == 0.0) {
            RootedTree proprosedRTree = TreeGenerators.sampleCoalescent((Random)rand, (List)current.getUnrootedTree().leaves(), (boolean)false);
            UnrootedTreeState proposedState = current.copyAndChange(UnrootedTree.fromRooted((RootedTree)proprosedRTree));
            this.temperature = this.newtemperature;
            Double logw = this.temperatureDifference * (proposedState.logLikelihood() + this.prior(proposedState.getNonClockTree()));
            return Pair.makePair((Object)proposedState, (Object)logw);
        }
        PhyloSampler sampler = new PhyloSampler();
        sampler.init(current);
        ProposalDistribution proposal = null;
        UnrootedTreeState proposedState = null;
        while (proposal == null) {
            proposal = this.nextProposal(rand);
            Pair result = proposal.propose(current.getNonClockTree(), rand);
            if (result == null) continue;
            proposedState = current.copyAndChange((UnrootedTree)result.getFirst());
            double logProposalRatio = (Double)result.getSecond();
            double currentPrior = current.getLogPrior();
            double proposePrior = proposedState.getLogPrior();
            double logLikRatio = this.newtemperature * (proposePrior + proposedState.getLogLikelihood()) - this.newtemperature * (currentPrior + current.getLogLikelihood());
            double ratio = Math.min(1.0, Math.exp(logProposalRatio + logLikRatio));
            if (Double.isNaN(ratio)) {
                throw new RuntimeException();
            }
            if (!(rand.nextDouble() >= ratio)) continue;
            proposedState = current;
        }
        this.temperature = this.newtemperature;
        double logw = 0.0;
        logw = useSteppingStone ? this.temperatureDifference * current.logLikelihood() : this.temperatureDifference * (current.logLikelihood() + this.prior(current.getNonClockTree()));
        return Pair.makePair((Object)proposedState, (Object)logw);
    }

    public Pair<UnrootedTreeState, Double> next(Random rand, UnrootedTreeState current) {
        return (Pair)this._next(rand, current, false);
    }

    public int nIterationsLeft(UnrootedTreeState partialState) {
        return nAnnealing;
    }

    public void setCurrentIter(int currentIter) {
        this.currentIter = currentIter;
    }

    public int getCurrentIter() {
        return this.currentIter;
    }

    private void sample(Random rand, UnrootedTreeState currentState) {
    }

    private ProposalDistribution nextProposal(Random rand) {
        if (this.proposalDistributions.isEmpty()) {
            this.proposalDistributions.addAll(ProposalDistribution.Util.proposalList((ProposalDistribution.Options)this.proposalOptions, (UnrootedTree)this.initial.getNonClockTree(), (Random)rand));
        }
        return this.proposalDistributions.get(rand.nextInt(this.proposalDistributions.size()));
    }

    private double prior(UnrootedTree urt) {
        double result = 0.0;
        for (UnorderedPair edge : urt.edges()) {
            result += Sampling.exponentialLogDensity((double)(1.0 / AnnealDeltaProposalRate), (double)urt.branchLength(edge));
        }
        return result;
    }
}

