/*
 * Decompiled with CFR 0.152.
 */
package smcsampler;

import conifer.trees.StandardNonClockPriorDensity;
import ev.ex.DataGenerator;
import ev.ex.PhyloSamplerMain;
import ev.ex.TreeGenerators;
import ev.to.NJ;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import fig.prob.Distrib;
import fig.prob.Gamma;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import ma.MSAParser;
import ma.SequenceType;
import monaco.Density;
import monaco.process.ProcessSchedule;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.math.StatisticsMap;
import nuts.util.CollUtils;
import nuts.util.Counter;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.io.Dataset;
import pty.io.TreeEvaluator;
import pty.mcmc.PhyloSampler;
import pty.mcmc.ProposalDistribution;
import pty.mcmc.UnrootedTreeState;
import pty.pmcmc.PhyloPFSchedule;
import pty.smc.NCPriorPriorKernel;
import pty.smc.PartialCoalescentState;
import pty.smc.PriorPriorKernel;
import pty.smc.models.CTMC;
import smcsampler.AnnealingKernel;
import smcsampler.MrBayes;
import smcsampler.ParticleFilterSMCSampler;
import smcsampler.TreeDistancesProcessor;

public class SMCSamplerExperiments
implements Runnable {
    @Option
    public boolean resampleRoot = false;
    @Option
    public InferenceMethod refMethod = InferenceMethod.MB;
    @Option
    public double nThousandIters = 10.0;
    @Option
    public ArrayList<InferenceMethod> methods = CollUtils.list(Arrays.asList(InferenceMethod.MB, InferenceMethod.ANNEALING));
    @Option
    public ArrayList<Double> iterScalings = CollUtils.list(Arrays.asList(1.0));
    @Option
    public int refIterScaling = 100;
    @Option
    public int repPerDataPt = 1;
    @Option
    public double pmcmcSMCExpMix = 0.6666666666666666;
    @Option
    public double treeRatePrior = 1.0;
    public static DataGenerator.DataGeneratorMain generator = new DataGenerator.DataGeneratorMain();
    public static PhyloSamplerMain samplerMain = new PhyloSamplerMain();
    @Option
    public static Random mainRand = new Random(3L);
    @Option
    public boolean verbose = false;
    @Option
    public int nThreads = 1;
    @Option
    public int maxNUniqueParticles = Integer.MAX_VALUE;
    @Option
    public int finalMaxNUniqueParticles = Integer.MAX_VALUE;
    @Option
    public int nParticlesEachStep = 1000;
    @Option
    public double parameter_a = 1.2;
    @Option
    public double a_alpha = 1.5;
    @Option
    public double a_statFreqs = 100.0;
    @Option
    public double a_subsRates = 100.0;
    @Option
    public double a_pInv = 0.2;
    @Option
    public double pmmhPgsExpMix = 0.05;
    @Option
    public double burninPercent = 0.2;
    @Option
    public int sampleTreeEveryNIter = 500;
    @Option
    public String RcommandDir = "/Users/lwa68/workspace/alpha-liangliang/Rcode/";
    @Option
    public boolean useDataGenerator = true;
    @Option
    public File dataFile = null;
    @Option
    public File refTree = null;
    @Option
    public String dataDirName = "output";
    @Option
    public SequenceType sequenceType = SequenceType.RNA;
    @Option
    public boolean isPMCMC4clock = true;
    @Option
    public boolean useNJinfo = false;
    @Option
    public boolean useTopologyProcessor = false;
    @Option
    public boolean saveTreesFromPMCMC = false;
    @Option
    public String nameOfAllTrees = "allTrees.trees";
    @Option
    public double csmc_trans2tranv = 2.0;
    @Option
    public double smcmcmcMix = 0.5;
    @Option
    public boolean betterStartVal = true;
    @Option
    public ParticleFilterSMCSampler.ResamplingStrategy resamplingStrategy = ParticleFilterSMCSampler.ResamplingStrategy.ESS;
    @Option
    public int nCSMC = 10;
    @Option
    public int nUCSMC = 10;
    @Option
    public boolean adaptiveTempDiff = false;
    @Option
    public int adaptiveType = 0;
    @Option
    public double alphaSMCSampler = 0.95;
    @Option
    public double essRatioThreshold = 0.7;
    private int nAnnealing = 5000;
    public File data = null;
    private File output = null;
    private RootedTree goldrt;
    private PrintWriter logZout = null;

    public static void main(String[] args) {
        IO.run((String[])args, (Object[])new Object[]{new SMCSamplerExperiments(), "pcs", PartialCoalescentState.class, "mb", MrBayes.instance, "gen", generator, "mcmc", samplerMain, "prop", ProposalDistribution.Util._defaultProposalDistributionOptions, "phylo", PhyloSampler._defaultPhyloSamplerOptions, "prior", PhyloSampler._defaultPriorOptions, "nj", NJ.class, "nc", NCPriorPriorKernel.class, "priorprior", PriorPriorKernel.class, "annealingKernel", AnnealingKernel.class});
    }

    protected void treeComparison() {
        this.logZout = IOUtils.openOutEasy((File)new File(Execution.getFile((String)"results"), "logZout.csv"));
        this.logZout.println(CSV.header((Object[])new Object[]{"treeName", "logZ", "varLogZ"}));
        PrintWriter out = IOUtils.openOutEasy((File)new File(this.output, "results.csv"));
        out.println(CSV.header((Object[])new Object[]{"Method", "Adaptive", "AdaptiveType", "T", "IterScale", "Repeat", "Metric", "Value", "TreeName", "Time"}));
        List files = null;
        files = this.useDataGenerator ? IO.ls((File)SMCSamplerExperiments.generator.output, (String)"msf") : IO.ls((File)new File(Execution.getFile((String)this.dataDirName)), (String)"msf");
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File f;
            this.data = f = (File)iterator.next();
            String treeName = f.getName();
            LogInfo.track((Object)("Current tree:" + treeName));
            UnrootedTree goldut = SMCSamplerExperiments.generator.useGutellData || !this.useDataGenerator ? (this.refTree == null ? null : UnrootedTree.fromRooted((RootedTree)RootedTree.Util.fromNewickString((String)IO.f2s((File)this.refTree)))) : UnrootedTree.fromRooted((RootedTree)RootedTree.Util.fromNewickString((String)IO.f2s((File)new File(f.getAbsolutePath().replaceAll("[.]msf$", ".newick")))));
            File computedRefTrees = new File(Execution.getFile((String)"computed-ref-trees"));
            InferenceMethod m = InferenceMethod.ANNEALING;
            int nRun = 1;
            if (this.adaptiveTempDiff) {
                nRun = 2;
            }
            int nIter = Integer.MIN_VALUE;
            for (int i = 0; i < nRun; ++i) {
                double iterScale = this.iterScalings.get(0);
                LogInfo.track((Object)("Current method:" + (Object)((Object)m) + " with iterScale=" + iterScale + " (i.e. " + iterScale * this.nThousandIters * 1000.0 + " iterations)"));
                StatisticsMap.DescriptiveStatisticsMap stats = new StatisticsMap.DescriptiveStatisticsMap();
                for (int j = 0; j < this.repPerDataPt; ++j) {
                    String treeNameCurrentRep = treeName;
                    if (m == InferenceMethod.ANNEALING) {
                        treeNameCurrentRep = treeNameCurrentRep + "adaptive" + this.adaptiveTempDiff + ".Rep" + j;
                    }
                    LogInfo.track((Object)("Repeat " + (j + 1) + "/" + this.repPerDataPt));
                    long time = System.currentTimeMillis();
                    TreeDistancesProcessor processor = m.doIt(this, iterScale, goldut, treeNameCurrentRep);
                    time = System.currentTimeMillis() - time;
                    LogInfo.forceSilent = false;
                    UnrootedTree inferred = processor.getConsensus();
                    IO.writeToDisk((File)new File(this.output, "consensus_" + treeName.replaceAll("[.]msf$", ".newick")), (String)inferred.toNewick());
                    Dataset dataset = Dataset.DatasetUtils.fromAlignment((File)this.data, (SequenceType)this.sequenceType);
                    CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)dataset.nSites());
                    UnrootedTreeState ncs = UnrootedTreeState.initFastState((UnrootedTree)inferred, (Dataset)dataset, (CTMC)ctmc);
                    out.println(CSV.body((Object[])new Object[]{m, this.adaptiveTempDiff, this.adaptiveType, this.nAnnealing, iterScale, j, "ConsensusLogLL", ncs.logLikelihood(), treeName, time}));
                    double bestLogLL = processor.getBestLogLikelihood();
                    out.println(CSV.body((Object[])new Object[]{m, this.adaptiveTempDiff, this.adaptiveType, this.nAnnealing, iterScale, j, "BestSampledLogLL", bestLogLL, treeName, time}));
                    if (goldut == null) {
                        LogInfo.logsForce((Object)("Computing gold tree using " + (Object)((Object)this.refMethod)));
                        goldut = this.refMethod.doIt(this, this.refIterScaling, goldut, treeName).getConsensus();
                        computedRefTrees.mkdir();
                        File current = new File(computedRefTrees, "computedRefTree_" + f.getName().replaceAll("[.]msf", "") + ".newick");
                        IO.writeToDisk((File)current, (String)goldut.toNewick());
                    }
                    for (TreeEvaluator.TreeMetric tm : TreeEvaluator.coreTreeMetrics) {
                        double value = tm.score(inferred, goldut);
                        stats.addValue((Object)tm.toString(), value);
                        out.println(CSV.body((Object[])new Object[]{m, this.adaptiveTempDiff, this.adaptiveType, this.nAnnealing, iterScale, j, tm, value, treeName, time}));
                    }
                    LogInfo.end_track();
                }
                LogInfo.track((Object)("Score for current block of repeats (Method=" + (Object)((Object)m) + ",IterScale=" + iterScale + ",TreeName=" + treeName + ")"));
                for (TreeEvaluator.TreeMetric tm : TreeEvaluator.coreTreeMetrics) {
                    LogInfo.logsForce((Object)("Current " + tm + ":" + stats.median((Object)tm.toString())));
                }
                LogInfo.end_track();
                out.flush();
                LogInfo.end_track();
                if (i < nRun - 1 && this.nAnnealing > nIter) {
                    nIter = this.nAnnealing;
                }
                if (i != nRun - 2) continue;
                AnnealingKernel.nAnnealing = nIter;
                this.adaptiveTempDiff = false;
                this.adaptiveType = 0;
            }
            LogInfo.end_track();
        }
        out.close();
        this.logZout.close();
    }

    public static <T> double dist(Counter<T> c1, Counter<T> c2) {
        double sum = 0.0;
        for (Object t : CollUtils.union((Set[])new Set[]{c1.keySet(), c2.keySet()})) {
            sum += Math.abs(c1.getCount(t) - c2.getCount(t));
        }
        return sum;
    }

    public static double dist(TreeDistancesProcessor p1, TreeDistancesProcessor p2) {
        return SMCSamplerExperiments.dist(p1.getUnrootedCladesPosterior(), p2.getUnrootedCladesPosterior());
    }

    @Override
    public void run() {
        if (this.methods.size() != this.iterScalings.size()) {
            throw new RuntimeException("Number of methods and scaling iters should match");
        }
        if (this.useDataGenerator) {
            LogInfo.logsForce((Object)"Generating data...");
            LogInfo.forceSilent = false;
            generator.run();
        } else {
            LogInfo.forceSilent = false;
            File dataDir = new File(Execution.getFile((String)this.dataDirName));
            LogInfo.logsForce((Object)("Copying data to " + dataDir));
            dataDir.mkdir();
            String str = IO.call((String)("/bin/cp " + this.dataFile + " " + dataDir + "/" + this.dataFile.getName()));
            LogInfo.logs((Object)str);
        }
        this.output = new File(Execution.getFile((String)"results"));
        this.output.mkdir();
        this.treeComparison();
    }

    public static enum InferenceMethod {
        MB{

            @Override
            public TreeDistancesProcessor doIt(SMCSamplerExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                MrBayes mb = MrBayes.instance;
                mb.nChains = 1;
                mb.seed = mainRand.nextInt();
                mb.nMCMCIters = (int)(iterScale * instance.nThousandIters * 1000.0);
                if (mb.fixGTRGammaPara) {
                    mb.alpha = SMCSamplerExperiments.generator.alpha;
                    mb.subsRates = SMCSamplerExperiments.generator.subsRates;
                    mb.stationaryDistribution = SMCSamplerExperiments.generator.stationaryDistribution;
                }
                mb.computeSamples(MSAParser.parseMSA((File)instance.data), instance.sequenceType);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                mb.processMrBayesTrees(tdp, 1);
                return tdp;
            }
        }
        ,
        ANNEALING{

            @Override
            public TreeDistancesProcessor doIt(SMCSamplerExperiments instance, double iterScale, UnrootedTree goldut, String treeName) {
                ParticleFilterSMCSampler<UnrootedTreeState> pc = new ParticleFilterSMCSampler<UnrootedTreeState>();
                pc.N = (int)(iterScale * instance.nThousandIters * 1000.0);
                pc.setEss(pc.N);
                pc.nThreads = instance.nThreads;
                pc.resampleLastRound = true;
                pc.rand = mainRand;
                pc.verbose = instance.verbose;
                pc.setProcessSchedule((ProcessSchedule)new PhyloPFSchedule());
                pc.resamplingStrategy = instance.resamplingStrategy;
                pc.adaptiveTempDiff = instance.adaptiveTempDiff;
                pc.alpha = instance.alphaSMCSampler;
                ParticleFilterSMCSampler.essRatioThreshold = instance.essRatioThreshold;
                pc.adaptiveType = instance.adaptiveType;
                String filename = "essTempDiffDeterministic.csv";
                if (instance.adaptiveTempDiff) {
                    filename = "essTempDiffAdaptive" + instance.adaptiveType + ".csv";
                }
                pc.smcSamplerOut = IOUtils.openOutEasy((File)new File(instance.output, filename));
                List leaves = MSAParser.parseMSA((File)instance.data).taxa();
                RootedTree initTree = TreeGenerators.sampleExpNonclock((Random)mainRand, (int)leaves.size(), (double)10.0);
                Gamma exponentialPrior = Gamma.exponential((double)10.0);
                StandardNonClockPriorDensity priorDensity = new StandardNonClockPriorDensity((Distrib)exponentialPrior);
                Dataset dataset = Dataset.DatasetUtils.fromAlignment((File)instance.data, (SequenceType)instance.sequenceType);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC((int)dataset.nSites());
                UnrootedTreeState ncts = UnrootedTreeState.initFastState((UnrootedTree)UnrootedTree.fromRooted((RootedTree)initTree), (Dataset)dataset, (CTMC)ctmc, (Density)priorDensity);
                System.out.println(ncts.getLogPrior());
                ProposalDistribution.Options proposalOptions = ProposalDistribution.Util._defaultProposalDistributionOptions;
                LinkedList<ProposalDistribution> proposalDistributions = new LinkedList<ProposalDistribution>();
                AnnealingKernel ppk = new AnnealingKernel(ncts, proposalDistributions, proposalOptions);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                pc.sample(ppk, tdp);
                instance.logZout.println(CSV.body((Object[])new Object[]{treeName, pc.estimateNormalizer(), pc.estimateNormalizerVariance()}));
                instance.logZout.flush();
                LogInfo.track((Object)"Estimation of log(Z) ");
                LogInfo.logsForce((Object)("Estimate of log(Z): " + pc.estimateNormalizer() + "; Estimate of variance of log(Z): " + pc.estimateNormalizerVariance()));
                LogInfo.end_track();
                instance.nAnnealing = ppk.getCurrentIter();
                return tdp;
            }
        };


        abstract TreeDistancesProcessor doIt(SMCSamplerExperiments var1, double var2, UnrootedTree var4, String var5);
    }
}

