/*
 * Decompiled with CFR 0.152.
 */
package smcsampler;

import conifer.Phylogeny;
import conifer.particle.PhyloParticle;
import ev.ex.NJPState;
import ev.poi.PoissonModel;
import ev.poi.PoissonSampleProcessor;
import ev.poi.SampleContext;
import ev.to.NJ;
import fig.basic.LogInfo;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import nuts.util.Counter;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.smc.LazyPCS;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import smcsampler.ParticleFilterSMCSampler;

public class TreeDistancesProcessor
implements PoissonSampleProcessor,
RootedTree.RootedTreeProcessor,
UnrootedTree.UnrootedTreeProcessor,
ParticleFilter.ParticleProcessor,
Serializable,
ParticleFilterSMCSampler.ParticleProcessor {
    private static final long serialVersionUID = 1L;
    private final Counter<UnorderedPair<Taxon, Taxon>> _meanDistances = new Counter();
    private double norm = 0.0;
    private List<Taxon> taxa = null;
    private double bestLogLikelihood = Double.NEGATIVE_INFINITY;
    private Phylogeny best = null;
    public double lastLogLikelihood;
    public Phylogeny lastPhylo;

    public Phylogeny getMode() {
        return this.best;
    }

    public double getBestLogLikelihood() {
        return this.bestLogLikelihood;
    }

    public Counter<UnorderedPair<Taxon, Taxon>> getUnrootedCladesPosterior() {
        Counter result = new Counter();
        for (UnorderedPair key : this._meanDistances.keySet()) {
            result.setCount((Object)key, this._meanDistances.getCount((Object)key) / this.norm);
        }
        return result;
    }

    public UnrootedTree getConsensus() {
        return this.getConsensus(false);
    }

    public UnrootedTree getConsensus(boolean useNinja) {
        UnrootedTree njTree = NJ.inferTree(this.getUnrootedCladesPosterior());
        return UnrootedTree.removeZeroes((UnrootedTree)njTree);
    }

    public void process(PoissonModel sample, SampleContext context) {
        this.process(sample.currentUnrooted());
    }

    public void process(RootedTree rt) {
        this.process(UnrootedTree.fromRooted((RootedTree)rt));
    }

    public void process(UnrootedTree ut) {
        this.norm += 1.0;
        this._process(ut, 1.0);
    }

    public void process(Object state, double weight) {
        if (state instanceof LazyPCS) {
            state = ((LazyPCS)state).getState();
        }
        if (state instanceof PartialCoalescentState) {
            this.process(UnrootedTree.fromRooted((RootedTree)((PartialCoalescentState)state).getFullCoalescentState()), weight);
            double currentLogLL = ((PartialCoalescentState)state).logLikelihood();
            if (currentLogLL > this.bestLogLikelihood) {
                this.best = ((PartialCoalescentState)state).getFullCoalescentState();
                this.bestLogLikelihood = currentLogLL;
            }
        } else if (state instanceof PhyloParticle) {
            PhyloParticle pp = (PhyloParticle)state;
            this.process(pp.getPhylogeny().getUnrooted(), weight);
            double currentLogLL = pp.getLogLikelihood();
            if (currentLogLL > this.bestLogLikelihood) {
                LogInfo.logsForce((Object)("better LL found: " + this.bestLogLikelihood + " -> [ ll(" + currentLogLL + ") + lp(" + pp.getLogPrior() + ") = " + (currentLogLL + pp.getLogPrior()) + " ]"));
                LogInfo.logsForce((Object)("ll" + currentLogLL));
                this.best = pp.getPhylogeny();
                this.bestLogLikelihood = currentLogLL;
            }
            this.lastLogLikelihood = currentLogLL;
            this.lastPhylo = pp.getPhylogeny();
        } else if (state instanceof NJPState) {
            this.process(((NJPState)state).pcs, weight);
        } else {
            throw new RuntimeException();
        }
    }

    public void process(UnrootedTree t, double w) {
        this.norm += w;
        this._process(t, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _process(UnrootedTree ut, double w) {
        if (this.taxa == null) {
            this.taxa = ut.leaves();
        }
        Counter c = ut.allTotalBranchLengthDistances();
        TreeDistancesProcessor treeDistancesProcessor = this;
        synchronized (treeDistancesProcessor) {
            for (Map.Entry keyPair : c.entries.entrySet()) {
                double count = (Double)keyPair.getValue();
                UnorderedPair key = (UnorderedPair)keyPair.getKey();
                this._meanDistances.incrementCount((Object)key, w * count);
            }
        }
    }

    public Counter<UnorderedPair<Taxon, Taxon>> getMeanDistances() {
        return new Counter(this._meanDistances);
    }
}

