/*
 * Decompiled with CFR 0.152.
 */
package conifer.clock.proposals;

import conifer.clock.ClockTree;
import conifer.clock.proposals.ClockTreeProposal;
import fig.basic.Pair;
import goblin.Taxon;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import nuts.math.Sampling;
import nuts.util.CollUtils;

public class GlobalScaleProposal
implements ClockTreeProposal {
    private final double a;

    public GlobalScaleProposal(double a) {
        this.a = a;
    }

    @Override
    public Pair<ClockTree, Double> propose(Random rand, ClockTree tree) {
        if (this.a <= 1.0) {
            throw new RuntimeException();
        }
        double m = Sampling.nextDouble(rand, 1.0 / this.a, this.a);
        HashMap<Set<Taxon>, Double> newHeights = CollUtils.map();
        for (Set<Taxon> tax : tree.nodes()) {
            newHeights.put(tax, m * tree.height(tax));
        }
        return Pair.makePair(new ClockTree(newHeights), Math.log(m));
    }

    @Override
    public String description() {
        return "GlobalScaleProposal(" + this.a + ")";
    }
}

