/*
 * Decompiled with CFR 0.152.
 */
package conifer.evol;

import conifer.evol.EvolutionaryFactoryContext;
import conifer.evol.EvolutionaryOptions;
import conifer.evol.EvolutionaryParameters;
import conifer.evol.PIPLikelihoodModel;
import conifer.evol.SimpleSubstitutionLikelihoodModel;
import conifer.evol.TKF91Model;

public enum EvolutionaryModel {
    PIP{

        @Override
        public EvolutionaryParameters instantiateParameters(EvolutionaryOptions evoOptions, EvolutionaryFactoryContext context) {
            return new PIPLikelihoodModel(evoOptions);
        }
    }
    ,
    TKF91{

        @Override
        public EvolutionaryParameters instantiateParameters(EvolutionaryOptions evoOptions, EvolutionaryFactoryContext context) {
            return new TKF91Model(evoOptions);
        }
    }
    ,
    SIMPLE_SUBSTITUTION{

        @Override
        public EvolutionaryParameters instantiateParameters(EvolutionaryOptions evoOptions, EvolutionaryFactoryContext context) {
            return new SimpleSubstitutionLikelihoodModel(evoOptions, context);
        }
    };


    public abstract EvolutionaryParameters instantiateParameters(EvolutionaryOptions var1, EvolutionaryFactoryContext var2);
}

