/*
 * Decompiled with CFR 0.152.
 */
package conifer.evol;

import conifer.Phylogeny;
import conifer.data.AlignedData;
import conifer.data.PhylogeneticData;
import conifer.data.TaxonDatum;
import conifer.evol.CalculatorOptions;
import conifer.evol.EvolutionaryOptions;
import conifer.evol.EvolutionaryParameters;
import conifer.evol.SimpleSubstitutionLikelihoodModel;
import conifer.msa.TreeMSAParameters;
import conifer.pip.LinearizedAlignment;
import conifer.pip.PIPForwardSampler;
import ev.poi.PoissonParameters;
import java.util.Random;
import ma.MSAPoset;
import pty.RootedTree;
import pty.smc.models.LikelihoodModelCalculator;

public class PIPLikelihoodModel
implements EvolutionaryParameters,
TreeMSAParameters {
    public final PoissonParameters params;
    final SimpleSubstitutionLikelihoodModel subModel;
    final Random generateRandom;

    public String toString() {
        double intensity = PoissonParameters.getIndelIntensityParameterForAdditiveIntensityParam(this.params.insertRate, this.params.deleteRate);
        double expLen = PoissonParameters.getAsymptoticLengthParameterForAdditiveIntensityParam(this.params.insertRate, this.params.deleteRate);
        return "PIP(expLen=" + expLen + ",intens=" + intensity + ")";
    }

    public PIPLikelihoodModel(EvolutionaryOptions options) {
        this.subModel = new SimpleSubstitutionLikelihoodModel(options);
        this.params = new PoissonParameters(this.subModel.indexer, this.subModel.rateMatrix, options.pipParamType.getLambda(options.pipParam1, options.pipParam2), options.pipParamType.getMu(options.pipParam1, options.pipParam2));
        this.generateRandom = options.rand;
    }

    public PIPLikelihoodModel(PoissonParameters params, SimpleSubstitutionLikelihoodModel subModel, Random generateRandom) {
        this.params = params;
        this.subModel = subModel;
        this.generateRandom = generateRandom;
    }

    public PIPLikelihoodModel copyWithNewRateMtx(double[][] newRateMtx) {
        SimpleSubstitutionLikelihoodModel newSubm = this.subModel.copyWithNewRateMtx(newRateMtx);
        PoissonParameters newParams = new PoissonParameters(this.subModel.indexer, newRateMtx, this.params.insertRate, this.params.deleteRate);
        return new PIPLikelihoodModel(newParams, newSubm, this.generateRandom);
    }

    public PIPLikelihoodModel copyWithNewIntensity(double newIntensity) {
        double lenParam = PoissonParameters.getAsymptoticLengthParameterForAdditiveIntensityParam(this.params.insertRate, this.params.deleteRate);
        double newLambda = PoissonParameters.getInsertionRateFromAdditiveIntensityParam(lenParam, newIntensity);
        double newMu = PoissonParameters.getDeleteRateFromAdditiveIntensityParam(lenParam, newIntensity);
        PoissonParameters newPoissonParam = PoissonParameters.copyWithNewInsertDeleteRate(this.params, newLambda, newMu);
        return new PIPLikelihoodModel(newPoissonParam, this.subModel, this.generateRandom);
    }

    public PIPLikelihoodModel copyWithNewLen(double newLen) {
        double intParam = PoissonParameters.getIndelIntensityParameterForAdditiveIntensityParam(this.params.insertRate, this.params.deleteRate);
        double newLambda = PoissonParameters.getInsertionRateFromAdditiveIntensityParam(newLen, intParam);
        double newMu = PoissonParameters.getDeleteRateFromAdditiveIntensityParam(newLen, intParam);
        PoissonParameters newPoissonParam = PoissonParameters.copyWithNewInsertDeleteRate(this.params, newLambda, newMu);
        return new PIPLikelihoodModel(newPoissonParam, this.subModel, this.generateRandom);
    }

    @Override
    public PhylogeneticData generate(Phylogeny p) {
        PIPForwardSampler sampler = new PIPForwardSampler(this.params, p.getRooted());
        MSAPoset msa = sampler.sampleMSA(this.generateRandom);
        return new PhylogeneticData(p, new AlignedData(msa, this.subModel.sequenceType), msa, this);
    }

    @Override
    public LikelihoodModelCalculator createModelCalculator(CalculatorOptions calcOptions, TaxonDatum leafDatum) {
        return null;
    }

    @Override
    public double getLogLikelihood(LinearizedAlignment linearizedAlignment, RootedTree tree) {
        return this.params.getLogLikelihood(linearizedAlignment, tree);
    }

    public static class SequenceDatum
    implements TaxonDatum {
        public final String str;

        public SequenceDatum(String str) {
            this.str = str;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.str == null ? 0 : this.str.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SequenceDatum other = (SequenceDatum)obj;
            return !(this.str == null ? other.str != null : !this.str.equals(other.str));
        }

        public String toString() {
            return this.str;
        }
    }
}

