/*
 * Decompiled with CFR 0.152.
 */
package conifer.ml;

import com.google.gson.Gson;
import conifer.ml.RateMtxExpectations;
import conifer.ml.data.PhylogeneticHeldoutDataset;
import conifer.multicategories.PhylogeneticFactorGraph;
import conifer.multicategories.PhylogenyPotentials;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.StrUtils;
import goblin.Taxon;
import java.io.File;
import nuts.io.IO;
import nuts.util.Arbre;

public class ComputePosteriorMain
implements Runnable {
    @Option(required=true)
    public String branchOutput;
    @Option(required=true)
    public String rootOutput;
    @Option
    public String branchLenOutput = "";
    @Option(required=true)
    public String parametersPath;
    @Option
    public boolean outputCTMCStatistics = true;
    @Option
    public String obsErrorOutput = "";
    private static final PhylogeneticHeldoutDataset.PhylogeneticHeldoutDatasetOptions phyloOptions = ComputePosteriorMain.defaultPhylo();

    public static void main(String[] args) {
        IO.runLight(args, new ComputePosteriorMain(), "data", phyloOptions);
    }

    @Override
    public void run() {
        PhylogeneticHeldoutDataset phyloData = PhylogeneticHeldoutDataset.loadData(phyloOptions);
        PhylogenyPotentials potentials = PhylogenyPotentials.fromDisk(new File(this.parametersPath));
        PhylogeneticFactorGraph factorGraph = new PhylogeneticFactorGraph(phyloData.rootedTree, potentials, phyloData.obs);
        LogInfo.logsForce("dataLogLikelihoodGivenTreeAndParameters = " + factorGraph.dataLogLikelihoodGivenTreeAndParameters());
        this.rootPosteriors(factorGraph);
        this.branchPosteriors(factorGraph);
        if (!StrUtils.isEmpty(this.branchLenOutput)) {
            IO.writeToDisk(this.branchLenOutput, new Gson().toJson(factorGraph.rootedTree.branchLengths()));
        }
        if (!StrUtils.isEmpty(this.obsErrorOutput)) {
            IO.writeToDisk(this.obsErrorOutput, "" + factorGraph.observationErrorCount());
        }
    }

    private void rootPosteriors(PhylogeneticFactorGraph factorGraph) {
        double[][] result = factorGraph.getNodePosteriorSummingOverSites(factorGraph.rootedTree.topology().getContents());
        IO.writeToDisk(this.rootOutput, new Gson().toJson((Object)result));
    }

    private void branchPosteriors(PhylogeneticFactorGraph factorGraph) {
        File outdir = new File(this.branchOutput);
        outdir.mkdir();
        for (Arbre<Taxon> subtree : factorGraph.rootedTree.topology().nodes()) {
            if (subtree.isRoot()) continue;
            File branchFile = new File(outdir, subtree.getContents().toString() + ".json");
            double[][][] currentCounts = factorGraph.getPairwisePosterior(subtree.getParent().getContents(), subtree.getContents());
            IO.writeToDisk(branchFile, new Gson().toJson((Object)currentCounts));
            if (!this.outputCTMCStatistics) continue;
            File ctmcStatFile = new File(outdir, subtree.getContents().toString() + "-ctmcStatistics.json");
            double[][][] currentCTMCStats = new double[factorGraph.nCategories][][];
            for (int c = 0; c < factorGraph.nCategories; ++c) {
                double[][] rateMtx = factorGraph.potentials.rateMatrices[c];
                double T = factorGraph.rootedTree.branchLengths().get(subtree.getContents());
                double[][] marginalCounts = currentCounts[c];
                double[][] result = RateMtxExpectations.expectations(marginalCounts, rateMtx, T);
                currentCTMCStats[c] = result;
            }
            IO.writeToDisk(ctmcStatFile, new Gson().toJson((Object)currentCTMCStats));
        }
    }

    private static PhylogeneticHeldoutDataset.PhylogeneticHeldoutDatasetOptions defaultPhylo() {
        PhylogeneticHeldoutDataset.PhylogeneticHeldoutDatasetOptions result = new PhylogeneticHeldoutDataset.PhylogeneticHeldoutDatasetOptions();
        result.holdOutFre = 0.0;
        result.alignmentFile = "";
        result.treeFile = "";
        return result;
    }
}

