/*
 * Decompiled with CFR 0.152.
 */
package conifer.ml.tests;

import conifer.Phylogeny;
import conifer.data.DataModel;
import conifer.data.DataOptions;
import conifer.data.PhylogeneticData;
import conifer.fastmetrics.CladeMetrics;
import conifer.fastpf.FastParticle;
import conifer.fastpf.FastPriorPrior;
import conifer.fastpf.TaxaOrderHeuristic;
import conifer.largemove.LargeMoveKernel;
import conifer.largemove.TestClimbLikelihood;
import conifer.multicategories.PhylogeneticFactorGraph;
import conifer.spr.SPROperator;
import ev.poi.processors.TreeDistancesProcessor;
import ev.to.MrBayes;
import fig.basic.Option;
import fig.basic.OptionSet;
import gep.util.OutputManager;
import goblin.Taxon;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ma.RateMatrixLoader;
import ma.SequenceType;
import nuts.io.IO;
import pty.UnrootedTree;
import pty.io.Dataset;
import pty.smc.LazyParticleFilter;
import pty.smc.ParticleFilter;
import pty.smc.models.CTMC;

public class TestSynthData
implements Runnable {
    @OptionSet(name="data")
    public DataOptions syntheticOptions = new DataOptions();
    @Option
    public Random rand = new Random(1L);
    @OptionSet(name="largeK")
    public LargeMoveKernel.LargeMoveKernelOptions largeKernelOptions = new LargeMoveKernel.LargeMoveKernelOptions();
    @OptionSet(name="prior")
    public FastPriorPrior.SimplePriorOptions priorOptions = new FastPriorPrior.SimplePriorOptions();
    @OptionSet(name="pf")
    public ParticleFilter pf = new ParticleFilter();
    @Option
    public InferenceType inferenceType = InferenceType.NEW;
    @OptionSet(name="mb")
    public MrBayes mb = new MrBayes();
    @OptionSet(name="oldpfo")
    public FastPriorPrior.FastPriorPriorOptions pfKernelOptions = new FastPriorPrior.FastPriorPriorOptions();
    @OptionSet(name="lazyPF")
    public LazyParticleFilter.ParticleFilterOptions pfOptions = new LazyParticleFilter.ParticleFilterOptions();
    protected double[][] rateMtx;
    private PhylogeneticData data;
    private Dataset msa;

    public static void main(String[] args) {
        IO.run(args, new TestSynthData());
    }

    @Override
    public void run() {
        this.data = DataModel.GENERATED.loadDataset(this.syntheticOptions);
        this.msa = (Dataset)((Object)this.data.getObservedTaxonIndexData());
        this.rateMtx = RateMatrixLoader.k2p();
        TreeDistancesProcessor tdp = this.inferenceType.doIt(this);
        HashMap<String, UnrootedTree> recons = new HashMap<String, UnrootedTree>();
        UnrootedTree consensus = tdp.getConsensus(true);
        recons.put("consensus", consensus);
        if (tdp.getMode() != null) {
            UnrootedTree ml = tdp.getMode().getUnrooted();
            recons.put("maxLikelihood", ml);
        }
        OutputManager output = new OutputManager();
        for (String method : recons.keySet()) {
            Map<CladeMetrics.TreeMetric, Double> metrics = CladeMetrics.computeTreeMetrics(this.data.getPhylogeny(), (Phylogeny)recons.get(method));
            for (CladeMetrics.TreeMetric m : metrics.keySet()) {
                output.printWrite("metrics", new Object[]{"method", method, "metric", m, "value", metrics.get((Object)m)});
            }
        }
        output.close();
    }

    public static enum InferenceType {
        MB{

            @Override
            TreeDistancesProcessor doIt(TestSynthData instance) {
                instance.mb.computeSamples(instance.data.getMsa(), SequenceType.RNA);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                instance.mb.processMrBayesTrees(tdp, 1);
                instance.mb.cleanUpMrBayesOutput();
                return tdp;
            }
        }
        ,
        OLD{

            @Override
            TreeDistancesProcessor doIt(TestSynthData instance) {
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                List<Taxon> order = TaxaOrderHeuristic.heuristicOrder(instance.msa.observations());
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(instance.msa.nSites());
                FastParticle fp = FastParticle.initFastParticle(instance.msa.observations(), ctmc, order);
                FastPriorPrior fpp = new FastPriorPrior(fp, instance.pfKernelOptions, instance.priorOptions);
                LazyParticleFilter<FastParticle> filter = new LazyParticleFilter<FastParticle>(fpp, instance.pfOptions);
                filter.sample(tdp);
                return tdp;
            }
        }
        ,
        NEW{

            @Override
            TreeDistancesProcessor doIt(TestSynthData instance) {
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                List<Taxon> order = TaxaOrderHeuristic.heuristicOrder(instance.msa.observations());
                LargeMoveKernel.LargeMoveParticle init = TestClimbLikelihood.starInit(order.subList(0, 3), instance.rand, instance.msa.observations().keySet().size());
                PhylogeneticFactorGraph pfg = PhylogeneticFactorGraph.createSingleCategoryFromStationaryProcess(SPROperator.starInitialization(order.subList(0, 3), 0.2), instance.rateMtx, instance.msa);
                LargeMoveKernel lmk = new LargeMoveKernel(instance.largeKernelOptions, instance.priorOptions, init, pfg.potentials.categoryPriors, pfg.potentials.rateMatrices, pfg.observations, pfg.potentials.stationaryDistributions, 0.0, order);
                instance.pf.sample(lmk, tdp);
                return tdp;
            }
        };


        abstract TreeDistancesProcessor doIt(TestSynthData var1);
    }
}

