/*
 * Decompiled with CFR 0.152.
 */
package conifer.msa;

import conifer.msa.InformedProposal;
import conifer.msa.InformedProposals;
import conifer.msa.MSAUtils;
import ev.io.PreprocessGutellData;
import ev.par.ExponentialFamily;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import ma.GreedyDecoder;
import ma.MSAPoset;
import ma.RateMatrixLoader;
import nuts.io.IO;
import nuts.math.Plot2D;
import nuts.util.CollUtils;
import nuts.util.Counter;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class PosteriorSpectrumTest
implements Runnable {
    @Option
    Random rand = new Random(1L);
    @Option
    File alignFile = new File("/Users/bouchard/Documents/experiments/pip/data/gutell/raw/5S.3.alnfasta");
    @Option
    public int nRep = 10;
    @Option
    public int nTax = 10;
    @Option
    public boolean testSpectrum = false;
    @Option
    public boolean testHighRecallProp = true;
    ExponentialFamily expFam;
    List<MSAPoset> datasets;

    public static void main(String[] args) {
        IO.run(args, new PosteriorSpectrumTest());
    }

    @Override
    public void run() {
        this.datasets = PreprocessGutellData.randomDataSet(this.alignFile, this.nRep, this.nTax, this.rand);
        this.expFam = MSAUtils.loadBasicRNAAligner();
        if (this.testSpectrum) {
            this.spectrumXP();
        }
        if (this.testHighRecallProp) {
            this.testHighRecallProposal();
        }
    }

    public void testHighRecallProposal() {
        boolean index = false;
        for (MSAPoset msa : this.datasets) {
            msa.fixMSAUsingRandomCharacters(RateMatrixLoader.rnaIndexer().objects(), this.rand);
            InformedProposals proposals = new InformedProposals(0.9);
            proposals.prepare(msa.sequences(), this.expFam);
            for (Pair<Taxon, Taxon> key : proposals.proposals.keySet()) {
                InformedProposal prop = proposals.proposals.get(key);
                System.out.println(prop.ambiguousPositions.size() + "/" + msa.sequences().get(key.getFirst()).length());
                SummaryStatistics lenSum = new SummaryStatistics();
                for (Integer subKey : prop.ambiguousPositions) {
                    lenSum.addValue((double)prop.probabilities.getCounter(subKey).size());
                }
                System.out.println(lenSum.getMean());
                System.out.println();
            }
        }
    }

    public void spectrumXP() {
        int j = 0;
        for (MSAPoset msa : this.datasets) {
            msa.fixMSAUsingRandomCharacters(RateMatrixLoader.rnaIndexer().objects(), this.rand);
            Counter<GreedyDecoder.Edge> post = this.expFam.allPairsPosterior(msa.sequences());
            HashSet<GreedyDecoder.Edge> edges = CollUtils.set(msa.edges());
            double denom = edges.size();
            Plot2D.Plot2DOptions options = new Plot2D.Plot2DOptions();
            options.xlogscale = true;
            options.axesWidth = 1;
            Plot2D plot = new Plot2D(options);
            ArrayList<Pair<Double, Double>> posteriorsSeries = CollUtils.list();
            ArrayList<Pair<Double, Double>> edgeRecallSeries = CollUtils.list();
            double i = 0.0;
            double num = 0.0;
            for (GreedyDecoder.Edge e : post) {
                if (edges.contains(e)) {
                    num += 1.0;
                }
                double d = i;
                i = d + 1.0;
                if (d % 1000.0 != 0.0) continue;
                posteriorsSeries.add(Pair.makePair(i, post.getCount(e)));
                edgeRecallSeries.add(Pair.makePair(i, num / denom));
            }
            plot.addSeries(posteriorsSeries, "posteriors");
            plot.addSeries(edgeRecallSeries, "recalls");
            File out = new File(Execution.getFile("plot" + ++j + ".pdf"));
            plot.savePlot(out);
        }
    }
}

