/*
 * Decompiled with CFR 0.152.
 */
package conifer.multicategories;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import ma.RateMatrixLoader;
import nuts.io.IO;
import nuts.math.RateMtxUtils;

public class PhylogenyPotentials {
    public final double[] categoryPriors;
    public final double[][][] rateMatrices;
    public final double[][] stationaryDistributions;
    public final double observationErrorProbability;

    public PhylogenyPotentials(double[] categoryPriors, double[][][] rateMatrices, double[][] stationaryDistributions, double observationErrorProbability) {
        this.categoryPriors = categoryPriors;
        this.rateMatrices = rateMatrices;
        this.stationaryDistributions = stationaryDistributions;
        this.observationErrorProbability = observationErrorProbability;
    }

    public static PhylogenyPotentials createSingleCategoryErrorFreeFromStationaryProcess(double[][] rateMatrix) {
        double[] catPriors = new double[]{1.0};
        double[][][] rateMatrices = new double[][][]{rateMatrix};
        return PhylogenyPotentials.createFromStationaryProcess(catPriors, rateMatrices, 0.0);
    }

    public static PhylogenyPotentials createFromStationaryProcess(double[] categoryPriors, double[][][] rateMatrices, double observationError) {
        int nCat = rateMatrices.length;
        double[][] stationaryMatrices = new double[nCat][];
        for (int c = 0; c < nCat; ++c) {
            stationaryMatrices[c] = RateMtxUtils.getStationaryDistribution(rateMatrices[c]);
        }
        return new PhylogenyPotentials(categoryPriors, rateMatrices, stationaryMatrices, observationError);
    }

    public void writeToDisk(File f) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonOutput = gson.toJson((Object)this);
        IO.writeToDisk(f, jsonOutput);
    }

    public static PhylogenyPotentials fromDisk(File f) {
        Gson gson = new Gson();
        return (PhylogenyPotentials)gson.fromJson(IO.f2s(f), PhylogenyPotentials.class);
    }

    public static void main(String[] args) {
        PhylogenyPotentials pp = PhylogenyPotentials.createSingleCategoryErrorFreeFromStationaryProcess(RateMatrixLoader.k2p());
        File test = new File("/Users/bouchard/Documents/web/public_html/pri/k2p-param.json");
        pp.writeToDisk(test);
        PhylogenyPotentials pp2 = PhylogenyPotentials.fromDisk(test);
        System.out.println(new Gson().toJson((Object)pp2));
    }
}

