/*
 * Decompiled with CFR 0.152.
 */
package conifer.ssm;

import conifer.ssm.Edit;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ma.GreedyDecoder;
import ma.MSAPoset;

public class Utils {
    public static MSAPoset toAlign(String first, List<Edit> edits) {
        return Utils.toAlign(first, edits, null, null, "");
    }

    public static MSAPoset toAlign(String first, List<Edit> edits, Taxon topTax, Taxon botTax, String intermediatePrefix) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(first);
        for (Edit e : edits) {
            strings.add(e.newSeq);
        }
        return Utils.toAlign(strings, topTax, botTax, intermediatePrefix);
    }

    private static Taxon getLabel(List<String> edits, int i, Taxon topTax, Taxon botTax, String intermediatePrefix) {
        if (topTax != null && i == 0) {
            return topTax;
        }
        if (botTax != null && i == edits.size() - 1) {
            return botTax;
        }
        return new Taxon(intermediatePrefix + i);
    }

    private static MSAPoset toAlign(List<String> edits, Taxon topTax, Taxon botTax, String intermediatePrefix) {
        if (topTax != null && botTax != null && edits.size() == 1) {
            edits.add(edits.get(0));
        }
        HashMap<Taxon, String> sequences = new HashMap<Taxon, String>();
        for (int i = 0; i < edits.size(); ++i) {
            sequences.put(Utils.getLabel(edits, i, topTax, botTax, intermediatePrefix), edits.get(i));
        }
        MSAPoset result = new MSAPoset(sequences);
        for (int i = 0; i < edits.size() - 1; ++i) {
            Taxon l1 = Utils.getLabel(edits, i, topTax, botTax, intermediatePrefix);
            Taxon l2 = Utils.getLabel(edits, i + 1, topTax, botTax, intermediatePrefix);
            String s1 = edits.get(i);
            String s2 = edits.get(i + 1);
            int delta = s2.length() - s1.length();
            int offSet1 = 0;
            int offSet2 = 0;
            for (int p = 0; p < Math.min(s1.length(), s2.length()); ++p) {
                char c2;
                char c1 = Utils.safeCharAt(s1, p + offSet1);
                if (c1 != (c2 = Utils.safeCharAt(s2, p + offSet2)) && delta != 0) {
                    if (delta > 0) {
                        offSet2 = delta;
                    } else {
                        offSet1 = -delta;
                    }
                }
                if (result.tryAdding(new GreedyDecoder.Edge(p + offSet1, p + offSet2, l1, l2))) continue;
                throw new RuntimeException();
            }
        }
        return result;
    }

    private static char safeCharAt(String s2, int p) {
        if (p < s2.length()) {
            return s2.charAt(p);
        }
        return '-';
    }

    public static void main(String[] args) {
        String s = "0123456789";
        Edit sub = Edit.substitution(s, 4, 'x');
        System.out.println(sub);
        Edit ssmI = Edit.ssmInsert(s, 4, 3);
        System.out.println(ssmI);
        Edit ssmD = Edit.ssmDelete(ssmI.newSeq, 4, 3);
        System.out.println(ssmD);
    }
}

