/*
 * Decompiled with CFR 0.152.
 */
package conifer.trees;

import conifer.Phylogeny;
import conifer.particle.TreeProvider;
import conifer.trees.TreeModel;
import fig.basic.Option;
import fig.prob.Distrib;
import fig.prob.Gamma;
import java.io.File;
import java.util.Random;
import nuts.io.IO;
import nuts.io.OutputProducer;
import nuts.io.SimpleOutputProducer;

public class TreeOptions
implements TreeProvider,
OutputProducer {
    @Option
    public TreeModel model = TreeModel.STANDARD_NON_CLOCK;
    @Option
    public Random rand = new Random(1L);
    @Option(gloss="Number of taxa if generating from this model (ignored otherwise)")
    public int nTaxa = 10;
    @Option
    public double rate = 10.0;
    private SimpleOutputProducer output = new SimpleOutputProducer();

    public Distrib<Double> getBranchDistribution() {
        return Gamma.exponential(this.rate);
    }

    @Override
    public Phylogeny getTree() {
        Phylogeny p = this.model.sample(this);
        File f = new File(this.output.getOutputFolder(), "tree.newick");
        IO.writeToDisk(f, p.getUnrooted().toNewick());
        return p;
    }

    @Override
    public void setOutputFolder(File f) {
        this.output.setOutputFolder(f);
    }
}

