/*
 * Decompiled with CFR 0.152.
 */
package emc;

import emc.EntangledStatistics;
import emc.SimulateEMC;
import ev.ex.GetPhylogeneticKernel;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import java.io.File;
import java.io.PrintWriter;
import java.util.Random;
import monaco.process.ProcessSchedule;
import nuts.io.IO;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;

public class SpeedupExperiments
implements Runnable {
    @Option(required=true)
    public int numTaxa;
    @Option(required=true)
    public int numSites;
    @Option
    public String datafile = null;
    @Option(required=true)
    public int iter;
    @Option(required=true)
    public int Km;
    @Option(required=true)
    public Random seed1 = new Random(1L);
    @Option(required=true)
    public Random seed2 = new Random(1L);
    @Option(required=true)
    public String outputpath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SimulateEMC.Allocation[] allocations = new SimulateEMC.Allocation[]{SimulateEMC.Allocation.FirstOpen, SimulateEMC.Allocation.MostAvailable, SimulateEMC.Allocation.Random, SimulateEMC.Allocation.Chaos};
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new File(this.outputpath + "/" + this.datafile + "_" + SpeedupExperiments.class.getName() + ".txt"));
            writer.println("M K Speedup Allocation");
            for (int j = 0; j < allocations.length; ++j) {
                SimulateEMC.scheme = allocations[j];
                for (int i = 1; i <= this.iter; ++i) {
                    int M = (int)Math.pow(2.0, i);
                    int K = this.Km * M;
                    LogInfo.logs("M=" + M + " " + (Object)((Object)allocations[j]));
                    ParticleKernel<PartialCoalescentState> kernel = this.datafile == null ? GetPhylogeneticKernel.getPhyloKernel(this.numTaxa, this.numSites) : GetPhylogeneticKernel.getPhyloKernel(this.numTaxa, "data/" + this.datafile);
                    ParticleFilter.DoNothingProcessor processor = new ParticleFilter.DoNothingProcessor();
                    ProcessSchedule schedule = null;
                    int R = kernel.nIterationsLeft(kernel.getInitial());
                    SimulateEMC<PartialCoalescentState> emc = new SimulateEMC<PartialCoalescentState>(K, M, this.Km, this.seed1.nextInt(), this.seed2.nextInt(), kernel, processor, schedule);
                    for (int r = 0; r < R; ++r) {
                        emc.propagate();
                        emc.resampleAndAllocate();
                    }
                    Pair<Double, Integer> reconstructionStat = EntangledStatistics.getEntangledStatistics().getReconstructionStat();
                    double totalReconstructions = reconstructionStat.getFirst();
                    double ratio = 1.0 + totalReconstructions / (double)(R * K);
                    LogInfo.logs(M + " " + K + " " + (double)M / ratio + " " + allocations[j].toString());
                    writer.println(M + " " + K + " " + (double)M / ratio + " " + allocations[j].toString());
                    EntangledStatistics.getEntangledStatistics().reset();
                }
            }
        }
    }

    public static void main(String[] args) {
        IO.run(args, new SpeedupExperiments());
    }
}

