/*
 * Decompiled with CFR 0.152.
 */
package emc;

import emc.Timer;
import fig.basic.LogInfo;
import fig.basic.Option;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import nuts.io.IO;
import nuts.util.CollUtils;

public class TestTransferSpeed
implements Runnable {
    @Option(required=true)
    public int nodeId;
    @Option(required=true)
    public int bootstrapPort;
    @Option(required=true)
    public String bootstrapIp;
    private Timer timer = new Timer();
    private Timer cumTimer = new Timer(true);
    private List<Long> longs = CollUtils.list();
    private ServerSocket serverSocket = null;

    public void sendFile(int fileSizeInBytes) throws IOException {
        if (this.longs.isEmpty()) {
            int numBytesInLong = 8;
            LogInfo.logs("number of bytes in long:" + numBytesInLong);
            int numLongsToProduce = fileSizeInBytes / numBytesInLong;
            for (int i = 0; i < numLongsToProduce; ++i) {
                this.longs.add(new Long(i));
            }
        }
        this.cumTimer.begin();
        this.timer.begin();
        Socket socket = new Socket(this.bootstrapIp, this.bootstrapPort);
        ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
        oos.writeObject(this.longs);
        oos.flush();
        oos.close();
        socket.close();
        LogInfo.logs("Sending particle takes: " + this.timer.elapsedTimeInMillis() + " milliseconds.");
        this.cumTimer.pause();
    }

    public void receiveFile() throws IOException, ClassNotFoundException {
        if (this.serverSocket == null) {
            this.serverSocket = new ServerSocket(this.bootstrapPort);
        }
        Socket socket = this.serverSocket.accept();
        this.cumTimer.begin();
        this.timer.begin();
        ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
        List longs = (List)ois.readObject();
        LogInfo.logs("The last long received=" + longs.get(longs.size() - 1));
        ois.close();
        socket.close();
        LogInfo.logs("Receiving particle takes: " + this.timer.elapsedTimeInMillis() + " milliseconds.");
        this.cumTimer.pause();
    }

    public void sizeOfLong() {
        LogInfo.logs("size of long:64 bits");
        LogInfo.logs("size of long:8 bytes");
    }

    @Override
    public void run() {
        this.sizeOfLong();
        double numRuns = 100.0;
        int i = 0;
        while ((double)i < numRuns) {
            try {
                if (this.nodeId == 0) {
                    this.receiveFile();
                } else {
                    this.sendFile(1024);
                }
            }
            catch (Exception ex) {
                LogInfo.logs(ex);
            }
            ++i;
        }
        double average = this.cumTimer.elapsedTimeInMillis() / numRuns;
        LogInfo.logs("cumulative time = " + this.cumTimer.elapsedTimeInMillis() + " milliseconds.");
        if (this.nodeId == 0) {
            LogInfo.logs("average receive time=" + average + " milliseconds.");
        } else {
            LogInfo.logs("average send time=" + average + " milliseconds.");
        }
    }

    public static void main(String[] args) {
        TestTransferSpeed tts = new TestTransferSpeed();
        tts.sizeOfLong();
        IO.run(args, new TestTransferSpeed());
    }
}

