/*
 * Decompiled with CFR 0.152.
 */
package emc;

public class Timer {
    private long start;
    private long now;
    private long cumulative;
    private boolean isCumulativeTimer = false;

    public Timer() {
    }

    public Timer(boolean isCumulativeTimer) {
        this.isCumulativeTimer = isCumulativeTimer;
        this.cumulative = 0L;
    }

    public static double milliToMinutes(long milliseconds) {
        double seconds = Timer.milliToSeconds(milliseconds);
        double minutes = seconds / 60.0;
        return minutes;
    }

    public static double milliToMinutes(double milliseconds) {
        double seconds = Timer.milliToSeconds(milliseconds);
        double minutes = seconds / 60.0;
        return minutes;
    }

    public static double milliToSeconds(long milliseconds) {
        double seconds = (double)milliseconds / 1000.0;
        return seconds;
    }

    public static double milliToSeconds(double milliseconds) {
        double seconds = milliseconds / 1000.0;
        return seconds;
    }

    public void begin() {
        this.start = System.nanoTime();
    }

    public void pause() {
        this.cumulative += System.nanoTime() - this.start;
    }

    public static double nanoToMillis(long nanoseconds) {
        double ret = (double)nanoseconds / Math.pow(10.0, 6.0);
        return ret;
    }

    public double elapsedTimeInMillis() {
        if (this.isCumulativeTimer) {
            return Timer.nanoToMillis(this.cumulative);
        }
        this.now = System.nanoTime();
        return Timer.nanoToMillis(this.now - this.start);
    }

    public double elapsedTimeInMinutes() {
        this.now = System.nanoTime();
        return Timer.milliToMinutes(Timer.nanoToMillis(this.now - this.start));
    }

    public double cumulativeTimeInMinutes() {
        return Timer.milliToMinutes(Timer.nanoToMillis(this.cumulative));
    }
}

