/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.ex.TreeGenerators;
import ev.poi.processors.TreeDistancesProcessor;
import fig.basic.Option;
import goblin.Taxon;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import ma.MSAParser;
import ma.SequenceType;
import nuts.io.IO;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.mcmc.PhyloSampler;
import pty.mcmc.ProposalDistribution;
import pty.mcmc.UnrootedTreeState;

public class PhyloSamplerMain
implements Runnable {
    @Option
    public File alignmentInputFile = null;
    @Option
    public SequenceType st = SequenceType.RNA;
    @Option
    public Random initTreeRandom = new Random(2L);
    private PhyloSampler sampler = null;
    public UnrootedTree consensus = null;
    public TreeDistancesProcessor tdp = null;

    @Override
    public void run() {
        this.sampler = new PhyloSampler();
        this.sampler.setOutputText(true);
        List<Taxon> leaves = MSAParser.parseMSA(this.alignmentInputFile).taxa();
        RootedTree initTree = TreeGenerators.sampleCoalescent(this.initTreeRandom, leaves, false);
        UnrootedTreeState ncts = UnrootedTreeState.fromAlignment(UnrootedTree.fromRooted(initTree), this.alignmentInputFile, this.st);
        this.sampler.init(ncts);
        this.tdp = new TreeDistancesProcessor();
        PhyloSampler.PhyloProcessorAdaptor tdpa = new PhyloSampler.PhyloProcessorAdaptor(this.tdp);
        this.sampler.setProcessors(Arrays.asList(tdpa));
        this.sampler.sampleManyTimes();
        this.consensus = this.tdp.getConsensus();
    }

    public static void main(String[] args) {
        IO.run(args, new PhyloSamplerMain(), "prop", ProposalDistribution.Util._defaultProposalDistributionOptions, "phylo", PhyloSampler._defaultPhyloSamplerOptions, "prior", PhyloSampler._defaultPriorOptions);
    }
}

