/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import goblin.CognateId;
import goblin.ReadEval;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.ling.TIPAConversion;
import nuts.math.Sampling;
import nuts.tui.Table;
import nuts.util.CollUtils;
import nuts.util.Counter;
import pepper.Corpus;

public class StratifiedSampling {
    private static Random rand = new Random(1L);
    private static double nBins = 10.0;

    public static void main(String[] args) throws IOException {
        Map<CognateId, ReadEval.Evaluation> evals = ReadEval.read("GOBLIN-19.eval");
        Map<CognateId, ReadEval.Evaluation> base = ReadEval.read("RANDOM.eval");
        Counter<Integer> counter = new Counter<Integer>();
        for (ReadEval.Evaluation eval : evals.values()) {
            counter.incrementCount(StratifiedSampling.getBin(eval), 1.0);
        }
        counter.normalize();
        Table t = new Table();
        t.set(0, 0, "Distance");
        t.set(0, 1, "Gloss");
        t.set(0, 2, "Reference");
        t.set(0, 3, "Baseline");
        t.set(0, 4, "Automatic");
        int max = -1;
        Iterator iterator = counter.keySet().iterator();
        while (iterator.hasNext()) {
            int c = (Integer)iterator.next();
            if (c <= max) continue;
            max = c;
        }
        HashSet picked = CollUtils.set();
        double cum = 0.0;
        int i = 1;
        for (int loss = 0; loss <= max; ++loss) {
            cum += counter.getCount(loss);
            boolean first = true;
            while (cum >= 1.0 / nBins) {
                if (first) {
                    t.set(i, 0, loss);
                }
                ReadEval.Evaluation eval = StratifiedSampling.sampleWithoutReplacement(evals, loss);
                picked.add(eval.id);
                t.set(i, 1, "" + eval.id);
                t.set(i, 2, "" + TIPAConversion.surroundConvert(eval.truth, true));
                ReadEval.Evaluation curBase = base.get(eval.id);
                t.set(i, 3, "" + TIPAConversion.surroundConvert(curBase.recon, true));
                t.set(i, 4, "" + TIPAConversion.surroundConvert(eval.recon, true));
                ++i;
                cum -= 1.0 / nBins;
                first = false;
            }
        }
        IO.so(t.toLatex());
        Corpus c = Corpus.parse("/Users/bouchard/w/evolvere/data/austro/20100807/processed/All.cog");
        for (CognateId id : CollUtils.list(picked)) {
            if (!id.toString().contains("(1)")) continue;
            picked.add(new CognateId(id.toString().replace("1", "2")));
        }
        String prefix = "OUT2";
        ArrayList names = CollUtils.list();
        names.add("id");
        names.addAll(c.getFieldNames());
        IO.so("OUT2" + CSV.header(names));
        for (int row = 0; row < c.getNWords(); ++row) {
            CognateId current = c.getCognateId(row);
            if (!picked.contains(current)) continue;
            ArrayList currentLine = CollUtils.list();
            currentLine.add(current.toString());
            for (int col = 0; col < c.getNLangs(); ++col) {
                if (c.isKnown(row, col)) {
                    currentLine.add(c.getWord(row, col));
                    continue;
                }
                currentLine.add("");
            }
            IO.so("OUT2" + CSV.body(currentLine));
        }
    }

    private static ReadEval.Evaluation sampleWithoutReplacement(Map<CognateId, ReadEval.Evaluation> evals, int loss) {
        ArrayList candidates = CollUtils.list();
        for (CognateId id : evals.keySet()) {
            if (evals.get((Object)id).loss != (double)loss) continue;
            candidates.add(id);
        }
        CognateId sampled = (CognateId)Sampling.randomElt(candidates, rand);
        return evals.remove(sampled);
    }

    public static int getBin(ReadEval.Evaluation eval) {
        return (int)eval.loss;
    }
}

