/*
 * Decompiled with CFR 0.152.
 */
package facto;

import java.util.ArrayList;
import java.util.Random;
import nuts.tui.Table;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class Rasmussen {
    public static double permanent(double[][] mtx, Random rand, int nTrials) {
        int size = mtx.length;
        if (size == 0) {
            return 1.0;
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            if (mtx[0][i] != 1.0) continue;
            indices.add(i);
        }
        if (indices.size() == 0) {
            return 0.0;
        }
        DescriptiveStatistics stats = new DescriptiveStatistics();
        int rec = Math.max(1, nTrials / 2);
        for (int i = 0; i < nTrials; ++i) {
            int randomIndex = (Integer)indices.get(rand.nextInt(indices.size()));
            stats.addValue((double)indices.size() * Rasmussen.permanent(Rasmussen.minor(mtx, 0, randomIndex), rand, rec));
        }
        return stats.getPercentile(50.0);
    }

    public static double[][] moments(double[][] mtx, Random rand, int nTrials) {
        double[][] result = new double[mtx.length][mtx.length];
        double norm = Rasmussen.permanent(mtx, rand, nTrials);
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result.length; ++j) {
                result[i][j] = Rasmussen.moment(mtx, norm, i, j, rand, nTrials);
            }
        }
        return result;
    }

    public static double moment(double[][] mtx, double normalization, int row, int col, Random rand, int nTrials) {
        if (mtx[row][col] == 0.0) {
            return 0.0;
        }
        return Rasmussen.permanent(Rasmussen.minor(mtx, row, col), rand, nTrials) / normalization;
    }

    public static double[][] minor(double[][] mtx, int rowToRemove, int colToRemove) {
        int rowDim = mtx.length;
        int colDim = mtx[0].length;
        double[][] result = new double[rowDim - 1][colDim - 1];
        int newRow = 0;
        for (int i = 0; i < rowDim; ++i) {
            if (i == rowToRemove) continue;
            int newCol = 0;
            for (int j = 0; j < colDim; ++j) {
                if (j == colToRemove) continue;
                result[newRow][newCol] = mtx[i][j];
                ++newCol;
            }
            ++newRow;
        }
        return result;
    }

    public static void main(String[] args) {
        double[][] mtx = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}, {10.0, 11.0, 12.0}};
        System.out.println(Table.toString(mtx));
        System.out.println(Table.toString(Rasmussen.minor(mtx, 1, 1)));
    }
}

