/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multihmm;

import nuts.math.MtxUtils;
import nuts.tui.Table;

public class MultiInputHMM {
    public final double[][] transitions;
    public final double[] initialDistribution;
    public final double[] endingDistribution;
    public final double[][][] emissions;
    public final double[][][] transposedEmissions;

    public MultiInputHMM(double[][] transitions, double[] initialDistribution, double[] endingDistribution, double[][][] emissions) {
        this.transitions = transitions;
        this.initialDistribution = initialDistribution;
        this.endingDistribution = endingDistribution;
        this.emissions = emissions;
        this.transposedEmissions = new double[emissions.length][][];
        for (int i = 0; i < emissions.length; ++i) {
            this.transposedEmissions[i] = MtxUtils.transpose(emissions[i]);
        }
    }

    public int nInputs() {
        return this.emissions.length;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Trans:\n" + Table.toString(this.transitions));
        for (int i = 0; i < this.emissions.length; ++i) {
            result.append("emi-" + i + ":\n" + Table.toString(this.emissions[i]));
        }
        return result.toString();
    }
}

