/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multisitecat;

import fenchel.factor.BinaryFactor;
import fenchel.factor.FactorGraph;
import fenchel.factor.IdentityFactor;
import fenchel.factor.UnaryFactor;
import fenchel.factor.multisitecat.MSCBinaryScaledFactor;
import fenchel.factor.multisitecat.MSCUnaryScaledFactor;
import fig.basic.Pair;
import java.util.HashMap;
import java.util.Map;
import nuts.math.Graph;
import nuts.math.MutableGraph;

public class MSCFactorGraph<N>
implements FactorGraph<N> {
    private final int nCategories;
    private final int nSites;
    private final int nCharacters;
    private final MutableGraph<N> graph = new MutableGraph();
    private Map<Pair<N, N>, MSCBinaryScaledFactor> binaryFactors = new HashMap<Pair<N, N>, MSCBinaryScaledFactor>();
    private Map<N, MSCUnaryScaledFactor> unaryFactors = new HashMap<N, MSCUnaryScaledFactor>();

    public MSCFactorGraph(int nSites, int nCategories, int nCharacters) {
        this.nCategories = nCategories;
        this.nSites = nSites;
        this.nCharacters = nCharacters;
    }

    public void setBinary(int category, N node1, N node2, double[][] values) {
        for (int char1 = 0; char1 < this.nCharacters; ++char1) {
            for (int char2 = 0; char2 < this.nCharacters; ++char2) {
                this.setBinary(category, node1, char1, node2, char2, values[char1][char2]);
            }
        }
    }

    public void setBinary(int category, N node1, int char1, N node2, int char2, double value) {
        this._setBinary(category, node1, char1, node2, char2, value);
        this._setBinary(category, node2, char2, node1, char1, value);
    }

    public MSCUnaryScaledFactor getMSCUnary(N node) {
        MSCUnaryScaledFactor result = this.unaryFactors.get(node);
        if (result == null) {
            result = new MSCUnaryScaledFactor(this.nSites, this.nCategories, this.nCharacters);
            this.unaryFactors.put(node, result);
            this.graph.addVertex(node);
        }
        return result;
    }

    @Override
    public UnaryFactor getUnary(N node) {
        UnaryFactor result = this.unaryFactors.get(node);
        if (result == null) {
            return IdentityFactor.identity;
        }
        return result;
    }

    @Override
    public Graph<N> getTopology() {
        return this.graph;
    }

    @Override
    public BinaryFactor getBinary(N source, N destination) {
        return this.binaryFactors.get(Pair.makePair(source, destination));
    }

    private void _setBinary(int category, N sourceNode, int sourceChar, N destNode, int destChar, double value) {
        Pair<N, N> key = Pair.makePair(sourceNode, destNode);
        MSCBinaryScaledFactor current = this.binaryFactors.get(key);
        if (current == null) {
            current = new MSCBinaryScaledFactor(this.nSites, this.nCategories, this.nCharacters);
            this.binaryFactors.put(key, current);
            this.graph.addEdge(sourceNode, destNode);
        }
        current.set(category, sourceChar, destChar, value);
    }
}

